/* candidatepanel.c generated by valac 0.24.0, the Vala compiler
 * generated from candidatepanel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2014 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <ibus.h>
#include <string.h>
#include <cairo.h>
#include <stdlib.h>


#define TYPE_CANDIDATE_PANEL (candidate_panel_get_type ())
#define CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_PANEL, CandidatePanel))
#define CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_PANEL, CandidatePanelClass))
#define IS_CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_PANEL))
#define IS_CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_PANEL))
#define CANDIDATE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_PANEL, CandidatePanelClass))

typedef struct _CandidatePanel CandidatePanel;
typedef struct _CandidatePanelClass CandidatePanelClass;
typedef struct _CandidatePanelPrivate CandidatePanelPrivate;

#define TYPE_CANDIDATE_AREA (candidate_area_get_type ())
#define CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_AREA, CandidateArea))
#define CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_AREA, CandidateAreaClass))
#define IS_CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_AREA))
#define IS_CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_AREA))
#define CANDIDATE_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_AREA, CandidateAreaClass))

typedef struct _CandidateArea CandidateArea;
typedef struct _CandidateAreaClass CandidateAreaClass;

#define TYPE_HSEPARATOR (hseparator_get_type ())
#define HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HSEPARATOR, HSeparator))
#define HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HSEPARATOR, HSeparatorClass))
#define IS_HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HSEPARATOR))
#define IS_HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HSEPARATOR))
#define HSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HSEPARATOR, HSeparatorClass))

typedef struct _HSeparator HSeparator;
typedef struct _HSeparatorClass HSeparatorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_HANDLE (handle_get_type ())
#define HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HANDLE, Handle))
#define HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HANDLE, HandleClass))
#define IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HANDLE))
#define IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HANDLE))
#define HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HANDLE, HandleClass))

typedef struct _Handle Handle;
typedef struct _HandleClass HandleClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CandidatePanel {
	GtkBox parent_instance;
	CandidatePanelPrivate * priv;
};

struct _CandidatePanelClass {
	GtkBoxClass parent_class;
};

struct _CandidatePanelPrivate {
	gboolean m_vertical;
	GtkWindow* m_toplevel;
	GtkBox* m_vbox;
	GtkLabel* m_preedit_label;
	GtkLabel* m_aux_label;
	CandidateArea* m_candidate_area;
	HSeparator* m_hseparator;
	GdkRectangle m_cursor_location;
};


static gpointer candidate_panel_parent_class = NULL;

GType candidate_panel_get_type (void) G_GNUC_CONST;
GType candidate_area_get_type (void) G_GNUC_CONST;
GType hseparator_get_type (void) G_GNUC_CONST;
#define CANDIDATE_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CANDIDATE_PANEL, CandidatePanelPrivate))
enum  {
	CANDIDATE_PANEL_DUMMY_PROPERTY
};
CandidatePanel* candidate_panel_new (void);
CandidatePanel* candidate_panel_construct (GType object_type);
static gboolean __lambda8_ (CandidatePanel* self, GtkWidget* w, GdkEventButton* e);
void candidate_panel_set_vertical (CandidatePanel* self, gboolean vertical);
static gboolean ___lambda8__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void __lambda9_ (CandidatePanel* self, GtkWidget* w, GtkAllocation* a);
static void candidate_panel_adjust_window_position (CandidatePanel* self);
static void ___lambda9__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
GType handle_get_type (void) G_GNUC_CONST;
Handle* handle_new (void);
Handle* handle_construct (GType object_type);
static void candidate_panel_create_ui (CandidatePanel* self);
void candidate_area_set_vertical (CandidateArea* self, gboolean vertical, gboolean force);
static void candidate_panel_set_orientation (CandidatePanel* self, IBusOrientation orientation);
void candidate_panel_set_cursor_location (CandidatePanel* self, gint x, gint y, gint width, gint height);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t* s1, const cairo_rectangle_int_t* s2);
static void candidate_panel_set_labels (CandidatePanel* self, IBusText** labels, int labels_length1);
void candidate_area_set_labels (CandidateArea* self, IBusText** labels, int labels_length1);
void candidate_panel_set_preedit_text (CandidatePanel* self, IBusText* text, guint cursor);
static void candidate_panel_update (CandidatePanel* self);
void candidate_panel_set_auxiliary_text (CandidatePanel* self, IBusText* text);
void candidate_panel_set_lookup_table (CandidatePanel* self, IBusLookupTable* table);
static void _vala_array_add8 (IBusText*** array, int* length, int* size, IBusText* value);
static void _vala_array_add9 (IBusText*** array, int* length, int* size, IBusText* value);
void candidate_area_set_candidates (CandidateArea* self, IBusText** candidates, int candidates_length1, guint focus_candidate, gboolean show_cursor);
static void candidate_panel_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width);
static void candidate_panel_real_get_preferred_height (GtkWidget* base, gint* minimum_width, gint* natural_width);
CandidateArea* candidate_area_new (gboolean vertical);
CandidateArea* candidate_area_construct (GType object_type, gboolean vertical);
static void __lambda10_ (CandidatePanel* self, CandidateArea* w, guint i, guint b, guint s);
static void ___lambda10__candidate_area_candidate_clicked (CandidateArea* _sender, guint index, guint button, guint state, gpointer self);
static void __lambda11_ (CandidatePanel* self, CandidateArea* c);
static void ___lambda11__candidate_area_page_up (CandidateArea* _sender, gpointer self);
static void __lambda12_ (CandidatePanel* self, CandidateArea* c);
static void ___lambda12__candidate_area_page_down (CandidateArea* _sender, gpointer self);
static void __lambda13_ (CandidatePanel* self, CandidateArea* c);
static void ___lambda13__candidate_area_cursor_up (CandidateArea* _sender, gpointer self);
static void __lambda14_ (CandidatePanel* self, CandidateArea* c);
static void ___lambda14__candidate_area_cursor_down (CandidateArea* _sender, gpointer self);
HSeparator* hseparator_new (void);
HSeparator* hseparator_construct (GType object_type);
static void candidate_panel_pack_all_widgets (CandidatePanel* self);
void candidate_panel_show (CandidatePanel* self);
void candidate_panel_hide (CandidatePanel* self);
static void candidate_panel_move (CandidatePanel* self, gint x, gint y);
static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void candidate_panel_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean __lambda8_ (CandidatePanel* self, GtkWidget* w, GdkEventButton* e) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp1_ = e;
	_tmp2_ = _tmp1_->button;
	if (_tmp2_ != ((guint) 1)) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton* _tmp3_ = NULL;
		GdkModifierType _tmp4_ = 0;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->state;
		_tmp0_ = (_tmp4_ & GDK_CONTROL_MASK) == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->m_vertical;
	candidate_panel_set_vertical (self, !_tmp5_);
	result = TRUE;
	return result;
}


static gboolean ___lambda8__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda8_ ((CandidatePanel*) self, _sender, event);
	return result;
}


static void __lambda9_ (CandidatePanel* self, GtkWidget* w, GtkAllocation* a) {
	g_return_if_fail (w != NULL);
	g_return_if_fail (a != NULL);
	candidate_panel_adjust_window_position (self);
}


static void ___lambda9__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	__lambda9_ ((CandidatePanel*) self, _sender, allocation);
}


CandidatePanel* candidate_panel_construct (GType object_type) {
	CandidatePanel * self = NULL;
	GtkWindow* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	Handle* handle = NULL;
	Handle* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkWindow* _tmp8_ = NULL;
	self = (CandidatePanel*) g_object_new (object_type, "name", "IBusCandidate", "orientation", GTK_ORIENTATION_HORIZONTAL, "visible", TRUE, NULL);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_toplevel);
	self->priv->m_toplevel = _tmp0_;
	_tmp1_ = self->priv->m_toplevel;
	gtk_widget_add_events ((GtkWidget*) _tmp1_, (gint) GDK_BUTTON_PRESS_MASK);
	_tmp2_ = self->priv->m_toplevel;
	g_signal_connect_object ((GtkWidget*) _tmp2_, "button-press-event", (GCallback) ___lambda8__gtk_widget_button_press_event, self, 0);
	_tmp3_ = self->priv->m_toplevel;
	g_signal_connect_object ((GtkWidget*) _tmp3_, "size-allocate", (GCallback) ___lambda9__gtk_widget_size_allocate, self, 0);
	_tmp4_ = handle_new ();
	g_object_ref_sink (_tmp4_);
	handle = _tmp4_;
	gtk_widget_set_visible ((GtkWidget*) handle, TRUE);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) handle, FALSE, FALSE, (guint) 0);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->m_vbox);
	self->priv->m_vbox = _tmp5_;
	_tmp6_ = self->priv->m_vbox;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->m_vbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
	_tmp8_ = self->priv->m_toplevel;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) self);
	candidate_panel_create_ui (self);
	_g_object_unref0 (handle);
	return self;
}


CandidatePanel* candidate_panel_new (void) {
	return candidate_panel_construct (TYPE_CANDIDATE_PANEL);
}


void candidate_panel_set_vertical (CandidatePanel* self, gboolean vertical) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	CandidateArea* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_vertical;
	_tmp1_ = vertical;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = vertical;
	self->priv->m_vertical = _tmp2_;
	_tmp3_ = self->priv->m_candidate_area;
	_tmp4_ = vertical;
	candidate_area_set_vertical (_tmp3_, _tmp4_, FALSE);
}


static void candidate_panel_set_orientation (CandidatePanel* self, IBusOrientation orientation) {
	IBusOrientation _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = orientation;
	switch (_tmp0_) {
		case IBUS_ORIENTATION_VERTICAL:
		{
			CandidateArea* _tmp1_ = NULL;
			_tmp1_ = self->priv->m_candidate_area;
			candidate_area_set_vertical (_tmp1_, TRUE, FALSE);
			break;
		}
		case IBUS_ORIENTATION_HORIZONTAL:
		{
			CandidateArea* _tmp2_ = NULL;
			_tmp2_ = self->priv->m_candidate_area;
			candidate_area_set_vertical (_tmp2_, FALSE, FALSE);
			break;
		}
		case IBUS_ORIENTATION_SYSTEM:
		{
			CandidateArea* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			_tmp3_ = self->priv->m_candidate_area;
			_tmp4_ = self->priv->m_vertical;
			candidate_area_set_vertical (_tmp3_, _tmp4_, FALSE);
			break;
		}
		default:
		break;
	}
}


static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t* s1, const cairo_rectangle_int_t* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}


void candidate_panel_set_cursor_location (CandidatePanel* self, gint x, gint y, gint width, gint height) {
	GdkRectangle location = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _tmp5_ = {0};
	GdkRectangle _tmp6_ = {0};
	GdkRectangle _tmp7_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = width;
	_tmp3_ = height;
	memset (&_tmp4_, 0, sizeof (GdkRectangle));
	_tmp4_.x = _tmp0_;
	_tmp4_.y = _tmp1_;
	_tmp4_.width = _tmp2_;
	_tmp4_.height = _tmp3_;
	location = _tmp4_;
	_tmp5_ = self->priv->m_cursor_location;
	_tmp6_ = location;
	if (_cairo_rectangle_int_equal (&_tmp5_, &_tmp6_) == TRUE) {
		return;
	}
	_tmp7_ = location;
	self->priv->m_cursor_location = _tmp7_;
}


static void candidate_panel_set_labels (CandidatePanel* self, IBusText** labels, int labels_length1) {
	CandidateArea* _tmp0_ = NULL;
	IBusText** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_candidate_area;
	_tmp1_ = labels;
	_tmp1__length1 = labels_length1;
	candidate_area_set_labels (_tmp0_, _tmp1_, _tmp1__length1);
}


void candidate_panel_set_preedit_text (CandidatePanel* self, IBusText* text, guint cursor) {
	IBusText* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = text;
	if (_tmp0_ != NULL) {
		gchar* str = NULL;
		IBusText* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp1_ = text;
		_tmp2_ = ibus_text_get_text (_tmp1_);
		_tmp3_ = g_strdup (_tmp2_);
		str = _tmp3_;
		_tmp4_ = str;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ > 0) {
			GtkLabel* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			GtkLabel* _tmp9_ = NULL;
			_tmp7_ = self->priv->m_preedit_label;
			_tmp8_ = str;
			gtk_label_set_text (_tmp7_, _tmp8_);
			_tmp9_ = self->priv->m_preedit_label;
			gtk_widget_show ((GtkWidget*) _tmp9_);
		} else {
			GtkLabel* _tmp10_ = NULL;
			GtkLabel* _tmp11_ = NULL;
			_tmp10_ = self->priv->m_preedit_label;
			gtk_label_set_text (_tmp10_, "");
			_tmp11_ = self->priv->m_preedit_label;
			gtk_widget_hide ((GtkWidget*) _tmp11_);
		}
		_g_free0 (str);
	} else {
		GtkLabel* _tmp12_ = NULL;
		GtkLabel* _tmp13_ = NULL;
		_tmp12_ = self->priv->m_preedit_label;
		gtk_label_set_text (_tmp12_, "");
		_tmp13_ = self->priv->m_preedit_label;
		gtk_widget_hide ((GtkWidget*) _tmp13_);
	}
	candidate_panel_update (self);
}


void candidate_panel_set_auxiliary_text (CandidatePanel* self, IBusText* text) {
	IBusText* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = text;
	if (_tmp0_ != NULL) {
		GtkLabel* _tmp1_ = NULL;
		IBusText* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GtkLabel* _tmp4_ = NULL;
		_tmp1_ = self->priv->m_aux_label;
		_tmp2_ = text;
		_tmp3_ = ibus_text_get_text (_tmp2_);
		gtk_label_set_text (_tmp1_, _tmp3_);
		_tmp4_ = self->priv->m_aux_label;
		gtk_widget_show ((GtkWidget*) _tmp4_);
	} else {
		GtkLabel* _tmp5_ = NULL;
		GtkLabel* _tmp6_ = NULL;
		_tmp5_ = self->priv->m_aux_label;
		gtk_label_set_text (_tmp5_, "");
		_tmp6_ = self->priv->m_aux_label;
		gtk_widget_hide ((GtkWidget*) _tmp6_);
	}
	candidate_panel_update (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add8 (IBusText*** array, int* length, int* size, IBusText* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusText*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (IBusText*** array, int* length, int* size, IBusText* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusText*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void candidate_panel_set_lookup_table (CandidatePanel* self, IBusLookupTable* table) {
	IBusText** candidates = NULL;
	IBusText** _tmp0_ = NULL;
	gint candidates_length1 = 0;
	gint _candidates_size_ = 0;
	guint cursor_in_page = 0U;
	gboolean show_cursor = FALSE;
	IBusText** labels = NULL;
	IBusText** _tmp1_ = NULL;
	gint labels_length1 = 0;
	gint _labels_size_ = 0;
	IBusOrientation orientation = 0;
	IBusLookupTable* _tmp2_ = NULL;
	CandidateArea* _tmp44_ = NULL;
	IBusText** _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	guint _tmp46_ = 0U;
	gboolean _tmp47_ = FALSE;
	IBusText** _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	IBusLookupTable* _tmp49_ = NULL;
	IBusText** _tmp51_ = NULL;
	gint _tmp51__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (IBusText*, 0 + 1);
	candidates = _tmp0_;
	candidates_length1 = 0;
	_candidates_size_ = candidates_length1;
	cursor_in_page = (guint) 0;
	show_cursor = TRUE;
	_tmp1_ = g_new0 (IBusText*, 0 + 1);
	labels = _tmp1_;
	labels_length1 = 0;
	_labels_size_ = labels_length1;
	orientation = IBUS_ORIENTATION_SYSTEM;
	_tmp2_ = table;
	if (_tmp2_ != NULL) {
		guint page_size = 0U;
		IBusLookupTable* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint ncandidates = 0U;
		IBusLookupTable* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		guint cursor = 0U;
		IBusLookupTable* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		IBusLookupTable* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		IBusLookupTable* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		guint page_start_pos = 0U;
		guint _tmp13_ = 0U;
		guint _tmp14_ = 0U;
		guint _tmp15_ = 0U;
		guint page_end_pos = 0U;
		guint _tmp16_ = 0U;
		guint _tmp17_ = 0U;
		guint _tmp18_ = 0U;
		guint _tmp19_ = 0U;
		IBusLookupTable* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		_tmp3_ = table;
		_tmp4_ = ibus_lookup_table_get_page_size (_tmp3_);
		page_size = _tmp4_;
		_tmp5_ = table;
		_tmp6_ = ibus_lookup_table_get_number_of_candidates (_tmp5_);
		ncandidates = _tmp6_;
		_tmp7_ = table;
		_tmp8_ = ibus_lookup_table_get_cursor_pos (_tmp7_);
		cursor = _tmp8_;
		_tmp9_ = table;
		_tmp10_ = ibus_lookup_table_get_cursor_in_page (_tmp9_);
		cursor_in_page = _tmp10_;
		_tmp11_ = table;
		_tmp12_ = ibus_lookup_table_is_cursor_visible (_tmp11_);
		show_cursor = _tmp12_;
		_tmp13_ = cursor;
		_tmp14_ = page_size;
		_tmp15_ = page_size;
		page_start_pos = (_tmp13_ / _tmp14_) * _tmp15_;
		_tmp16_ = page_start_pos;
		_tmp17_ = page_size;
		_tmp18_ = ncandidates;
		_tmp19_ = MIN (_tmp16_ + _tmp17_, _tmp18_);
		page_end_pos = _tmp19_;
		{
			guint i = 0U;
			guint _tmp20_ = 0U;
			_tmp20_ = page_start_pos;
			i = _tmp20_;
			{
				gboolean _tmp21_ = FALSE;
				_tmp21_ = TRUE;
				while (TRUE) {
					guint _tmp23_ = 0U;
					guint _tmp24_ = 0U;
					IBusText** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					IBusLookupTable* _tmp26_ = NULL;
					guint _tmp27_ = 0U;
					IBusText* _tmp28_ = NULL;
					IBusText* _tmp29_ = NULL;
					if (!_tmp21_) {
						guint _tmp22_ = 0U;
						_tmp22_ = i;
						i = _tmp22_ + 1;
					}
					_tmp21_ = FALSE;
					_tmp23_ = i;
					_tmp24_ = page_end_pos;
					if (!(_tmp23_ < _tmp24_)) {
						break;
					}
					_tmp25_ = candidates;
					_tmp25__length1 = candidates_length1;
					_tmp26_ = table;
					_tmp27_ = i;
					_tmp28_ = ibus_lookup_table_get_candidate (_tmp26_, _tmp27_);
					_tmp29_ = _g_object_ref0 (_tmp28_);
					_vala_array_add8 (&candidates, &candidates_length1, &_candidates_size_, _tmp29_);
				}
			}
		}
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp30_ = FALSE;
				_tmp30_ = TRUE;
				while (TRUE) {
					guint _tmp32_ = 0U;
					guint _tmp33_ = 0U;
					IBusText* label = NULL;
					IBusLookupTable* _tmp34_ = NULL;
					guint _tmp35_ = 0U;
					IBusText* _tmp36_ = NULL;
					IBusText* _tmp37_ = NULL;
					IBusText* _tmp38_ = NULL;
					if (!_tmp30_) {
						guint _tmp31_ = 0U;
						_tmp31_ = i;
						i = _tmp31_ + 1;
					}
					_tmp30_ = FALSE;
					_tmp32_ = i;
					_tmp33_ = page_size;
					if (!(_tmp32_ < _tmp33_)) {
						break;
					}
					_tmp34_ = table;
					_tmp35_ = i;
					_tmp36_ = ibus_lookup_table_get_label (_tmp34_, _tmp35_);
					_tmp37_ = _g_object_ref0 (_tmp36_);
					label = _tmp37_;
					_tmp38_ = label;
					if (_tmp38_ != NULL) {
						IBusText** _tmp39_ = NULL;
						gint _tmp39__length1 = 0;
						IBusText* _tmp40_ = NULL;
						IBusText* _tmp41_ = NULL;
						_tmp39_ = labels;
						_tmp39__length1 = labels_length1;
						_tmp40_ = label;
						_tmp41_ = _g_object_ref0 (_tmp40_);
						_vala_array_add9 (&labels, &labels_length1, &_labels_size_, _tmp41_);
					}
					_g_object_unref0 (label);
				}
			}
		}
		_tmp42_ = table;
		_tmp43_ = ibus_lookup_table_get_orientation (_tmp42_);
		orientation = (IBusOrientation) _tmp43_;
	}
	_tmp44_ = self->priv->m_candidate_area;
	_tmp45_ = candidates;
	_tmp45__length1 = candidates_length1;
	_tmp46_ = cursor_in_page;
	_tmp47_ = show_cursor;
	candidate_area_set_candidates (_tmp44_, _tmp45_, _tmp45__length1, _tmp46_, _tmp47_);
	_tmp48_ = labels;
	_tmp48__length1 = labels_length1;
	candidate_panel_set_labels (self, _tmp48_, _tmp48__length1);
	_tmp49_ = table;
	if (_tmp49_ != NULL) {
		IBusOrientation _tmp50_ = 0;
		_tmp50_ = orientation;
		candidate_panel_set_orientation (self, _tmp50_);
	}
	_tmp51_ = candidates;
	_tmp51__length1 = candidates_length1;
	if (_tmp51__length1 != 0) {
		CandidateArea* _tmp52_ = NULL;
		_tmp52_ = self->priv->m_candidate_area;
		gtk_widget_show_all ((GtkWidget*) _tmp52_);
	} else {
		CandidateArea* _tmp53_ = NULL;
		_tmp53_ = self->priv->m_candidate_area;
		gtk_widget_hide ((GtkWidget*) _tmp53_);
	}
	candidate_panel_update (self);
	labels = (_vala_array_free (labels, labels_length1, (GDestroyNotify) g_object_unref), NULL);
	candidates = (_vala_array_free (candidates, candidates_length1, (GDestroyNotify) g_object_unref), NULL);
}


static void candidate_panel_update (CandidatePanel* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CandidateArea* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GtkLabel* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->m_candidate_area;
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	if (_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		GtkLabel* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = self->priv->m_preedit_label;
		_tmp5_ = gtk_widget_get_visible ((GtkWidget*) _tmp4_);
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GtkLabel* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = self->priv->m_aux_label;
		_tmp7_ = gtk_widget_get_visible ((GtkWidget*) _tmp6_);
		_tmp0_ = _tmp7_;
	}
	if (_tmp0_) {
		GtkWindow* _tmp8_ = NULL;
		_tmp8_ = self->priv->m_toplevel;
		gtk_widget_show ((GtkWidget*) _tmp8_);
	} else {
		GtkWindow* _tmp9_ = NULL;
		_tmp9_ = self->priv->m_toplevel;
		gtk_widget_hide ((GtkWidget*) _tmp9_);
	}
	_tmp11_ = self->priv->m_aux_label;
	_tmp12_ = gtk_widget_get_visible ((GtkWidget*) _tmp11_);
	if (_tmp12_) {
		gboolean _tmp13_ = FALSE;
		CandidateArea* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = self->priv->m_candidate_area;
		_tmp15_ = gtk_widget_get_visible ((GtkWidget*) _tmp14_);
		if (_tmp15_) {
			_tmp13_ = TRUE;
		} else {
			GtkLabel* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			_tmp16_ = self->priv->m_preedit_label;
			_tmp17_ = gtk_widget_get_visible ((GtkWidget*) _tmp16_);
			_tmp13_ = _tmp17_;
		}
		_tmp10_ = _tmp13_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		HSeparator* _tmp18_ = NULL;
		_tmp18_ = self->priv->m_hseparator;
		gtk_widget_show ((GtkWidget*) _tmp18_);
	} else {
		HSeparator* _tmp19_ = NULL;
		_tmp19_ = self->priv->m_hseparator;
		gtk_widget_hide ((GtkWidget*) _tmp19_);
	}
}


static void candidate_panel_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width) {
	CandidatePanel * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkWindow* _tmp2_ = NULL;
	self = (CandidatePanel*) base;
	GTK_WIDGET_CLASS (candidate_panel_parent_class)->get_preferred_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BOX, GtkBox), &_tmp0_, &_tmp1_);
	_vala_minimum_width = _tmp0_;
	_vala_natural_width = _tmp1_;
	_tmp2_ = self->priv->m_toplevel;
	gtk_window_resize (_tmp2_, 1, 1);
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}


static void candidate_panel_real_get_preferred_height (GtkWidget* base, gint* minimum_width, gint* natural_width) {
	CandidatePanel * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkWindow* _tmp2_ = NULL;
	self = (CandidatePanel*) base;
	GTK_WIDGET_CLASS (candidate_panel_parent_class)->get_preferred_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BOX, GtkBox), &_tmp0_, &_tmp1_);
	_vala_minimum_width = _tmp0_;
	_vala_natural_width = _tmp1_;
	_tmp2_ = self->priv->m_toplevel;
	gtk_window_resize (_tmp2_, 1, 1);
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}


static void __lambda10_ (CandidatePanel* self, CandidateArea* w, guint i, guint b, guint s) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	g_return_if_fail (w != NULL);
	_tmp0_ = i;
	_tmp1_ = b;
	_tmp2_ = s;
	g_signal_emit_by_name (self, "candidate-clicked", _tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda10__candidate_area_candidate_clicked (CandidateArea* _sender, guint index, guint button, guint state, gpointer self) {
	__lambda10_ ((CandidatePanel*) self, _sender, index, button, state);
}


static void __lambda11_ (CandidatePanel* self, CandidateArea* c) {
	g_return_if_fail (c != NULL);
	g_signal_emit_by_name (self, "page-up");
}


static void ___lambda11__candidate_area_page_up (CandidateArea* _sender, gpointer self) {
	__lambda11_ ((CandidatePanel*) self, _sender);
}


static void __lambda12_ (CandidatePanel* self, CandidateArea* c) {
	g_return_if_fail (c != NULL);
	g_signal_emit_by_name (self, "page-down");
}


static void ___lambda12__candidate_area_page_down (CandidateArea* _sender, gpointer self) {
	__lambda12_ ((CandidatePanel*) self, _sender);
}


static void __lambda13_ (CandidatePanel* self, CandidateArea* c) {
	g_return_if_fail (c != NULL);
	g_signal_emit_by_name (self, "cursor-up");
}


static void ___lambda13__candidate_area_cursor_up (CandidateArea* _sender, gpointer self) {
	__lambda13_ ((CandidatePanel*) self, _sender);
}


static void __lambda14_ (CandidatePanel* self, CandidateArea* c) {
	g_return_if_fail (c != NULL);
	g_signal_emit_by_name (self, "cursor-down");
}


static void ___lambda14__candidate_area_cursor_down (CandidateArea* _sender, gpointer self) {
	__lambda14_ ((CandidatePanel*) self, _sender);
}


static void candidate_panel_create_ui (CandidatePanel* self) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	CandidateArea* _tmp13_ = NULL;
	CandidateArea* _tmp14_ = NULL;
	CandidateArea* _tmp15_ = NULL;
	CandidateArea* _tmp16_ = NULL;
	CandidateArea* _tmp17_ = NULL;
	CandidateArea* _tmp18_ = NULL;
	HSeparator* _tmp19_ = NULL;
	HSeparator* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_preedit_label);
	self->priv->m_preedit_label = _tmp0_;
	_tmp1_ = self->priv->m_preedit_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp1_, 20, -1);
	_tmp2_ = self->priv->m_preedit_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_START);
	_tmp3_ = self->priv->m_preedit_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	_tmp4_ = self->priv->m_preedit_label;
	gtk_misc_set_padding ((GtkMisc*) _tmp4_, 8, 0);
	_tmp5_ = self->priv->m_preedit_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->m_aux_label);
	self->priv->m_aux_label = _tmp6_;
	_tmp7_ = self->priv->m_aux_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp7_, 20, -1);
	_tmp8_ = self->priv->m_aux_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_START);
	_tmp9_ = self->priv->m_aux_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
	_tmp10_ = self->priv->m_aux_label;
	gtk_misc_set_padding ((GtkMisc*) _tmp10_, 8, 0);
	_tmp11_ = self->priv->m_aux_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = self->priv->m_vertical;
	_tmp13_ = candidate_area_new (_tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->m_candidate_area);
	self->priv->m_candidate_area = _tmp13_;
	_tmp14_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp14_, "candidate-clicked", (GCallback) ___lambda10__candidate_area_candidate_clicked, self, 0);
	_tmp15_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp15_, "page-up", (GCallback) ___lambda11__candidate_area_page_up, self, 0);
	_tmp16_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp16_, "page-down", (GCallback) ___lambda12__candidate_area_page_down, self, 0);
	_tmp17_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp17_, "cursor-up", (GCallback) ___lambda13__candidate_area_cursor_up, self, 0);
	_tmp18_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp18_, "cursor-down", (GCallback) ___lambda14__candidate_area_cursor_down, self, 0);
	_tmp19_ = hseparator_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->m_hseparator);
	self->priv->m_hseparator = _tmp19_;
	_tmp20_ = self->priv->m_hseparator;
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, TRUE);
	candidate_panel_pack_all_widgets (self);
}


static void candidate_panel_pack_all_widgets (CandidatePanel* self) {
	GtkBox* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	HSeparator* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	CandidateArea* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_vbox;
	_tmp1_ = self->priv->m_preedit_label;
	gtk_box_pack_start (_tmp0_, (GtkWidget*) _tmp1_, FALSE, FALSE, (guint) 4);
	_tmp2_ = self->priv->m_vbox;
	_tmp3_ = self->priv->m_aux_label;
	gtk_box_pack_start (_tmp2_, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 4);
	_tmp4_ = self->priv->m_vbox;
	_tmp5_ = self->priv->m_hseparator;
	gtk_box_pack_start (_tmp4_, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	_tmp6_ = self->priv->m_vbox;
	_tmp7_ = self->priv->m_candidate_area;
	gtk_box_pack_start (_tmp6_, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
}


void candidate_panel_show (CandidatePanel* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
}


void candidate_panel_hide (CandidatePanel* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static void candidate_panel_move (CandidatePanel* self, gint x, gint y) {
	GtkWindow* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	_tmp1_ = x;
	_tmp2_ = y;
	gtk_window_move (_tmp0_, _tmp1_, _tmp2_);
}


static void candidate_panel_adjust_window_position (CandidatePanel* self) {
	GdkPoint cursor_right_bottom = {0};
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	GdkRectangle _tmp4_ = {0};
	gint _tmp5_ = 0;
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	GdkPoint _tmp8_ = {0};
	GtkAllocation allocation = {0};
	GtkWindow* _tmp9_ = NULL;
	GtkAllocation _tmp10_ = {0};
	GdkPoint window_right_bottom = {0};
	GdkPoint _tmp11_ = {0};
	gint _tmp12_ = 0;
	GtkAllocation _tmp13_ = {0};
	gint _tmp14_ = 0;
	GdkPoint _tmp15_ = {0};
	gint _tmp16_ = 0;
	GtkAllocation _tmp17_ = {0};
	gint _tmp18_ = 0;
	GdkPoint _tmp19_ = {0};
	GdkWindow* root = NULL;
	GdkWindow* _tmp20_ = NULL;
	GdkWindow* _tmp21_ = NULL;
	gint root_width = 0;
	GdkWindow* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint root_height = 0;
	GdkWindow* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint x = 0;
	gint y = 0;
	GdkPoint _tmp26_ = {0};
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GdkPoint _tmp34_ = {0};
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_cursor_location;
	_tmp1_ = _tmp0_.x;
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_ = _tmp2_.width;
	_tmp4_ = self->priv->m_cursor_location;
	_tmp5_ = _tmp4_.y;
	_tmp6_ = self->priv->m_cursor_location;
	_tmp7_ = _tmp6_.height;
	_tmp8_.x = _tmp1_ + _tmp3_;
	_tmp8_.y = _tmp5_ + _tmp7_;
	cursor_right_bottom = _tmp8_;
	_tmp9_ = self->priv->m_toplevel;
	gtk_widget_get_allocation ((GtkWidget*) _tmp9_, &_tmp10_);
	allocation = _tmp10_;
	_tmp11_ = cursor_right_bottom;
	_tmp12_ = _tmp11_.x;
	_tmp13_ = allocation;
	_tmp14_ = _tmp13_.width;
	_tmp15_ = cursor_right_bottom;
	_tmp16_ = _tmp15_.y;
	_tmp17_ = allocation;
	_tmp18_ = _tmp17_.height;
	_tmp19_.x = _tmp12_ + _tmp14_;
	_tmp19_.y = _tmp16_ + _tmp18_;
	window_right_bottom = _tmp19_;
	_tmp20_ = gdk_get_default_root_window ();
	_tmp21_ = _g_object_ref0 (_tmp20_);
	root = _tmp21_;
	_tmp22_ = root;
	_tmp23_ = gdk_window_get_width (_tmp22_);
	root_width = _tmp23_;
	_tmp24_ = root;
	_tmp25_ = gdk_window_get_height (_tmp24_);
	root_height = _tmp25_;
	_tmp26_ = window_right_bottom;
	_tmp27_ = _tmp26_.x;
	_tmp28_ = root_width;
	if (_tmp27_ > _tmp28_) {
		gint _tmp29_ = 0;
		GtkAllocation _tmp30_ = {0};
		gint _tmp31_ = 0;
		_tmp29_ = root_width;
		_tmp30_ = allocation;
		_tmp31_ = _tmp30_.width;
		x = _tmp29_ - _tmp31_;
	} else {
		GdkPoint _tmp32_ = {0};
		gint _tmp33_ = 0;
		_tmp32_ = cursor_right_bottom;
		_tmp33_ = _tmp32_.x;
		x = _tmp33_;
	}
	_tmp34_ = window_right_bottom;
	_tmp35_ = _tmp34_.y;
	_tmp36_ = root_height;
	if (_tmp35_ > _tmp36_) {
		GdkRectangle _tmp37_ = {0};
		gint _tmp38_ = 0;
		GtkAllocation _tmp39_ = {0};
		gint _tmp40_ = 0;
		_tmp37_ = self->priv->m_cursor_location;
		_tmp38_ = _tmp37_.y;
		_tmp39_ = allocation;
		_tmp40_ = _tmp39_.height;
		y = _tmp38_ - _tmp40_;
	} else {
		GdkPoint _tmp41_ = {0};
		gint _tmp42_ = 0;
		_tmp41_ = cursor_right_bottom;
		_tmp42_ = _tmp41_.y;
		y = _tmp42_;
	}
	_tmp43_ = x;
	_tmp44_ = y;
	candidate_panel_move (self, _tmp43_, _tmp44_);
	_g_object_unref0 (root);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}


static void candidate_panel_class_init (CandidatePanelClass * klass) {
	candidate_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CandidatePanelPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = candidate_panel_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = candidate_panel_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->finalize = candidate_panel_finalize;
	g_signal_new ("cursor_up", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cursor_down", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("page_up", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("page_down", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("candidate_clicked", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);
}


static void candidate_panel_instance_init (CandidatePanel * self) {
	self->priv = CANDIDATE_PANEL_GET_PRIVATE (self);
	self->priv->m_vertical = TRUE;
}


static void candidate_panel_finalize (GObject* obj) {
	CandidatePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CANDIDATE_PANEL, CandidatePanel);
	_g_object_unref0 (self->priv->m_toplevel);
	_g_object_unref0 (self->priv->m_vbox);
	_g_object_unref0 (self->priv->m_preedit_label);
	_g_object_unref0 (self->priv->m_aux_label);
	_g_object_unref0 (self->priv->m_candidate_area);
	_g_object_unref0 (self->priv->m_hseparator);
	G_OBJECT_CLASS (candidate_panel_parent_class)->finalize (obj);
}


GType candidate_panel_get_type (void) {
	static volatile gsize candidate_panel_type_id__volatile = 0;
	if (g_once_init_enter (&candidate_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CandidatePanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) candidate_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CandidatePanel), 0, (GInstanceInitFunc) candidate_panel_instance_init, NULL };
		GType candidate_panel_type_id;
		candidate_panel_type_id = g_type_register_static (GTK_TYPE_BOX, "CandidatePanel", &g_define_type_info, 0);
		g_once_init_leave (&candidate_panel_type_id__volatile, candidate_panel_type_id);
	}
	return candidate_panel_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



