/*
An indicator to show information that is in messaging applications
that the user is using.

Copyright 2010 Canonical Ltd.

Authors:
    David Barth <david.barth@canonical.com>
    Ted Gould <ted@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gdk/gdk.h>
#include <glib/gi18n.h>
#include "entry-menu-item.h"
#include "dbus-shared-names.h"

#include "me-service-gwibber.h"

#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/menuitem.h>

enum {
	LAST_SIGNAL
};

/* static guint signals[LAST_SIGNAL] = { }; */

typedef struct _EntryMenuItemPrivate EntryMenuItemPrivate;
struct _EntryMenuItemPrivate
{
	void * placeholder;
};

#define ENTRY_MENU_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ENTRY_MENU_ITEM_TYPE, EntryMenuItemPrivate))

/* Prototypes */
static void entry_menu_item_class_init (EntryMenuItemClass *klass);
static void entry_menu_item_init       (EntryMenuItem *self);
static void entry_menu_item_dispose    (GObject *object);
static void entry_menu_item_finalize   (GObject *object);
static void handle_event               (DbusmenuMenuitem *mi, const gchar *name,
										const GValue *value, guint timestamp);

G_DEFINE_TYPE (EntryMenuItem, entry_menu_item, DBUSMENU_TYPE_MENUITEM);

static void
entry_menu_item_class_init (EntryMenuItemClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	g_type_class_add_private (klass, sizeof (EntryMenuItemPrivate));

	object_class->dispose = entry_menu_item_dispose;
	object_class->finalize = entry_menu_item_finalize;

	DbusmenuMenuitemClass *mclass = DBUSMENU_MENUITEM_CLASS(klass);
	mclass->handle_event = handle_event;

	return;
}

static void
entry_menu_item_init (EntryMenuItem *self)
{
	g_debug("Building new Entry Menu Item");
	/* EntryMenuItemPrivate * priv = ENTRY_MENU_ITEM_GET_PRIVATE(self); */

	return;
}

static void
entry_menu_item_dispose (GObject *object)
{
	/* EntryMenuItem * self = ENTRY_MENU_ITEM(object);
	   EntryMenuItemPrivate * priv = ENTRY_MENU_ITEM_GET_PRIVATE(self); */

	G_OBJECT_CLASS (entry_menu_item_parent_class)->dispose (object);
}

static void
entry_menu_item_finalize (GObject *object)
{
	/*
	  EntryMenuItem * self = ENTRY_MENU_ITEM(object);
	  EntryMenuItemPrivate * priv = ENTRY_MENU_ITEM_GET_PRIVATE(self);
	*/

	G_OBJECT_CLASS (entry_menu_item_parent_class)->finalize (object);

	return;
}

EntryMenuItem *
entry_menu_item_new ()
{
	EntryMenuItem * self = g_object_new(ENTRY_MENU_ITEM_TYPE, NULL);
	/* EntryMenuItemPrivate * priv = ENTRY_MENU_ITEM_GET_PRIVATE(self); */

	dbusmenu_menuitem_property_set(DBUSMENU_MENUITEM(self), DBUSMENU_MENUITEM_PROP_TYPE, DBUSMENU_ENTRY_MENUITEM_TYPE);

	return self;
}

/* When the entry menu item is clicked on it emits a dbus signal
   for the corresponding bottom-half service to act upon */
static void
handle_event (DbusmenuMenuitem *mi, const gchar *name,
			  const GValue *value, guint timestamp)
{
	/* EntryMenuItemPrivate * priv = ENTRY_MENU_ITEM_GET_PRIVATE(self); */

	g_debug ("handle_event");
	if (g_strcmp0 (name, "send") == 0) {
		MeGwibberService *me_gwibber_service = me_gwibber_service_get ();
		me_gwibber_service_send (me_gwibber_service, g_value_get_string (value));
		dbusmenu_menuitem_property_set (mi, ENTRY_MENUITEM_PROP_TEXT, "");
	}

	return;
}
