#ifndef SEEN_SP_DESKTOP_WIDGET_H
#define SEEN_SP_DESKTOP_WIDGET_H

/** \file
 * SPDesktopWidget: handling Gtk events on a desktop.
 *
 * Authors?
 */

#include <gtk/gtktooltips.h>
#include <gtk/gtkwindow.h>

#include "display/display-forward.h"
#include "libnr/nr-point.h"
#include "forward.h"
#include "message.h"
#include "ui/view/view-widget.h"

#define SP_TYPE_DESKTOP_WIDGET (sp_desktop_widget_get_type ())
#define SP_DESKTOP_WIDGET(o) (GTK_CHECK_CAST ((o), SP_TYPE_DESKTOP_WIDGET, SPDesktopWidget))
#define SP_DESKTOP_WIDGET_CLASS(k) (GTK_CHECK_CLASS_CAST ((k), SP_TYPE_DESKTOP_WIDGET, SPDesktopWidgetClass))
#define SP_IS_DESKTOP_WIDGET(o) (GTK_CHECK_TYPE ((o), SP_TYPE_DESKTOP_WIDGET))
#define SP_IS_DESKTOP_WIDGET_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), SP_TYPE_DESKTOP_WIDGET))

namespace Inkscape { namespace Widgets { class LayerSelector; } }

/// A GtkEventBox on an SPDesktop.
struct SPDesktopWidget {
    SPViewWidget viewwidget;

    unsigned int update : 1;

    GtkTooltips *tt;

    SPDesktop *desktop;

    GtkWindow *window;
    
    // The root vbox of the window layout.
    GtkWidget *vbox;

    GtkWidget *menubar, *statusbar;

    GtkWidget *hscrollbar, *vscrollbar, *vscrollbar_box;

    GtkWidget *tool_toolbox, *aux_toolbox, *commands_toolbox;

    /* Rulers */
    GtkWidget *hruler, *vruler;
    GtkWidget *hruler_box, *vruler_box; // eventboxes for setting tooltips
    double dt2r;
    NR::Point ruler_origin;

    GtkWidget *sticky_zoom;
    GtkWidget *coord_status;
    GtkWidget *select_status;
    GtkWidget *zoom_status;
    gulong zoom_update;

    gint coord_status_id, select_status_id;

    SPCanvas *canvas;

    GtkAdjustment *hadj, *vadj;

    Inkscape::Widgets::LayerSelector *layer_selector;

    void setMessage(Inkscape::MessageType type, gchar const *message);

    void window_get_pointer (gint* x, gint* y);

    bool shutdown();
    void viewSetPosition (double x, double y);
};

/// The SPDesktopWidget vtable
struct SPDesktopWidgetClass {
    SPViewWidgetClass parent_class;
};

GtkType sp_desktop_widget_get_type();

void sp_desktop_widget_queue_draw (SPDesktopWidget* dtw);
void sp_desktop_widget_set_coordinate_status (SPDesktopWidget *dtw, gchar *cstr);

gint sp_desktop_widget_set_focus(GtkWidget *widget, GdkEvent *event, SPDesktopWidget *dtw);

void sp_desktop_widget_show_decorations(SPDesktopWidget *dtw, gboolean show);
void sp_desktop_widget_fullscreen(SPDesktopWidget *dtw);
void sp_desktop_widget_layout(SPDesktopWidget *dtw);
void sp_desktop_widget_update_zoom(SPDesktopWidget *dtw);
void sp_desktop_widget_update_rulers (SPDesktopWidget *dtw);

/* Show/hide rulers & scrollbars */
void sp_desktop_widget_toggle_rulers (SPDesktopWidget *dtw, bool is_fullscreen);
void sp_desktop_widget_toggle_scrollbars (SPDesktopWidget *dtw, bool is_fullscreen);
void sp_desktop_widget_update_scrollbars (SPDesktopWidget *dtw, SPDocument *doc, double scale);

void sp_desktop_widget_set_title (SPDesktopWidget *dtw, gchar const* uri);
void sp_dtw_desktop_activate (SPDesktop *desktop, SPDesktopWidget *dtw);
void sp_dtw_desktop_deactivate (SPDesktop *desktop, SPDesktopWidget *dtw);

#endif /* !SEEN_SP_DESKTOP_WIDGET_H */

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4 :
