/*
 * Generated by UcdReader at:Mon Jun 30 13:52:41 GMT-06:00 2008
 * block table size:2 (4 bytes)
 * plane table size:6 (64 bytes)
 *
 *
 *  This table reflects information gleaned from the Unicode Character
 *  Database.  All codepoints are included.
 *
 *  You might notice that this table is larger than some other implementations.
 *  This is because we included the entire UCD set of codepoints, rather than
 *  truncating it at 16 bits for UTF-16.  It is similar to Java's and JS's, but
 *  this is our own implementation.
 *
 *  This lookup table should be compared to the raw unfolded table lookup
 *  to make sure that no bits are lost in compression.  This is done internally
 *  before this file is generated (else it would not -be- generated).  However,
 *  you should also do this in the target compiler.
 *
 * The character properties are currently encoded into 32 bits in the
 * following manner:
 *
 * -----------------------------------------------------------------
 * |3|3|2|2|2|2|2|2|2|2|2|2|1|1|1|1|1|1|1|1|1|1|0|0|0|0|0|0|0|0|0|0|
 * |1|0|9|8|7|6|5|4|3|2|1|0|9|8|7|6|5|4|3|2|1|0|9|8|7|6|5|4|3|2|1|0|
 * |-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|-|
 * |A|B|B|B|B|C|C|C|C|C|C|C|C|C|D|E|F|G|G|G|H|H|I|I|I|I|I|J|J|J|J|J|
 * -----------------------------------------------------------------
 *
 * A 1 bit      mirrored property
 * B 4 bits     directionality property
 * C 9 bits     signed offset used for converting case
 * D 1 bit      if 1, adding the signed offset converts the character to
 *              lowercase
 * E 1 bit      if 1, subtracting the signed offset converts the character to
 *              uppercase
 * F 1 bit      if 1, character has a titlecase equivalent (possibly itself)
 * G 3 bits     This field is for storing our own lexical information, in addition
 *              to that given by the UCD.  The fields are as follows:
 *              0  may not be part of an identifier
 *              1  ignorable control; may continue a Unicode identifier or C
 *                 identifier
 *              2  may continue a C identifier but not a Unicode identifier
 *                 (unused)
 *              3  may continue a Unicode identifier or C identifier
 *              4  is a C whitespace character
 *              5  may start or continue a C identifier;
 *                 may continue but not start a Unicode identifier (_)
 *              6  may start or continue a C identifier but not a Unicode
 *                 identifier ($)
 *              7  may start or continue a Unicode identifier or C identifier
 *              Thus:
 *                 5, 6, 7 may start a C identifier
 *                 1, 2, 3, 5, 6, 7 may continue a C identifier
 *                 7 may start a Unicode identifier
 *                 1, 3, 5, 7 may continue a Unicode identifier
 *                 1 is ignorable within an identifier
 *                 4 is C whitespace
 *  H 2 bits    This field is for storing additional information regarding this
 *              codepoint's numeric properties.  The values are:
 *              0  this character has no numeric property
 *              1  adding the digit offset to the character code and then
 *                 masking with 0x1F will produce the desired numeric value
 *              2  this character has a 'strange' numeric value
 *              3  a JS supradecimal digit: adding the digit offset to the
 *                 character code, then masking with 0x1F, then adding 10
 *                 will produce the desired numeric value
 *  I 5 bits    digit offset
 *  J 5 bits    character type
 */



/**
 * Look for comments in ucd.h
 */
#include "ucd.h"


static UcdBlockData ucd_blocks[] =
{
    { 0x000000, 0x00007f, "Basic Latin" },
    { 0x000080, 0x0000ff, "Latin-1 Supplement" },
    { 0x000100, 0x00017f, "Latin Extended-A" },
    { 0x000180, 0x00024f, "Latin Extended-B" },
    { 0x000250, 0x0002af, "IPA Extensions" },
    { 0x0002b0, 0x0002ff, "Spacing Modifier Letters" },
    { 0x000300, 0x00036f, "Combining Diacritical Marks" },
    { 0x000370, 0x0003ff, "Greek and Coptic" },
    { 0x000400, 0x0004ff, "Cyrillic" },
    { 0x000500, 0x00052f, "Cyrillic Supplement" },
    { 0x000530, 0x00058f, "Armenian" },
    { 0x000590, 0x0005ff, "Hebrew" },
    { 0x000600, 0x0006ff, "Arabic" },
    { 0x000700, 0x00074f, "Syriac" },
    { 0x000750, 0x00077f, "Arabic Supplement" },
    { 0x000780, 0x0007bf, "Thaana" },
    { 0x0007c0, 0x0007ff, "NKo" },
    { 0x000900, 0x00097f, "Devanagari" },
    { 0x000980, 0x0009ff, "Bengali" },
    { 0x000a00, 0x000a7f, "Gurmukhi" },
    { 0x000a80, 0x000aff, "Gujarati" },
    { 0x000b00, 0x000b7f, "Oriya" },
    { 0x000b80, 0x000bff, "Tamil" },
    { 0x000c00, 0x000c7f, "Telugu" },
    { 0x000c80, 0x000cff, "Kannada" },
    { 0x000d00, 0x000d7f, "Malayalam" },
    { 0x000d80, 0x000dff, "Sinhala" },
    { 0x000e00, 0x000e7f, "Thai" },
    { 0x000e80, 0x000eff, "Lao" },
    { 0x000f00, 0x000fff, "Tibetan" },
    { 0x001000, 0x00109f, "Myanmar" },
    { 0x0010a0, 0x0010ff, "Georgian" },
    { 0x001100, 0x0011ff, "Hangul Jamo" },
    { 0x001200, 0x00137f, "Ethiopic" },
    { 0x001380, 0x00139f, "Ethiopic Supplement" },
    { 0x0013a0, 0x0013ff, "Cherokee" },
    { 0x001400, 0x00167f, "Unified Canadian Aboriginal Syllabics" },
    { 0x001680, 0x00169f, "Ogham" },
    { 0x0016a0, 0x0016ff, "Runic" },
    { 0x001700, 0x00171f, "Tagalog" },
    { 0x001720, 0x00173f, "Hanunoo" },
    { 0x001740, 0x00175f, "Buhid" },
    { 0x001760, 0x00177f, "Tagbanwa" },
    { 0x001780, 0x0017ff, "Khmer" },
    { 0x001800, 0x0018af, "Mongolian" },
    { 0x001900, 0x00194f, "Limbu" },
    { 0x001950, 0x00197f, "Tai Le" },
    { 0x001980, 0x0019df, "New Tai Lue" },
    { 0x0019e0, 0x0019ff, "Khmer Symbols" },
    { 0x001a00, 0x001a1f, "Buginese" },
    { 0x001b00, 0x001b7f, "Balinese" },
    { 0x001b80, 0x001bbf, "Sundanese" },
    { 0x001c00, 0x001c4f, "Lepcha" },
    { 0x001c50, 0x001c7f, "Ol Chiki" },
    { 0x001d00, 0x001d7f, "Phonetic Extensions" },
    { 0x001d80, 0x001dbf, "Phonetic Extensions Supplement" },
    { 0x001dc0, 0x001dff, "Combining Diacritical Marks Supplement" },
    { 0x001e00, 0x001eff, "Latin Extended Additional" },
    { 0x001f00, 0x001fff, "Greek Extended" },
    { 0x002000, 0x00206f, "General Punctuation" },
    { 0x002070, 0x00209f, "Superscripts and Subscripts" },
    { 0x0020a0, 0x0020cf, "Currency Symbols" },
    { 0x0020d0, 0x0020ff, "Combining Diacritical Marks for Symbols" },
    { 0x002100, 0x00214f, "Letterlike Symbols" },
    { 0x002150, 0x00218f, "Number Forms" },
    { 0x002190, 0x0021ff, "Arrows" },
    { 0x002200, 0x0022ff, "Mathematical Operators" },
    { 0x002300, 0x0023ff, "Miscellaneous Technical" },
    { 0x002400, 0x00243f, "Control Pictures" },
    { 0x002440, 0x00245f, "Optical Character Recognition" },
    { 0x002460, 0x0024ff, "Enclosed Alphanumerics" },
    { 0x002500, 0x00257f, "Box Drawing" },
    { 0x002580, 0x00259f, "Block Elements" },
    { 0x0025a0, 0x0025ff, "Geometric Shapes" },
    { 0x002600, 0x0026ff, "Miscellaneous Symbols" },
    { 0x002700, 0x0027bf, "Dingbats" },
    { 0x0027c0, 0x0027ef, "Miscellaneous Mathematical Symbols-A" },
    { 0x0027f0, 0x0027ff, "Supplemental Arrows-A" },
    { 0x002800, 0x0028ff, "Braille Patterns" },
    { 0x002900, 0x00297f, "Supplemental Arrows-B" },
    { 0x002980, 0x0029ff, "Miscellaneous Mathematical Symbols-B" },
    { 0x002a00, 0x002aff, "Supplemental Mathematical Operators" },
    { 0x002b00, 0x002bff, "Miscellaneous Symbols and Arrows" },
    { 0x002c00, 0x002c5f, "Glagolitic" },
    { 0x002c60, 0x002c7f, "Latin Extended-C" },
    { 0x002c80, 0x002cff, "Coptic" },
    { 0x002d00, 0x002d2f, "Georgian Supplement" },
    { 0x002d30, 0x002d7f, "Tifinagh" },
    { 0x002d80, 0x002ddf, "Ethiopic Extended" },
    { 0x002de0, 0x002dff, "Cyrillic Extended-A" },
    { 0x002e00, 0x002e7f, "Supplemental Punctuation" },
    { 0x002e80, 0x002eff, "CJK Radicals Supplement" },
    { 0x002f00, 0x002fdf, "Kangxi Radicals" },
    { 0x002ff0, 0x002fff, "Ideographic Description Characters" },
    { 0x003000, 0x00303f, "CJK Symbols and Punctuation" },
    { 0x003040, 0x00309f, "Hiragana" },
    { 0x0030a0, 0x0030ff, "Katakana" },
    { 0x003100, 0x00312f, "Bopomofo" },
    { 0x003130, 0x00318f, "Hangul Compatibility Jamo" },
    { 0x003190, 0x00319f, "Kanbun" },
    { 0x0031a0, 0x0031bf, "Bopomofo Extended" },
    { 0x0031c0, 0x0031ef, "CJK Strokes" },
    { 0x0031f0, 0x0031ff, "Katakana Phonetic Extensions" },
    { 0x003200, 0x0032ff, "Enclosed CJK Letters and Months" },
    { 0x003300, 0x0033ff, "CJK Compatibility" },
    { 0x003400, 0x004dbf, "CJK Unified Ideographs Extension A" },
    { 0x004dc0, 0x004dff, "Yijing Hexagram Symbols" },
    { 0x004e00, 0x009fff, "CJK Unified Ideographs" },
    { 0x00a000, 0x00a48f, "Yi Syllables" },
    { 0x00a490, 0x00a4cf, "Yi Radicals" },
    { 0x00a500, 0x00a63f, "Vai" },
    { 0x00a640, 0x00a69f, "Cyrillic Extended-B" },
    { 0x00a700, 0x00a71f, "Modifier Tone Letters" },
    { 0x00a720, 0x00a7ff, "Latin Extended-D" },
    { 0x00a800, 0x00a82f, "Syloti Nagri" },
    { 0x00a840, 0x00a87f, "Phags-pa" },
    { 0x00a880, 0x00a8df, "Saurashtra" },
    { 0x00a900, 0x00a92f, "Kayah Li" },
    { 0x00a930, 0x00a95f, "Rejang" },
    { 0x00aa00, 0x00aa5f, "Cham" },
    { 0x00ac00, 0x00d7af, "Hangul Syllables" },
    { 0x00d800, 0x00db7f, "High Surrogates" },
    { 0x00db80, 0x00dbff, "High Private Use Surrogates" },
    { 0x00dc00, 0x00dfff, "Low Surrogates" },
    { 0x00e000, 0x00f8ff, "Private Use Area" },
    { 0x00f900, 0x00faff, "CJK Compatibility Ideographs" },
    { 0x00fb00, 0x00fb4f, "Alphabetic Presentation Forms" },
    { 0x00fb50, 0x00fdff, "Arabic Presentation Forms-A" },
    { 0x00fe00, 0x00fe0f, "Variation Selectors" },
    { 0x00fe10, 0x00fe1f, "Vertical Forms" },
    { 0x00fe20, 0x00fe2f, "Combining Half Marks" },
    { 0x00fe30, 0x00fe4f, "CJK Compatibility Forms" },
    { 0x00fe50, 0x00fe6f, "Small Form Variants" },
    { 0x00fe70, 0x00feff, "Arabic Presentation Forms-B" },
    { 0x00ff00, 0x00ffef, "Halfwidth and Fullwidth Forms" },
    { 0x00fff0, 0x00ffff, "Specials" },
    { 0x010000, 0x01007f, "Linear B Syllabary" },
    { 0x010080, 0x0100ff, "Linear B Ideograms" },
    { 0x010100, 0x01013f, "Aegean Numbers" },
    { 0x010140, 0x01018f, "Ancient Greek Numbers" },
    { 0x010190, 0x0101cf, "Ancient Symbols" },
    { 0x0101d0, 0x0101ff, "Phaistos Disc" },
    { 0x010280, 0x01029f, "Lycian" },
    { 0x0102a0, 0x0102df, "Carian" },
    { 0x010300, 0x01032f, "Old Italic" },
    { 0x010330, 0x01034f, "Gothic" },
    { 0x010380, 0x01039f, "Ugaritic" },
    { 0x0103a0, 0x0103df, "Old Persian" },
    { 0x010400, 0x01044f, "Deseret" },
    { 0x010450, 0x01047f, "Shavian" },
    { 0x010480, 0x0104af, "Osmanya" },
    { 0x010800, 0x01083f, "Cypriot Syllabary" },
    { 0x010900, 0x01091f, "Phoenician" },
    { 0x010920, 0x01093f, "Lydian" },
    { 0x010a00, 0x010a5f, "Kharoshthi" },
    { 0x012000, 0x0123ff, "Cuneiform" },
    { 0x012400, 0x01247f, "Cuneiform Numbers and Punctuation" },
    { 0x01d000, 0x01d0ff, "Byzantine Musical Symbols" },
    { 0x01d100, 0x01d1ff, "Musical Symbols" },
    { 0x01d200, 0x01d24f, "Ancient Greek Musical Notation" },
    { 0x01d300, 0x01d35f, "Tai Xuan Jing Symbols" },
    { 0x01d360, 0x01d37f, "Counting Rod Numerals" },
    { 0x01d400, 0x01d7ff, "Mathematical Alphanumeric Symbols" },
    { 0x01f000, 0x01f02f, "Mahjong Tiles" },
    { 0x01f030, 0x01f09f, "Domino Tiles" },
    { 0x020000, 0x02a6df, "CJK Unified Ideographs Extension B" },
    { 0x02f800, 0x02fa1f, "CJK Compatibility Ideographs Supplement" },
    { 0x0e0000, 0x0e007f, "Tags" },
    { 0x0e0100, 0x0e01ef, "Variation Selectors Supplement" },
    { 0x0f0000, 0x0fffff, "Supplementary Private Use Area-A" },
    { 0x100000, 0x10ffff, "Supplementary Private Use Area-B" },
    { 0x000000, 0x10FFFF, (char*)0 } /* No_Block */
};


/**
 * Plane table has 4352 entries
 */
static unsigned short plane[] =
{
  0x0000,  0x0040,  0x0080,  0x00c0,  0x0100,  0x0140,  0x0180,  0x01c0, /* 8 */
  0x0200,  0x0240,  0x0280,  0x02c0,  0x0300,  0x0340,  0x0380,  0x03c0, /* 16 */
  0x0400,  0x0440,  0x0480,  0x04c0,  0x0500,  0x0540,  0x0580,  0x05c0, /* 24 */
  0x0600,  0x0640,  0x0680,  0x06c0,  0x0700,  0x0740,  0x0780,  0x07c0, /* 32 */
  0x0800,  0x0840,  0x0880,  0x08c0,  0x0900,  0x0940,  0x0980,  0x09c0, /* 40 */
  0x0a00,  0x0a40,  0x0a80,  0x0ac0,  0x0b00,  0x0b40,  0x0b80,  0x0bc0, /* 48 */
  0x0c00,  0x0c40,  0x0c80,  0x0cc0,  0x0501,  0x0501,  0x0501,  0x0501, /* 56 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 64 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 72 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0d00,  0x0501,  0x0501, /* 80 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 88 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 96 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 104 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 112 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 120 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 128 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 136 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 144 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 152 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0d40, /* 160 */
  0x0d80,  0x0501,  0x0501,  0x0501,  0x0dc0,  0x0501,  0x0e00,  0x0e40, /* 168 */
  0x0e80,  0x0ec0,  0x0f00,  0x01ff,  0x0501,  0x0501,  0x0501,  0x0501, /* 176 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 184 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 192 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 200 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 208 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0f40, /* 216 */
  0x0f80,  0x0fc0,  0x0f82,  0x0f82,  0x0f82,  0x0f82,  0x0f82,  0x0f82, /* 224 */
  0x1000,  0x1040,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 232 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 240 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 248 */
  0x1002,  0x1080,  0x10c0,  0x1100,  0x1140,  0x1180,  0x11c0,  0x1200, /* 256 */
  0x1240,  0x1280,  0x12c0,  0x1300,  0x1340,  0x01ff,  0x01ff,  0x01ff, /* 264 */
  0x1380,  0x13c0,  0x1400,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 272 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 280 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 288 */
  0x0501,  0x0501,  0x0501,  0x1440,  0x1480,  0x01ff,  0x01ff,  0x01ff, /* 296 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 304 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 312 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 320 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 328 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 336 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 344 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 352 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 360 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 368 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 376 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 384 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 392 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 400 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 408 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 416 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 424 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 432 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 440 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 448 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 456 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 464 */
  0x14c0,  0x1500,  0x1540,  0x1580,  0x15c0,  0x1600,  0x1640,  0x1680, /* 472 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 480 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 488 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 496 */
  0x16c0,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 504 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 512 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 520 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 528 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 536 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 544 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 552 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 560 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 568 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 576 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 584 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 592 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 600 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 608 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 616 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 624 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 632 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 640 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 648 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 656 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 664 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501, /* 672 */
  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x0501,  0x1700,  0x01ff, /* 680 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 688 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 696 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 704 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 712 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 720 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 728 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 736 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 744 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 752 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 760 */
  0x1740,  0x0501,  0x1780,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 768 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 776 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 784 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 792 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 800 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 808 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 816 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 824 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 832 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 840 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 848 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 856 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 864 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 872 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 880 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 888 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 896 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 904 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 912 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 920 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 928 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 936 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 944 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 952 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 960 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 968 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 976 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 984 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 992 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1000 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1008 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1016 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1024 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1032 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1040 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1048 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1056 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1064 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1072 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1080 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1088 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1096 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1104 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1112 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1120 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1128 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1136 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1144 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1152 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1160 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1168 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1176 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1184 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1192 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1200 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1208 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1216 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1224 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1232 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1240 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1248 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1256 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1264 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1272 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1280 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1288 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1296 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1304 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1312 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1320 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1328 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1336 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1344 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1352 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1360 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1368 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1376 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1384 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1392 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1400 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1408 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1416 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1424 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1432 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1440 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1448 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1456 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1464 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1472 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1480 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1488 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1496 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1504 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1512 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1520 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1528 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1536 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1544 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1552 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1560 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1568 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1576 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1584 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1592 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1600 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1608 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1616 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1624 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1632 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1640 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1648 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1656 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1664 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1672 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1680 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1688 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1696 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1704 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1712 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1720 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1728 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1736 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1744 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1752 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1760 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1768 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1776 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1784 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1792 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1800 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1808 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1816 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1824 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1832 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1840 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1848 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1856 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1864 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1872 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1880 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1888 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1896 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1904 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1912 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1920 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1928 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1936 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1944 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1952 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1960 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1968 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1976 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1984 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 1992 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2000 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2008 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2016 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2024 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2032 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2040 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2048 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2056 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2064 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2072 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2080 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2088 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2096 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2104 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2112 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2120 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2128 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2136 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2144 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2152 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2160 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2168 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2176 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2184 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2192 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2200 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2208 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2216 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2224 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2232 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2240 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2248 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2256 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2264 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2272 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2280 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2288 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2296 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2304 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2312 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2320 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2328 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2336 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2344 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2352 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2360 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2368 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2376 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2384 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2392 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2400 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2408 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2416 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2424 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2432 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2440 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2448 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2456 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2464 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2472 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2480 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2488 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2496 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2504 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2512 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2520 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2528 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2536 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2544 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2552 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2560 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2568 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2576 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2584 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2592 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2600 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2608 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2616 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2624 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2632 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2640 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2648 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2656 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2664 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2672 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2680 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2688 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2696 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2704 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2712 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2720 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2728 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2736 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2744 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2752 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2760 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2768 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2776 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2784 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2792 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2800 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2808 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2816 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2824 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2832 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2840 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2848 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2856 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2864 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2872 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2880 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2888 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2896 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2904 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2912 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2920 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2928 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2936 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2944 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2952 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2960 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2968 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2976 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2984 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 2992 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3000 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3008 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3016 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3024 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3032 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3040 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3048 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3056 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3064 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3072 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3080 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3088 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3096 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3104 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3112 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3120 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3128 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3136 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3144 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3152 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3160 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3168 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3176 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3184 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3192 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3200 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3208 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3216 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3224 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3232 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3240 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3248 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3256 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3264 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3272 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3280 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3288 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3296 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3304 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3312 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3320 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3328 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3336 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3344 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3352 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3360 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3368 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3376 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3384 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3392 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3400 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3408 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3416 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3424 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3432 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3440 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3448 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3456 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3464 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3472 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3480 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3488 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3496 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3504 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3512 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3520 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3528 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3536 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3544 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3552 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3560 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3568 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3576 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3584 */
  0x17c0,  0x1800,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3592 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3600 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3608 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3616 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3624 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3632 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3640 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3648 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3656 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3664 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3672 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3680 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3688 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3696 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3704 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3712 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3720 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3728 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3736 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3744 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3752 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3760 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3768 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3776 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3784 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3792 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3800 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3808 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3816 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3824 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3832 */
  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff,  0x01ff, /* 3840 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3848 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3856 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3864 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3872 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3880 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3888 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3896 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3904 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3912 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3920 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3928 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3936 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3944 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3952 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3960 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3968 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3976 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3984 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 3992 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4000 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4008 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4016 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4024 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4032 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4040 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4048 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4056 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4064 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4072 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4080 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4088 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1840, /* 4096 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4104 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4112 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4120 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4128 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4136 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4144 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4152 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4160 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4168 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4176 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4184 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4192 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4200 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4208 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4216 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4224 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4232 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4240 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4248 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4256 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4264 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4272 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4280 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4288 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4296 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4304 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4312 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4320 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4328 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4336 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002, /* 4344 */
  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1002,  0x1880, /* 4352 */

};

/**
 * Block table has 6336 entries
 */
static unsigned short block[] =
{
  0x0000,  0x0004,  0x0008,  0x000c,  0x0000,  0x0000,  0x0000,  0x0010, /* 8 */
  0x0014,  0x0018,  0x001c,  0x0020,  0x0024,  0x0028,  0x002c,  0x0030, /* 16 */
  0x0034,  0x0038,  0x003c,  0x0040,  0x0044,  0x0048,  0x004c,  0x0050, /* 24 */
  0x0054,  0x0058,  0x005c,  0x0060,  0x0064,  0x0068,  0x006c,  0x0070, /* 32 */
  0x0000,  0x0074,  0x0000,  0x0000,  0x0000,  0x0000,  0x0000,  0x0000, /* 40 */
  0x0078,  0x007c,  0x0080,  0x0084,  0x0088,  0x008c,  0x0090,  0x0094, /* 48 */
  0x0098,  0x009c,  0x0098,  0x00a0,  0x0098,  0x00a4,  0x0098,  0x00a8, /* 56 */
  0x00ac,  0x00b0,  0x00ac,  0x00ac,  0x00ac,  0x00b4,  0x00ac,  0x00b8, /* 64 */
  0x00bc,  0x00c0,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 72 */
  0x00bc,  0x00bc,  0x00c4,  0x00c2,  0x00c8,  0x00bc,  0x00cc,  0x00bd, /* 80 */
  0x00bd,  0x00bd,  0x00d0,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 88 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00d4,  0x00ce, /* 96 */
  0x00d8,  0x00dc,  0x00e0,  0x00e4,  0x00e8,  0x00ec,  0x00f0,  0x00f4, /* 104 */
  0x00bc,  0x00f8,  0x00fc,  0x00f8,  0x0100,  0x0104,  0x0108,  0x010c, /* 112 */
  0x0110,  0x0114,  0x0118,  0x011c,  0x00bd,  0x00bd,  0x00bd,  0x0120, /* 120 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x0124,  0x0128,  0x00bc,  0x00bc, /* 128 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 136 */
  0x012c,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x0130,  0x0134,  0x0138, /* 144 */
  0x013c,  0x0140,  0x00bc,  0x00bc,  0x0144,  0x0148,  0x014c,  0x0130, /* 152 */
  0x0150,  0x0130,  0x0154,  0x0158,  0x015c,  0x0160,  0x0130,  0x0156, /* 160 */
  0x0164,  0x0130,  0x0168,  0x016c,  0x0170,  0x0174,  0x0130,  0x0130, /* 168 */
  0x0130,  0x0130,  0x0130,  0x0130,  0x0178,  0x017c,  0x0180,  0x0178, /* 176 */
  0x0184,  0x0188,  0x018c,  0x018a,  0x0184,  0x0186,  0x0186,  0x0186, /* 184 */
  0x0178,  0x0185,  0x0186,  0x0190,  0x0186,  0x0186,  0x0186,  0x0186, /* 192 */
  0x0194,  0x0198,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 200 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 208 */
  0x0194,  0x019c,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 216 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x00bc,  0x01a0,  0x01a4,  0x01a8, /* 224 */
  0x01ac,  0x01b0,  0x01b4,  0x01b8,  0x01bc,  0x0098,  0x0098,  0x0098, /* 232 */
  0x01c0,  0x0098,  0x0098,  0x01c4,  0x00ab,  0x00ac,  0x00ac,  0x00ac, /* 240 */
  0x01c8,  0x00ac,  0x00ac,  0x01cc,  0x01d0,  0x01d4,  0x00bc,  0x00bc, /* 248 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x01d8,  0x01dc,  0x01e0,  0x01e4, /* 256 */
  0x01e8,  0x01ec,  0x01e8,  0x01e8,  0x0098,  0x0098,  0x0098,  0x0098, /* 264 */
  0x0098,  0x0098,  0x0098,  0x0098,  0x00ac,  0x00ac,  0x00ac,  0x00ac, /* 272 */
  0x00ac,  0x00ac,  0x00ac,  0x00ac,  0x01f0,  0x01f4,  0x01f0,  0x01f0, /* 280 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 288 */
  0x01f8,  0x0194,  0x01fc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 296 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 304 */
  0x0200,  0x00bd,  0x00bd,  0x0204,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 312 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 320 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 328 */
  0x00bc,  0x01ab,  0x01ab,  0x01ab,  0x0208,  0x020c,  0x0209,  0x0209, /* 336 */
  0x0209,  0x0209,  0x0209,  0x0209,  0x0209,  0x0210,  0x0214,  0x0218, /* 344 */
  0x021c,  0x0220,  0x021d,  0x021d,  0x021d,  0x021d,  0x021d,  0x021d, /* 352 */
  0x021d,  0x0224,  0x0228,  0x01ab,  0x022c,  0x0194,  0x0194,  0x0194, /* 360 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0230, /* 368 */
  0x0234,  0x0238,  0x01ab,  0x01ab,  0x023c,  0x0240,  0x023c,  0x023c, /* 376 */
  0x023c,  0x023c,  0x0244,  0x01ab,  0x0248,  0x024c,  0x01ab,  0x01ab, /* 384 */
  0x0250,  0x0254,  0x0258,  0x025c,  0x0194,  0x0194,  0x0260,  0x0264, /* 392 */
  0x0268,  0x026c,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 400 */
  0x0270,  0x0269,  0x0274,  0x0194,  0x0194,  0x0194,  0x0194,  0x0278, /* 408 */
  0x027c,  0x0280,  0x0284,  0x0288,  0x028c,  0x0269,  0x0269,  0x0269, /* 416 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 424 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 432 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0290,  0x0194,  0x0294, /* 440 */
  0x0194,  0x0298,  0x029c,  0x02a0,  0x0024,  0x0028,  0x02a4,  0x02a8, /* 448 */
  0x02ac,  0x02b0,  0x02ac,  0x02b4,  0x028b,  0x0269,  0x0269,  0x0269, /* 456 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0194,  0x0194,  0x0194,  0x0194, /* 464 */
  0x0194,  0x0194,  0x0278,  0x0268,  0x0269,  0x0269,  0x0269,  0x0269, /* 472 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 480 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 488 */
  0x0269,  0x0275,  0x0194,  0x0194,  0x02b8,  0x01ab,  0x01ab,  0x01ab, /* 496 */
  0x02bc,  0x02c0,  0x02c4,  0x023c,  0x023c,  0x023c,  0x023c,  0x023c, /* 504 */
  0x023c,  0x023c,  0x02c8,  0x0194,  0x0194,  0x02cc,  0x02d0,  0x01ab, /* 512 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 520 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 528 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 536 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 544 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 552 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 560 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 568 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 576 */
  0x02d4,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 584 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x02d8,  0x02dc, /* 592 */
  0x02e0,  0x0194,  0x02e4,  0x02e8,  0x02ec,  0x02f0,  0x0110,  0x0110, /* 600 */
  0x02f4,  0x02f8,  0x02fc,  0x0300,  0x0304,  0x01ab,  0x02f1,  0x0110, /* 608 */
  0x0308,  0x030c,  0x0110,  0x0310,  0x0314,  0x0110,  0x0110,  0x0110, /* 616 */
  0x0110,  0x0110,  0x0318,  0x0110,  0x031c,  0x02f2,  0x02d8,  0x02dc, /* 624 */
  0x02e0,  0x0320,  0x0324,  0x0328,  0x01ab,  0x032c,  0x01ab,  0x0317, /* 632 */
  0x02f4,  0x0330,  0x02fc,  0x0300,  0x0334,  0x0338,  0x033c,  0x01ab, /* 640 */
  0x02d4,  0x030c,  0x030e,  0x02f1,  0x0310,  0x0110,  0x0110,  0x0110, /* 648 */
  0x0110,  0x0110,  0x0318,  0x0110,  0x0318,  0x0312,  0x02d8,  0x0340, /* 656 */
  0x0344,  0x0348,  0x034c,  0x02ef,  0x031f,  0x01ab,  0x030c,  0x031c, /* 664 */
  0x01ab,  0x0330,  0x02fc,  0x0300,  0x0350,  0x0354,  0x01ab,  0x01ab, /* 672 */
  0x02d4,  0x030c,  0x0110,  0x0317,  0x0317,  0x0110,  0x0110,  0x0110, /* 680 */
  0x0110,  0x0110,  0x0318,  0x0110,  0x0318,  0x030c,  0x02d8,  0x02dc, /* 688 */
  0x02e0,  0x0358,  0x035c,  0x02e8,  0x032a,  0x01ab,  0x01ab,  0x01ab, /* 696 */
  0x02f4,  0x0330,  0x02fc,  0x0300,  0x0360,  0x01ab,  0x01ab,  0x01ab, /* 704 */
  0x0308,  0x030c,  0x0110,  0x0310,  0x0310,  0x0110,  0x0110,  0x0110, /* 712 */
  0x0110,  0x0110,  0x0318,  0x0110,  0x0318,  0x030c,  0x02d8,  0x0364, /* 720 */
  0x02e0,  0x0320,  0x0324,  0x02e8,  0x01ab,  0x0307,  0x01ab,  0x0317, /* 728 */
  0x02f4,  0x0330,  0x02fc,  0x0300,  0x0368,  0x01ab,  0x01ab,  0x01ab, /* 736 */
  0x02da,  0x030c,  0x030e,  0x02f2,  0x0318,  0x02d8,  0x0312,  0x0318, /* 744 */
  0x02f1,  0x032a,  0x030e,  0x02f2,  0x0110,  0x0110,  0x02d8,  0x0321, /* 752 */
  0x0309,  0x0321,  0x036c,  0x02e8,  0x032a,  0x032c,  0x01ab,  0x01ab, /* 760 */
  0x01ab,  0x0330,  0x02fc,  0x0300,  0x0370,  0x0374,  0x0378,  0x01ab, /* 768 */
  0x0341,  0x030c,  0x0110,  0x0318,  0x0318,  0x0110,  0x0110,  0x0110, /* 776 */
  0x0110,  0x0110,  0x0318,  0x0110,  0x0110,  0x030c,  0x02d8,  0x02eb, /* 784 */
  0x02e4,  0x037c,  0x0359,  0x02ef,  0x01ab,  0x034a,  0x02d8,  0x01ab, /* 792 */
  0x02f4,  0x0330,  0x02fc,  0x0300,  0x01ab,  0x01ab,  0x0380,  0x0384, /* 800 */
  0x0321,  0x030c,  0x0110,  0x0318,  0x0318,  0x0110,  0x0110,  0x0110, /* 808 */
  0x0110,  0x0110,  0x0318,  0x0110,  0x0110,  0x030c,  0x02d8,  0x0388, /* 816 */
  0x02e5,  0x038c,  0x036c,  0x02ef,  0x01ab,  0x0322,  0x01ab,  0x0390, /* 824 */
  0x02f4,  0x0330,  0x02fc,  0x0300,  0x0394,  0x01ab,  0x01ab,  0x01ab, /* 832 */
  0x0321,  0x030c,  0x0110,  0x0318,  0x0318,  0x0110,  0x0110,  0x0110, /* 840 */
  0x0110,  0x0110,  0x0318,  0x0110,  0x0110,  0x0110,  0x02d8,  0x0398, /* 848 */
  0x02e0,  0x0340,  0x036c,  0x02e8,  0x01ab,  0x032c,  0x01ab,  0x01ab, /* 856 */
  0x02f4,  0x0330,  0x02fc,  0x0300,  0x039c,  0x03a0,  0x03a4,  0x0110, /* 864 */
  0x0321,  0x030c,  0x0110,  0x0110,  0x0110,  0x030e,  0x02f2,  0x0110, /* 872 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0317,  0x0110,  0x0110,  0x0391, /* 880 */
  0x0110,  0x030e,  0x03a8,  0x032c,  0x02df,  0x03ac,  0x02e5,  0x02e5, /* 888 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x0321,  0x03b0,  0x01ab,  0x01ab, /* 896 */
  0x030c,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 904 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x03b4,  0x0194,  0x0278,  0x03b8, /* 912 */
  0x0110,  0x03bc,  0x0194,  0x03c0,  0x02fa,  0x02fe,  0x03c4,  0x01ab, /* 920 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 928 */
  0x0312,  0x0310,  0x031c,  0x0391,  0x01ab,  0x0110,  0x030c,  0x0110, /* 936 */
  0x030c,  0x03c8,  0x02f2,  0x030c,  0x03b4,  0x0194,  0x0358,  0x0329, /* 944 */
  0x0110,  0x03cc,  0x0194,  0x02ef,  0x02fa,  0x02fe,  0x03d0,  0x02d8, /* 952 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 960 */
  0x03d4,  0x0216,  0x0216,  0x0216,  0x03d8,  0x03dc,  0x03e0,  0x03db, /* 968 */
  0x02fa,  0x02fe,  0x03e4,  0x03e8,  0x03e6,  0x03ec,  0x03f0,  0x03f4, /* 976 */
  0x0110,  0x0110,  0x030c,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 984 */
  0x0110,  0x0110,  0x0110,  0x032a,  0x022c,  0x0194,  0x0194,  0x02e2, /* 992 */
  0x0194,  0x03f8,  0x0110,  0x01ab,  0x0194,  0x0194,  0x022c,  0x0194, /* 1000 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x03fc, /* 1008 */
  0x03db,  0x0400,  0x03db,  0x0404,  0x0216,  0x03b0,  0x01ab,  0x01ab, /* 1016 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1024 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1032 */
  0x0110,  0x0110,  0x0408,  0x02e0,  0x040c,  0x0194,  0x0410,  0x0414, /* 1040 */
  0x02fa,  0x02fe,  0x03c4,  0x0216,  0x0110,  0x0418,  0x0350,  0x02f4, /* 1048 */
  0x02dc,  0x041c,  0x02e5,  0x041b,  0x02ec,  0x0351,  0x0110,  0x0110, /* 1056 */
  0x0420,  0x040d,  0x02e5,  0x0424,  0x02fa,  0x02fe,  0x03d0,  0x0428, /* 1064 */
  0x042c,  0x0430,  0x042c,  0x042c,  0x042c,  0x042c,  0x042c,  0x042c, /* 1072 */
  0x042c,  0x0434,  0x01ab,  0x01ab,  0x0110,  0x0110,  0x0110,  0x0110, /* 1080 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0438,  0x043c, /* 1088 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1096 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1104 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x02d8,  0x02f1, /* 1112 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1120 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1128 */
  0x030e,  0x01ab,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1136 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1144 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x02d8,  0x01ab, /* 1152 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1160 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1168 */
  0x0110,  0x0110,  0x0318,  0x02d8,  0x0110,  0x030e,  0x0318,  0x02d8, /* 1176 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1184 */
  0x0110,  0x0110,  0x0318,  0x02d8,  0x0110,  0x0110,  0x0110,  0x0110, /* 1192 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0318,  0x02d8,  0x0110,  0x030e, /* 1200 */
  0x0318,  0x02d8,  0x0110,  0x0110,  0x0110,  0x030e,  0x0110,  0x0110, /* 1208 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1216 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0318,  0x02d8,  0x0110,  0x0110, /* 1224 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1232 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x030e,  0x0348, /* 1240 */
  0x03d7,  0x0216,  0x0440,  0x0444,  0x0448,  0x044c,  0x0450,  0x0454, /* 1248 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0373,  0x0373,  0x0395,  0x01ab, /* 1256 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1264 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1272 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x032a,  0x01ab,  0x01ab, /* 1280 */
  0x030c,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1288 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1296 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1304 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1312 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1320 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1328 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1336 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1344 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1352 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1360 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1368 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1376 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1384 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1392 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1400 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1408 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1416 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1424 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1432 */
  0x0110,  0x0110,  0x0110,  0x0458,  0x0110,  0x030e,  0x01ab,  0x01ab, /* 1440 */
  0x045c,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0460,  0x0464, /* 1448 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1456 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1464 */
  0x0110,  0x0110,  0x0438,  0x0468,  0x046c,  0x01ab,  0x01ab,  0x01ab, /* 1472 */
  0x0110,  0x0110,  0x0110,  0x0318,  0x02f4,  0x02f0,  0x01ab,  0x01ab, /* 1480 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x02f4,  0x0470,  0x01ab,  0x01ab, /* 1488 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x02f4,  0x01ab,  0x01ab,  0x01ab, /* 1496 */
  0x0110,  0x0110,  0x0110,  0x0318,  0x0474,  0x01ab,  0x01ab,  0x01ab, /* 1504 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1512 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0478,  0x0194,  0x02e3, /* 1520 */
  0x02e5,  0x047c,  0x02e0,  0x0194,  0x0194,  0x0480,  0x0484,  0x0354, /* 1528 */
  0x02fa,  0x02fe,  0x03d0,  0x01ab,  0x0380,  0x0488,  0x048c,  0x01ab, /* 1536 */
  0x0490,  0x0494,  0x0498,  0x049c,  0x02fa,  0x02fe,  0x03d0,  0x01ab, /* 1544 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1552 */
  0x04a0,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1560 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x01ab,  0x01ab, /* 1568 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1576 */
  0x0110,  0x0110,  0x04a4,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1584 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1592 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1600 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x032a, /* 1608 */
  0x02e2,  0x02de,  0x02e4,  0x01ab,  0x047c,  0x02e5,  0x02e0,  0x01ab, /* 1616 */
  0x04a8,  0x04ac,  0x02fc,  0x0300,  0x0110,  0x0110,  0x0110,  0x0110, /* 1624 */
  0x0110,  0x0110,  0x0110,  0x02d8,  0x0110,  0x032a,  0x01ab,  0x01ab, /* 1632 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1640 */
  0x0110,  0x0110,  0x02d8,  0x01ab,  0x02e5,  0x02e5,  0x02e5,  0x02e5, /* 1648 */
  0x04b0,  0x0110,  0x0323,  0x01ab,  0x02fa,  0x02fe,  0x03d0,  0x048e, /* 1656 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 1664 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0352,  0x02e4,  0x0466, /* 1672 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1680 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1688 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1696 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1704 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1712 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1720 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1728 */
  0x0194,  0x04b4,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1736 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x040c,  0x02e2,  0x02e4, /* 1744 */
  0x047c,  0x04b0,  0x0110,  0x01ab,  0x02fa,  0x02fe,  0x03c4,  0x0216, /* 1752 */
  0x03da,  0x03db,  0x03dd,  0x0194,  0x0194,  0x03db,  0x03db,  0x04b8, /* 1760 */
  0x02d5,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1768 */
  0x04bc,  0x02e3,  0x035b,  0x02f2,  0x02fa,  0x02fe,  0x03d0,  0x01ab, /* 1776 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1784 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1792 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 1800 */
  0x0110,  0x02e5,  0x02e5,  0x0194,  0x0194,  0x02df,  0x043d,  0x0216, /* 1808 */
  0x02fa,  0x02fe,  0x03d0,  0x030c,  0x02fa,  0x02fe,  0x04c0,  0x0110, /* 1816 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0178,  0x04c4, /* 1824 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1832 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1840 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1848 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 1856 */
  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130, /* 1864 */
  0x0130,  0x0130,  0x0130,  0x0178,  0x0178,  0x0178,  0x0178,  0x0178, /* 1872 */
  0x0178,  0x0178,  0x0178,  0x0178,  0x0178,  0x0178,  0x0178,  0x0178, /* 1880 */
  0x04c8,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x04cc,  0x0156, /* 1888 */
  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x0175,  0x0178, /* 1896 */
  0x0178,  0x0178,  0x0178,  0x0178,  0x0178,  0x0178,  0x0178,  0x0178, /* 1904 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 1912 */
  0x0194,  0x0278,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x022b, /* 1920 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 1928 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 1936 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 1944 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 1952 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x0142,  0x04d0,  0x04d4, /* 1960 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 1968 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 1976 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 1984 */
  0x04d8,  0x04dc,  0x04e0,  0x04e4,  0x04d8,  0x04e8,  0x04e0,  0x04ec, /* 1992 */
  0x04d8,  0x04d8,  0x04e0,  0x04e0,  0x04d8,  0x04d8,  0x04e0,  0x04e0, /* 2000 */
  0x04d8,  0x04e8,  0x04e0,  0x04f0,  0x04f4,  0x04f8,  0x04fc,  0x0500, /* 2008 */
  0x04d8,  0x04d8,  0x04e0,  0x04e0,  0x0504,  0x0508,  0x050c,  0x0510, /* 2016 */
  0x0514,  0x0518,  0x051c,  0x0520,  0x0514,  0x0514,  0x051c,  0x051c, /* 2024 */
  0x0514,  0x0514,  0x051c,  0x051c,  0x0524,  0x0528,  0x052c,  0x0530, /* 2032 */
  0x0534,  0x0528,  0x0538,  0x053c,  0x0524,  0x0512,  0x0540,  0x0544, /* 2040 */
  0x0524,  0x0548,  0x054c,  0x0550,  0x0512,  0x0528,  0x0554,  0x0558, /* 2048 */
  0x055c,  0x0560,  0x0564,  0x0568,  0x056c,  0x0570,  0x0574,  0x0578, /* 2056 */
  0x0490,  0x0490,  0x057c,  0x0580,  0x0584,  0x0588,  0x058c,  0x0590, /* 2064 */
  0x0594,  0x0598,  0x0490,  0x0490,  0x059c,  0x0594,  0x0490,  0x05a0, /* 2072 */
  0x05a4,  0x05a8,  0x05ac,  0x05a4,  0x05b0,  0x05b4,  0x05b8,  0x05bc, /* 2080 */
  0x05c0,  0x05b4,  0x05b8,  0x05c4,  0x0178,  0x043c,  0x01ab,  0x01ab, /* 2088 */
  0x007a,  0x007a,  0x007a,  0x007a,  0x007a,  0x05c8,  0x01ab,  0x01ab, /* 2096 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x0194,  0x0194,  0x0194,  0x05cc, /* 2104 */
  0x05d0,  0x05d4,  0x0194,  0x0194,  0x02f0,  0x01ab,  0x01ab,  0x01ab, /* 2112 */
  0x05d8,  0x05dc,  0x05e0,  0x05e4,  0x05e3,  0x05d9,  0x05e8,  0x05ec, /* 2120 */
  0x0373,  0x05f0,  0x05f4,  0x05f8,  0x05fc,  0x0600,  0x0604,  0x0608, /* 2128 */
  0x060c,  0x0610,  0x0614,  0x0618,  0x061c,  0x0620,  0x061f,  0x0624, /* 2136 */
  0x0628,  0x062c,  0x0630,  0x0634,  0x0638,  0x063c,  0x0640,  0x0644, /* 2144 */
  0x0648,  0x064c,  0x0650,  0x01ab,  0x060d,  0x0654,  0x0658,  0x0373, /* 2152 */
  0x065c,  0x0660,  0x0373,  0x065d,  0x0373,  0x0373,  0x0373,  0x0373, /* 2160 */
  0x0373,  0x0373,  0x0373,  0x0658,  0x065d,  0x0654,  0x0373,  0x0373, /* 2168 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x060d,  0x060d,  0x060d, /* 2176 */
  0x0664,  0x060c,  0x0668,  0x066c,  0x0670,  0x0674,  0x0678,  0x067c, /* 2184 */
  0x066b,  0x0680,  0x066e,  0x0665,  0x0665,  0x060d,  0x0684,  0x0665, /* 2192 */
  0x0665,  0x0665,  0x0665,  0x060c,  0x0678,  0x066c,  0x060d,  0x066e, /* 2200 */
  0x0680,  0x0665,  0x0665,  0x0678,  0x0665,  0x0665,  0x0665,  0x0665, /* 2208 */
  0x0665,  0x0665,  0x0665,  0x0682,  0x066b,  0x060d,  0x060c,  0x060d, /* 2216 */
  0x0678,  0x0678,  0x0665,  0x0665,  0x0665,  0x0665,  0x060c,  0x0678, /* 2224 */
  0x060d,  0x060d,  0x0664,  0x066c,  0x066c,  0x0678,  0x0665,  0x0665, /* 2232 */
  0x0665,  0x0665,  0x0665,  0x066c,  0x0665,  0x0665,  0x0665,  0x0665, /* 2240 */
  0x0373,  0x0373,  0x0665,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2248 */
  0x0688,  0x0373,  0x068c,  0x0373,  0x0373,  0x0690,  0x03db,  0x03db, /* 2256 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 2264 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x0694,  0x0654, /* 2272 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0698,  0x0657,  0x060d, /* 2280 */
  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x0373,  0x0373,  0x0373, /* 2288 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x060d, /* 2296 */
  0x065b,  0x0373,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2304 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2312 */
  0x0373,  0x069c,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2320 */
  0x0373,  0x0373,  0x06a0,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2328 */
  0x06a4,  0x0489,  0x06a8,  0x06ac,  0x06b0,  0x06a4,  0x0489,  0x06a8, /* 2336 */
  0x06ac,  0x06b4,  0x06b8,  0x05b5,  0x06bc,  0x06c0,  0x06c4,  0x03db, /* 2344 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x06c8,  0x06cc,  0x06ca, /* 2352 */
  0x06ca,  0x06ca,  0x06ca,  0x06ca,  0x06d0,  0x06d4,  0x06d0,  0x06d0, /* 2360 */
  0x06d0,  0x06d0,  0x06d8,  0x06ab,  0x06af,  0x06dc,  0x0488,  0x06e0, /* 2368 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2376 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2384 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2392 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2400 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2408 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0657,  0x0373,  0x0373, /* 2416 */
  0x0616,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2424 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x060d,  0x060d, /* 2432 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2440 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2448 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2456 */
  0x0373,  0x0373,  0x0373,  0x0657,  0x0373,  0x0373,  0x0373,  0x0373, /* 2464 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0395, /* 2472 */
  0x0373,  0x0373,  0x0373,  0x0699,  0x0373,  0x0373,  0x0373,  0x04a8, /* 2480 */
  0x0373,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2488 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2496 */
  0x069f,  0x069e,  0x0395,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2504 */
  0x0373,  0x0373,  0x069f,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2512 */
  0x0373,  0x0373,  0x0373,  0x06e4,  0x069c,  0x06e8,  0x0373,  0x069c, /* 2520 */
  0x069f,  0x0373,  0x03f2,  0x03f2,  0x03f2,  0x06ec,  0x06f0,  0x06f4, /* 2528 */
  0x06a4,  0x0489,  0x06f8,  0x06f0,  0x06f4,  0x04a8,  0x0373,  0x0373, /* 2536 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x069f,  0x0373,  0x0373,  0x069c, /* 2544 */
  0x0682,  0x06fc,  0x0700,  0x0704,  0x066e,  0x066b,  0x060d,  0x066b, /* 2552 */
  0x0678,  0x0708,  0x03f2,  0x03f2,  0x060d,  0x060d,  0x060d,  0x060d, /* 2560 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 2568 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 2576 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 2584 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 2592 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 2600 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 2608 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 2616 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 2624 */
  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d, /* 2632 */
  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d, /* 2640 */
  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d, /* 2648 */
  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x060d, /* 2656 */
  0x070c,  0x0710,  0x0714,  0x0710,  0x0710,  0x0710,  0x0718,  0x0665, /* 2664 */
  0x0665,  0x0665,  0x0665,  0x0665,  0x060d,  0x060d,  0x060c,  0x060d, /* 2672 */
  0x0665,  0x066c,  0x0681,  0x0678,  0x066b,  0x066c,  0x03f2,  0x060c, /* 2680 */
  0x0684,  0x066c,  0x066c,  0x060d,  0x060d,  0x0665,  0x066c,  0x070a, /* 2688 */
  0x060d,  0x060d,  0x0678,  0x0665,  0x0665,  0x0665,  0x0665,  0x067d, /* 2696 */
  0x066c,  0x0680,  0x0684,  0x066b,  0x060d,  0x066c,  0x060d,  0x066b, /* 2704 */
  0x060d,  0x060d,  0x060d,  0x060d,  0x060d,  0x066e,  0x060c,  0x060d, /* 2712 */
  0x060d,  0x066c,  0x0678,  0x067c,  0x0682,  0x060c,  0x0664,  0x0665, /* 2720 */
  0x0665,  0x0665,  0x0665,  0x0665,  0x0665,  0x0665,  0x0665,  0x0665, /* 2728 */
  0x0665,  0x0678,  0x0665,  0x067c,  0x0665,  0x0665,  0x0665,  0x0665, /* 2736 */
  0x0665,  0x0665,  0x0665,  0x0665,  0x0665,  0x066b,  0x060d,  0x0680, /* 2744 */
  0x0678,  0x066b,  0x060d,  0x066b,  0x066e,  0x066e,  0x0665,  0x0681, /* 2752 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2760 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x060d,  0x060d,  0x060d,  0x060d, /* 2768 */
  0x060d,  0x065c,  0x060d,  0x071c,  0x0373,  0x04a8,  0x01ab,  0x01ab, /* 2776 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2784 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2792 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2800 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2808 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2816 */
  0x0209,  0x0209,  0x0209,  0x0209,  0x0209,  0x0209,  0x0209,  0x0209, /* 2824 */
  0x0209,  0x0209,  0x0209,  0x0210,  0x021d,  0x021d,  0x021d,  0x021d, /* 2832 */
  0x021d,  0x021d,  0x021d,  0x021d,  0x021d,  0x021d,  0x021d,  0x0720, /* 2840 */
  0x0724,  0x0728,  0x00bd,  0x0725,  0x072c,  0x012d,  0x0130,  0x0730, /* 2848 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 2856 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 2864 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 2872 */
  0x00bc,  0x0734,  0x069c,  0x01ab,  0x01ab,  0x01ab,  0x048f,  0x0738, /* 2880 */
  0x0514,  0x0514,  0x0514,  0x0514,  0x0514,  0x0514,  0x0514,  0x0514, /* 2888 */
  0x0514,  0x073c,  0x01ab,  0x01ab,  0x0110,  0x0110,  0x0110,  0x0110, /* 2896 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 2904 */
  0x0110,  0x02d8,  0x01ab,  0x0740,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2912 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x030e,  0x01ab,  0x01ab, /* 2920 */
  0x0110,  0x030e,  0x0110,  0x030e,  0x0110,  0x030e,  0x0110,  0x030e, /* 2928 */
  0x0110,  0x030e,  0x0110,  0x030e,  0x0110,  0x030e,  0x0110,  0x030e, /* 2936 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 2944 */
  0x058b,  0x058d,  0x058c,  0x058d,  0x0490,  0x0493,  0x0494,  0x058d, /* 2952 */
  0x0744,  0x03f2,  0x0599,  0x0748,  0x01aa,  0x01ab,  0x01ab,  0x01ab, /* 2960 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2968 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 2976 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x069d,  0x0373, /* 2984 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 2992 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 3000 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x01ab,  0x01ab,  0x01ab, /* 3008 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 3016 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 3024 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 3032 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 3040 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 3048 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 3056 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0395,  0x01ab,  0x01ab, /* 3064 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x0373,  0x0373,  0x0373,  0x01ab, /* 3072 */
  0x074c,  0x0750,  0x03f2,  0x03f2,  0x068d,  0x03f2,  0x03f2,  0x0754, /* 3080 */
  0x0758,  0x075c,  0x0760,  0x0194,  0x0764,  0x0768,  0x076c,  0x0770, /* 3088 */
  0x030c,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3096 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3104 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x030e,  0x0774,  0x0778, /* 3112 */
  0x077c,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3120 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3128 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0780,  0x0784, /* 3136 */
  0x01ab,  0x030c,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3144 */
  0x0110,  0x0110,  0x0110,  0x02d8,  0x030c,  0x0110,  0x0110,  0x0110, /* 3152 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3160 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3168 */
  0x0110,  0x0110,  0x0110,  0x030e,  0x0788,  0x078c,  0x03db,  0x03db, /* 3176 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x01ab,  0x01ab, /* 3184 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 3192 */
  0x0373,  0x01ab,  0x01ab,  0x01ab,  0x0110,  0x0110,  0x0110,  0x0110, /* 3200 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x0790, /* 3208 */
  0x0338,  0x0445,  0x0794,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 3216 */
  0x03db,  0x01ab,  0x01ab,  0x01ab,  0x0798,  0x079c,  0x07a0,  0x07a4, /* 3224 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x068f, /* 3232 */
  0x0338,  0x0445,  0x0794,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 3240 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x07a8,  0x07ac,  0x07b0,  0x07b4, /* 3248 */
  0x03db,  0x03db,  0x03db,  0x0373,  0x03db,  0x03db,  0x03db,  0x03db, /* 3256 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x07b8, /* 3264 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 3272 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 3280 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 3288 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x0694,  0x068f,  0x03db, /* 3296 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 3304 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 3312 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x0695, /* 3320 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x0694, /* 3328 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3336 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3344 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3352 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3360 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3368 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x02d8,  0x01ab,  0x01ab, /* 3376 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 3384 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 3392 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3400 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3408 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3416 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3424 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3432 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3440 */
  0x0110,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3448 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3456 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x07bc,  0x0110,  0x0110, /* 3464 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3472 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3480 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3488 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3496 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3504 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3512 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3520 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3528 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3536 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3544 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3552 */
  0x0110,  0x0110,  0x0110,  0x032a,  0x0373,  0x0373,  0x0373,  0x0373, /* 3560 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 3568 */
  0x0373,  0x069c,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3576 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3584 */
  0x0110,  0x0110,  0x0110,  0x07c0,  0x0110,  0x0110,  0x0110,  0x0110, /* 3592 */
  0x02fa,  0x02fe,  0x04c0,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3600 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 3608 */
  0x07c4,  0x00bc,  0x00bc,  0x07c8,  0x07cc,  0x01ab,  0x01ab,  0x07d0, /* 3616 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x01ab,  0x01ab, /* 3624 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3632 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3640 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3648 */
  0x0186,  0x0186,  0x0186,  0x0186,  0x0186,  0x0187,  0x018a,  0x018a, /* 3656 */
  0x07d4,  0x00bc,  0x00bc,  0x00bc,  0x013b,  0x00bc,  0x00bc,  0x00bc, /* 3664 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x00bc, /* 3672 */
  0x00bc,  0x00bc,  0x00bc,  0x00bc,  0x07d8,  0x0130,  0x00cc,  0x07dc, /* 3680 */
  0x00bc,  0x00bc,  0x07e0,  0x07e4,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3688 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3696 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3704 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x02f1,  0x0110, /* 3712 */
  0x07e8,  0x07ec,  0x0352,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3720 */
  0x0408,  0x040d,  0x0373,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3728 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3736 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0490,  0x01ab,  0x01ab, /* 3744 */
  0x041b,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3752 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x02e5,  0x02e5,  0x02e5, /* 3760 */
  0x02e5,  0x02f0,  0x01ab,  0x0466,  0x02fa,  0x02fe,  0x03d0,  0x01ab, /* 3768 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3776 */
  0x02fa,  0x02fe,  0x04c0,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3784 */
  0x0110,  0x02f4,  0x0194,  0x02f6,  0x0110,  0x0110,  0x0110,  0x0110, /* 3792 */
  0x0110,  0x0352,  0x0194,  0x0194,  0x02e3,  0x01ab,  0x01ab,  0x043d, /* 3800 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3808 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3816 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3824 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3832 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3840 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3848 */
  0x0110,  0x0110,  0x02ec,  0x02e2,  0x040d,  0x0344,  0x01ab,  0x01ab, /* 3856 */
  0x0352,  0x0110,  0x0110,  0x07f0,  0x02fa,  0x02fe,  0x03d0,  0x0216, /* 3864 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3872 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3880 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3888 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3896 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3904 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3912 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3920 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3928 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3936 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 3944 */
  0x0110,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3952 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3960 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 3968 */
  0x07f4,  0x07f8,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 3976 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 3984 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 3992 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4000 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4008 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4016 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4024 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4032 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4040 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4048 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4056 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4064 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4072 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4080 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4088 */
  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4,  0x07f4, /* 4096 */
  0x07fc,  0x0800,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4104 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4112 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4120 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4128 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4136 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4144 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4152 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4160 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4168 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4176 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4184 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4192 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4200 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4208 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4216 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 4224 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4232 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4240 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4248 */
  0x0110,  0x0110,  0x0804,  0x0110,  0x0808,  0x0110,  0x080c,  0x0110, /* 4256 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4264 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0810,  0x0110,  0x0110,  0x0110, /* 4272 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0814,  0x0110,  0x0110,  0x0110, /* 4280 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0818, /* 4288 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4296 */
  0x0110,  0x0110,  0x0110,  0x02d8,  0x0110,  0x0110,  0x0110,  0x0110, /* 4304 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4312 */
  0x0110,  0x0110,  0x030e,  0x01ab,  0x0110,  0x0110,  0x0110,  0x0110, /* 4320 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4328 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4336 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x02d8,  0x01ab, /* 4344 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4352 */
  0x0514,  0x0526,  0x01ab,  0x01ab,  0x081c,  0x0514,  0x01ab,  0x0820, /* 4360 */
  0x023c,  0x023c,  0x0824,  0x023c,  0x023c,  0x0244,  0x023c,  0x0828, /* 4368 */
  0x0245,  0x0246,  0x023c,  0x023c,  0x0269,  0x0269,  0x0269,  0x0269, /* 4376 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4384 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4392 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x082c,  0x01ab,  0x01ab,  0x01ab, /* 4400 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x0830,  0x0269,  0x0269,  0x0269, /* 4408 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4416 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4424 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4432 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4440 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4448 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4456 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4464 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4472 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4480 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4488 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0834, /* 4496 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x0269,  0x0269,  0x0269,  0x0269, /* 4504 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4512 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0831,  0x0269,  0x0269,  0x0269, /* 4520 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4528 */
  0x0269,  0x0269,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4536 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x0269,  0x0269,  0x0269,  0x0838, /* 4544 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0490,  0x083c,  0x0840,  0x01ab, /* 4552 */
  0x0194,  0x0278,  0x01ab,  0x01ab,  0x0844,  0x0848,  0x084c,  0x084a, /* 4560 */
  0x084a,  0x0850,  0x0854,  0x0858,  0x085c,  0x0860,  0x0864,  0x0868, /* 4568 */
  0x086c,  0x0700,  0x0870,  0x01ab,  0x0269,  0x0874,  0x0269,  0x0269, /* 4576 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4584 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4592 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269, /* 4600 */
  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0269,  0x0878, /* 4608 */
  0x087c,  0x0018,  0x001c,  0x0020,  0x0024,  0x0028,  0x002c,  0x0030, /* 4616 */
  0x0034,  0x0038,  0x0880,  0x0040,  0x0044,  0x0048,  0x004c,  0x0050, /* 4624 */
  0x0054,  0x0058,  0x0884,  0x0060,  0x0064,  0x0068,  0x006c,  0x0888, /* 4632 */
  0x088c,  0x0890,  0x0110,  0x0110,  0x0894,  0x0110,  0x0110,  0x0110, /* 4640 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x04c2, /* 4648 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x030e, /* 4656 */
  0x02f2,  0x0110,  0x02f2,  0x0110,  0x02f2,  0x0110,  0x02f2,  0x032a, /* 4664 */
  0x0898,  0x089c,  0x0659,  0x08a0,  0x01ab,  0x01ab,  0x08a4,  0x0395, /* 4672 */
  0x0110,  0x0110,  0x0110,  0x030c,  0x0110,  0x0110,  0x0110,  0x0110, /* 4680 */
  0x0110,  0x030e,  0x0110,  0x0110,  0x0110,  0x0110,  0x030e,  0x0317, /* 4688 */
  0x0110,  0x0110,  0x0110,  0x02d8,  0x0110,  0x0110,  0x0110,  0x02d8, /* 4696 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4704 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4712 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4720 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4728 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x030e,  0x01ab, /* 4736 */
  0x08a8,  0x08ac,  0x0442,  0x0446,  0x044a,  0x044e,  0x08b0,  0x08b4, /* 4744 */
  0x08b8,  0x08bc,  0x08c0,  0x08c4,  0x08c8,  0x03a2,  0x03db,  0x03db, /* 4752 */
  0x08cc,  0x08d0,  0x08d4,  0x08d8,  0x08d5,  0x08dc,  0x08e0,  0x08e4, /* 4760 */
  0x08e8,  0x08ec,  0x08f0,  0x08f4,  0x08d8,  0x08f8,  0x08fc,  0x0373, /* 4768 */
  0x0373,  0x0373,  0x0900,  0x01ab,  0x0373,  0x0373,  0x0373,  0x01ab, /* 4776 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4784 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x03db,  0x03db,  0x03db,  0x03db, /* 4792 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x0904, /* 4800 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4808 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4816 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4824 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4832 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x032a, /* 4840 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4848 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x032a,  0x01ab,  0x01ab,  0x01ab, /* 4856 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4864 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x030e, /* 4872 */
  0x0908,  0x01ab,  0x01ab,  0x01ab,  0x0110,  0x0110,  0x0110,  0x0110, /* 4880 */
  0x090c,  0x0110,  0x0910,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4888 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4896 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0914, /* 4904 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4912 */
  0x0110,  0x01ab,  0x0110,  0x0110,  0x0918,  0x091c,  0x01ab,  0x01ab, /* 4920 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4928 */
  0x0920,  0x0924,  0x0920,  0x0920,  0x0920,  0x0920,  0x0920,  0x0920, /* 4936 */
  0x0920,  0x0920,  0x0928,  0x092c,  0x0928,  0x0928,  0x0928,  0x0928, /* 4944 */
  0x0928,  0x0928,  0x0928,  0x0928,  0x0110,  0x0110,  0x0110,  0x0110, /* 4952 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 4960 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x02d8, /* 4968 */
  0x02fa,  0x02fe,  0x03d0,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4976 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4984 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 4992 */
  0x023c,  0x0930,  0x0246,  0x023c,  0x023c,  0x023c,  0x023c,  0x023c, /* 5000 */
  0x023c,  0x023c,  0x023c,  0x023c,  0x023c,  0x0245,  0x0934,  0x0931, /* 5008 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5016 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5024 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5032 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5040 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5048 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5056 */
  0x023c,  0x023c,  0x023c,  0x023c,  0x023c,  0x0938,  0x093c,  0x04a9, /* 5064 */
  0x023c,  0x023c,  0x023c,  0x023c,  0x023c,  0x023c,  0x0930,  0x0940, /* 5072 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5080 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5088 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5096 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5104 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5112 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5120 */
  0x0944,  0x034a,  0x01ab,  0x0194,  0x023c,  0x0247,  0x0247,  0x023c, /* 5128 */
  0x023c,  0x023c,  0x023c,  0x023c,  0x023c,  0x01ab,  0x0278,  0x0348, /* 5136 */
  0x0948,  0x094c,  0x01ab,  0x01ab,  0x0950,  0x0954,  0x024c,  0x01ab, /* 5144 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5152 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5160 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5168 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5176 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5184 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5192 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5200 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5208 */
  0x0110,  0x0110,  0x0110,  0x030e,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5216 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5224 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5232 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5240 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5248 */
  0x075a,  0x075e,  0x075b,  0x0958,  0x075d,  0x095c,  0x075c,  0x0960, /* 5256 */
  0x0964,  0x0968,  0x075e,  0x096c,  0x0970,  0x096c,  0x0974,  0x0978, /* 5264 */
  0x097c,  0x0980,  0x0984,  0x0988,  0x098c,  0x0990,  0x0994,  0x0998, /* 5272 */
  0x099c,  0x01ab,  0x01ab,  0x01ab,  0x0216,  0x01ab,  0x01ab,  0x01ab, /* 5280 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5288 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5296 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5304 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5312 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 5320 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 5328 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 5336 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 5344 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 5352 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 5360 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 5368 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x09a0,  0x01ab,  0x01ab, /* 5376 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 5384 */
  0x03db,  0x07b8,  0x03fd,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 5392 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 5400 */
  0x03db,  0x09a4,  0x03e0,  0x09a8,  0x09ac,  0x05a4,  0x09b0,  0x0194, /* 5408 */
  0x09b4,  0x09b8,  0x0194,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db, /* 5416 */
  0x03db,  0x03db,  0x03de,  0x03e0,  0x03db,  0x03db,  0x03db,  0x03db, /* 5424 */
  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x03db,  0x09a0, /* 5432 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5440 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 5448 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 5456 */
  0x025e,  0x09bc,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5464 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5472 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5480 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5488 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5496 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5504 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 5512 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 5520 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x069c,  0x01ab,  0x01ab, /* 5528 */
  0x0338,  0x0445,  0x0449,  0x044d,  0x09c0,  0x01ab,  0x01ab,  0x01ab, /* 5536 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5544 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5552 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5560 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5568 */
  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e4,  0x0130, /* 5576 */
  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x05e9,  0x05e9,  0x05e9, /* 5584 */
  0x05e9,  0x05e9,  0x05e9,  0x05e4,  0x0130,  0x09c4,  0x0130,  0x0130, /* 5592 */
  0x0130,  0x0130,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9, /* 5600 */
  0x05e4,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x09c8, /* 5608 */
  0x09cc,  0x09c9,  0x09d0,  0x09c8,  0x05e9,  0x05e4,  0x09d4,  0x09d8, /* 5616 */
  0x0130,  0x09dc,  0x0130,  0x0130,  0x05e9,  0x05e9,  0x05e9,  0x05e9, /* 5624 */
  0x05e9,  0x05e9,  0x05e4,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130, /* 5632 */
  0x0130,  0x09e0,  0x09e4,  0x09d0,  0x05e9,  0x09c8,  0x05e9,  0x09e8, /* 5640 */
  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x09e0,  0x09e4, /* 5648 */
  0x05e9,  0x09e6,  0x09cf,  0x05e9,  0x09ec,  0x0130,  0x0130,  0x0130, /* 5656 */
  0x0130,  0x0130,  0x0130,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9, /* 5664 */
  0x05e9,  0x05e4,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130, /* 5672 */
  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e4,  0x0130, /* 5680 */
  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x05e9,  0x05e9,  0x05e9, /* 5688 */
  0x05e9,  0x05e9,  0x05e9,  0x05e4,  0x0130,  0x0130,  0x0130,  0x0130, /* 5696 */
  0x0130,  0x0130,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9, /* 5704 */
  0x05e4,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x05e9, /* 5712 */
  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e4,  0x0130,  0x0130, /* 5720 */
  0x0130,  0x0130,  0x0130,  0x0130,  0x05e9,  0x05e9,  0x05e9,  0x05e9, /* 5728 */
  0x05e9,  0x05e9,  0x05e4,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130, /* 5736 */
  0x0130,  0x09f0,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9, /* 5744 */
  0x09f4,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x09f8,  0x0130, /* 5752 */
  0x0608,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x09fc,  0x0130, /* 5760 */
  0x0130,  0x0130,  0x0130,  0x0130,  0x0130,  0x0a00,  0x0130,  0x05e9, /* 5768 */
  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x05e9,  0x09f4,  0x0130,  0x0130, /* 5776 */
  0x0130,  0x0130,  0x0130,  0x09f8,  0x0130,  0x0608,  0x05e9,  0x05e9, /* 5784 */
  0x05e9,  0x05e9,  0x05e9,  0x09fc,  0x0130,  0x0130,  0x0130,  0x0130, /* 5792 */
  0x0130,  0x0130,  0x0a04,  0x0130,  0x05e9,  0x05e9,  0x05e9,  0x05e9, /* 5800 */
  0x05e9,  0x05e9,  0x09f4,  0x0130,  0x0130,  0x0130,  0x0130,  0x0130, /* 5808 */
  0x09f8,  0x0130,  0x0a08,  0x0a0c,  0x0026,  0x002a,  0x0024,  0x0028, /* 5816 */
  0x0a10,  0x0026,  0x002a,  0x0024,  0x0028,  0x0a14,  0x0026,  0x002a, /* 5824 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 5832 */
  0x0373,  0x0373,  0x0373,  0x01ab,  0x0373,  0x0373,  0x0373,  0x0373, /* 5840 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 5848 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x0373, /* 5856 */
  0x0373,  0x0373,  0x0373,  0x0373,  0x0373,  0x01ab,  0x01ab,  0x01ab, /* 5864 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5872 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5880 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5888 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5896 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5904 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5912 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5920 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5928 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5936 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x030e,  0x01ab,  0x01ab, /* 5944 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 5952 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5960 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5968 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5976 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 5984 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0a18,  0x0110,  0x0110,  0x0110, /* 5992 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 6000 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 6008 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110, /* 6016 */
  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x0110,  0x02d8, /* 6024 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6032 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6040 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6048 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6056 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6064 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6072 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6080 */
  0x0a1c,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6088 */
  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4, /* 6096 */
  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4, /* 6104 */
  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4,  0x05a4, /* 6112 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6120 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6128 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6136 */
  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6144 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 6152 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 6160 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 6168 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 6176 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 6184 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 6192 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194,  0x0194, /* 6200 */
  0x0194,  0x0194,  0x0194,  0x0194,  0x01ab,  0x01ab,  0x01ab,  0x01ab, /* 6208 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6216 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6224 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6232 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6240 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6248 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6256 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6264 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x0a20, /* 6272 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6280 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6288 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6296 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6304 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6312 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6320 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc, /* 6328 */
  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x07fc,  0x0a24, /* 6336 */

};

/**
 * Property table has 2598 entries
 */
static unsigned int prop[] =
{
  0x4800100f,  0x4800100f,  0x4800100f,  0x4800100f, /* 4 */
  0x4800100f,  0x4800100f,  0x4800100f,  0x4800100f, /* 8 */
  0x4800100f,  0x5800000f,  0x5000000f,  0x5800000f, /* 12 */
  0x6000000f,  0x5000000f,  0x4800100f,  0x4800100f, /* 16 */
  0x5000000f,  0x5000000f,  0x5000000f,  0x5800000f, /* 20 */
  0x6000400c,  0x68000018,  0x68000018,  0x28000018, /* 24 */
  0x2800501a,  0x28000018,  0x68000018,  0x68000018, /* 28 */
  0xe8000015,  0xe8000016,  0x68000018,  0x20000019, /* 32 */
  0x38000018,  0x20000014,  0x38000018,  0x38000018, /* 36 */
  0x18003409,  0x18003429,  0x18003449,  0x18003469, /* 40 */
  0x18003489,  0x180034a9,  0x180034c9,  0x180034e9, /* 44 */
  0x18003509,  0x18003529,  0x38000018,  0x68000018, /* 48 */
  0xe8000019,  0x68000019,  0xe8000019,  0x68000018, /* 52 */
  0x68000018,  0x00827c01,  0x00827c21,  0x00827c41, /* 56 */
  0x00827c61,  0x00827c81,  0x00827ca1,  0x00827cc1, /* 60 */
  0x00827ce1,  0x07fd7d01,  0x07fd7d21,  0x00827d41, /* 64 */
  0x00827d61,  0x00827d81,  0x00827da1,  0x00827dc1, /* 68 */
  0x00827de1,  0x00827e01,  0x00827e21,  0x00827e41, /* 72 */
  0x00827e61,  0x00827e81,  0x00827ea1,  0x00827ec1, /* 76 */
  0x00827ee1,  0x00827f01,  0x00827f21,  0xe8000015, /* 80 */
  0x68000018,  0xe8000016,  0x6800001b,  0x68002017, /* 84 */
  0x6800001b,  0x00817c02,  0x00817c22,  0x00817c42, /* 88 */
  0x00817c62,  0x00817c82,  0x00817ca2,  0x00817cc2, /* 92 */
  0x00817ce2,  0x07fd7d02,  0x00817d22,  0x00817d42, /* 96 */
  0x00817d62,  0x00817d82,  0x00817da2,  0x00817dc2, /* 100 */
  0x00817de2,  0x00817e02,  0x00817e22,  0x00817e42, /* 104 */
  0x00817e62,  0x00817e82,  0x00817ea2,  0x00817ec2, /* 108 */
  0x00817ee2,  0x00817f02,  0x00817f22,  0xe8000015, /* 112 */
  0x68000019,  0xe8000016,  0x68000019,  0x4800100f, /* 116 */
  0x4800100f,  0x5000100f,  0x4800100f,  0x4800100f, /* 120 */
  0x3800000c,  0x68000018,  0x2800501a,  0x2800501a, /* 124 */
  0x2800501a,  0x2800501a,  0x6800001c,  0x6800001c, /* 128 */
  0x6800001b,  0x6800001c,  0x00007002,  0xe800001d, /* 132 */
  0x68000019,  0x48001010,  0x6800001c,  0x6800001b, /* 136 */
  0x2800001c,  0x28000019,  0x1800044b,  0x1800046b, /* 140 */
  0x6800001b,  0x07fd7002,  0x6800001c,  0x68000018, /* 144 */
  0x6800001b,  0x1800042b,  0x00007002,  0xe800001e, /* 148 */
  0x68000beb,  0x68000beb,  0x68000beb,  0x68000018, /* 152 */
  0x00827001,  0x00827001,  0x00827001,  0x00827001, /* 156 */
  0x00827001,  0x00827001,  0x00827001,  0x00827001, /* 160 */
  0x07fd7001,  0x07fd7001,  0x00827001,  0x00827001, /* 164 */
  0x00827001,  0x00827001,  0x00827001,  0x68000019, /* 168 */
  0x00827001,  0x00827001,  0x00827001,  0x07fd7002, /* 172 */
  0x00817002,  0x00817002,  0x00817002,  0x00817002, /* 176 */
  0x00817002,  0x00817002,  0x00817002,  0x00817002, /* 180 */
  0x00817002,  0x00817002,  0x00817002,  0x68000019, /* 184 */
  0x00817002,  0x00817002,  0x00817002,  0x061d7002, /* 188 */
  0x00067001,  0x00057002,  0x00067001,  0x00057002, /* 192 */
  0x00067001,  0x00057002,  0x00067001,  0x00057002, /* 196 */
  0x07fd7001,  0x00057002,  0x00067001,  0x00057002, /* 200 */
  0x07fd7001,  0x03a17002,  0x00067001,  0x00057002, /* 204 */
  0x00007002,  0x00067001,  0x00057002,  0x00067001, /* 208 */
  0x00057002,  0x07fd7002,  0x00067001,  0x00057002, /* 212 */
  0x061e7001,  0x00067001,  0x00057002,  0x00067001, /* 216 */
  0x04f57002,  0x034a7001,  0x00067001,  0x00057002, /* 220 */
  0x00067001,  0x00057002,  0x033a7001,  0x00067001, /* 224 */
  0x00057002,  0x03367001,  0x03367001,  0x00067001, /* 228 */
  0x00057002,  0x00007002,  0x013e7001,  0x032a7001, /* 232 */
  0x032e7001,  0x00067001,  0x00057002,  0x03367001, /* 236 */
  0x033e7001,  0x067d7002,  0x034e7001,  0x03467001, /* 240 */
  0x00067001,  0x00057002,  0x05757002,  0x00007002, /* 244 */
  0x034e7001,  0x03567001,  0x05f97002,  0x035a7001, /* 248 */
  0x00067001,  0x00057002,  0x036a7001,  0x00067001, /* 252 */
  0x00057002,  0x036a7001,  0x00007002,  0x00007002, /* 256 */
  0x00057002,  0x03667001,  0x03667001,  0x00067001, /* 260 */
  0x00057002,  0x00067001,  0x00057002,  0x036e7001, /* 264 */
  0x00067001,  0x00057002,  0x00007002,  0x00007005, /* 268 */
  0x00067001,  0x00057002,  0x00007002,  0x07217002, /* 272 */
  0x00007005,  0x00007005,  0x00007005,  0x00007005, /* 276 */
  0x000af001,  0x0007f003,  0x0009f002,  0x000af001, /* 280 */
  0x0007f003,  0x0009f002,  0x000af001,  0x0007f003, /* 284 */
  0x0009f002,  0x00067001,  0x00057002,  0x00067001, /* 288 */
  0x00057002,  0x013d7002,  0x00067001,  0x00057002, /* 292 */
  0x07fd7002,  0x000af001,  0x0007f003,  0x0009f002, /* 296 */
  0x00067001,  0x00057002,  0x067e7001,  0x07227001, /* 300 */
  0x05fa7001,  0x00007002,  0x00067001,  0x00057002, /* 304 */
  0x00007002,  0x00007002,  0x00007002,  0x00007002, /* 308 */
  0x00007002,  0x00007002,  0x07fe7001,  0x00067001, /* 312 */
  0x00057002,  0x05767001,  0x07fe7001,  0x00007002, /* 316 */
  0x00007002,  0x00067001,  0x00057002,  0x04f67001, /* 320 */
  0x01167001,  0x011e7001,  0x00067001,  0x00057002, /* 324 */
  0x07fd7002,  0x07fd7002,  0x00007002,  0x03497002, /* 328 */
  0x03397002,  0x00007002,  0x03357002,  0x03357002, /* 332 */
  0x00007002,  0x03297002,  0x00007002,  0x032d7002, /* 336 */
  0x03357002,  0x00007002,  0x00007002,  0x033d7002, /* 340 */
  0x03457002,  0x034d7002,  0x00007002,  0x07fd7002, /* 344 */
  0x00007002,  0x00007002,  0x00007002,  0x034d7002, /* 348 */
  0x00007002,  0x07fd7002,  0x03557002,  0x00007002, /* 352 */
  0x00007002,  0x03597002,  0x00007002,  0x00007002, /* 356 */
  0x03697002,  0x00007002,  0x00007002,  0x03697002, /* 360 */
  0x03697002,  0x01157002,  0x03657002,  0x03657002, /* 364 */
  0x011d7002,  0x00007002,  0x00007002,  0x00007002, /* 368 */
  0x00007002,  0x00007002,  0x036d7002,  0x00007002, /* 372 */
  0x00007005,  0x00007002,  0x00007002,  0x00007002, /* 376 */
  0x00007004,  0x00007004,  0x00007004,  0x00007004, /* 380 */
  0x00007004,  0x00007004,  0x00007004,  0x00007004, /* 384 */
  0x00007004,  0x68007004,  0x68007004,  0x00007004, /* 388 */
  0x00007004,  0x00007004,  0x6800001b,  0x6800001b, /* 392 */
  0x6800001b,  0x6800001b,  0x68007004,  0x68007004, /* 396 */
  0x68007004,  0x68007004,  0x68007004,  0x68007004, /* 400 */
  0x68007004,  0x6800001b,  0x00007004,  0x6800001b, /* 404 */
  0x40003006,  0x40003006,  0x40003006,  0x40003006, /* 408 */
  0x40003006,  0x40003006,  0x40003006,  0x47fd3006, /* 412 */
  0x40003006,  0x46b13006,  0x40003006,  0x40003006, /* 416 */
  0x68007004,  0x6800001b,  0x00067001,  0x00057002, /* 420 */
  0x78000000,  0x78000000,  0x00007004,  0x05f97002, /* 424 */
  0x05f97002,  0x05f97002,  0x68000018,  0x78000000, /* 428 */
  0x78000000,  0x78000000,  0x78000000,  0x78000000, /* 432 */
  0x6800001b,  0x6800001b,  0x009a7001,  0x68000018, /* 436 */
  0x00967001,  0x00967001,  0x00967001,  0x78000000, /* 440 */
  0x01027001,  0x78000000,  0x00fe7001,  0x00fe7001, /* 444 */
  0x07fd7002,  0x00827001,  0x00827001,  0x00827001, /* 448 */
  0x00827001,  0x00827001,  0x78000000,  0x07fd7001, /* 452 */
  0x00997002,  0x00957002,  0x00957002,  0x00957002, /* 456 */
  0x00817002,  0x00817002,  0x007d7002,  0x00817002, /* 460 */
  0x01017002,  0x00fd7002,  0x00fd7002,  0x00227001, /* 464 */
  0x00f97002,  0x00e57002,  0x00007001,  0x00007001, /* 468 */
  0x00007001,  0x00bd7002,  0x00d97002,  0x00217002, /* 472 */
  0x01597002,  0x01417002,  0x07e57002,  0x00007002, /* 476 */
  0x07127001,  0x01817002,  0x68000019,  0x00067001, /* 480 */
  0x00057002,  0x07e67001,  0x00067001,  0x00057002, /* 484 */
  0x00007002,  0x05fa7001,  0x05fa7001,  0x05fa7001, /* 488 */
  0x01427001,  0x01427001,  0x01427001,  0x01427001, /* 492 */
  0x01427001,  0x01427001,  0x01427001,  0x01427001, /* 496 */
  0x01417002,  0x01417002,  0x01417002,  0x01417002, /* 500 */
  0x01417002,  0x01417002,  0x01417002,  0x01417002, /* 504 */
  0x00067001,  0x00057002,  0x0000001c,  0x40003006, /* 508 */
  0x40000007,  0x40000007,  0x00067001,  0x00057002, /* 512 */
  0x003e7001,  0x00067001,  0x00057002,  0x00067001, /* 516 */
  0x00057002,  0x00067001,  0x00057002,  0x003d7002, /* 520 */
  0x78000000,  0x00c27001,  0x00c27001,  0x00c27001, /* 524 */
  0x00c27001,  0x00c27001,  0x00c27001,  0x00c27001, /* 528 */
  0x00c27001,  0x00c27001,  0x00c27001,  0x78000000, /* 532 */
  0x78000000,  0x00007004,  0x00000018,  0x00000018, /* 536 */
  0x00000018,  0x00000018,  0x00000018,  0x00000018, /* 540 */
  0x78000000,  0x00c17002,  0x00c17002,  0x00c17002, /* 544 */
  0x00c17002,  0x00c17002,  0x00c17002,  0x00c17002, /* 548 */
  0x00c17002,  0x00c17002,  0x00c17002,  0x07fd7002, /* 552 */
  0x78000000,  0x00000018,  0x68000014,  0x78000000, /* 556 */
  0x78000000,  0x40003006,  0x40003006,  0x40003006, /* 560 */
  0x40003006,  0x40003006,  0x08000014,  0x40003006, /* 564 */
  0x08000018,  0x40003006,  0x40003006,  0x08000018, /* 568 */
  0x40003006,  0x40003006,  0x08000018,  0x40003006, /* 572 */
  0x08007005,  0x08007005,  0x08007005,  0x08007005, /* 576 */
  0x08007005,  0x08007005,  0x08007005,  0x08007005, /* 580 */
  0x08007005,  0x08007005,  0x08007005,  0x78000000, /* 584 */
  0x08007005,  0x08007005,  0x08007005,  0x08000018, /* 588 */
  0x08000018,  0x78000000,  0x78000000,  0x78000000, /* 592 */
  0x30001010,  0x30001010,  0x30001010,  0x30001010, /* 596 */
  0x78000000,  0x78000000,  0x68000019,  0x68000019, /* 600 */
  0x10000019,  0x28000018,  0x28000018,  0x1000501a, /* 604 */
  0x38000018,  0x10000018,  0x6800001c,  0x6800001c, /* 608 */
  0x40003006,  0x40003006,  0x40003006,  0x10000018, /* 612 */
  0x78000000,  0x78000000,  0x10000018,  0x10000018, /* 616 */
  0x78000000,  0x10007005,  0x10007005,  0x10007005, /* 620 */
  0x10007005,  0x10007005,  0x10007005,  0x10007005, /* 624 */
  0x10007004,  0x10007005,  0x10007005,  0x10007005, /* 628 */
  0x10007005,  0x10007005,  0x10007005,  0x40003006, /* 632 */
  0x40003006,  0x40003006,  0x40003006,  0x78000000, /* 636 */
  0x30003409,  0x30003429,  0x30003449,  0x30003469, /* 640 */
  0x30003489,  0x300034a9,  0x300034c9,  0x300034e9, /* 644 */
  0x30003509,  0x30003529,  0x28000018,  0x30000018, /* 648 */
  0x30000018,  0x10000018,  0x10007005,  0x10007005, /* 652 */
  0x40003006,  0x10007005,  0x10007005,  0x10007005, /* 656 */
  0x10000018,  0x10007005,  0x40003006,  0x40003006, /* 660 */
  0x40003006,  0x30001010,  0x40000007,  0x40003006, /* 664 */
  0x40003006,  0x10007004,  0x10007004,  0x40003006, /* 668 */
  0x40003006,  0x6800001c,  0x40003006,  0x40003006, /* 672 */
  0x40003006,  0x40003006,  0x10007005,  0x10007005, /* 676 */
  0x18003509,  0x18003529,  0x10007005,  0x10007005, /* 680 */
  0x10007005,  0x1000001c,  0x1000001c,  0x10007005, /* 684 */
  0x10000018,  0x10000018,  0x10000018,  0x10000018, /* 688 */
  0x10000018,  0x10000018,  0x10000018,  0x10000018, /* 692 */
  0x10000018,  0x10000018,  0x78000000,  0x48001010, /* 696 */
  0x40003006,  0x10007005,  0x78000000,  0x78000000, /* 700 */
  0x08003409,  0x08003429,  0x08003449,  0x08003469, /* 704 */
  0x08003489,  0x080034a9,  0x080034c9,  0x080034e9, /* 708 */
  0x08003509,  0x08003529,  0x08007005,  0x08007005, /* 712 */
  0x08007005,  0x08007005,  0x08007005,  0x40003006, /* 716 */
  0x08007004,  0x08007004,  0x6800001c,  0x68000018, /* 720 */
  0x68000018,  0x68000018,  0x08007004,  0x78000000, /* 724 */
  0x78000000,  0x40003006,  0x40003006,  0x00003008, /* 728 */
  0x00007005,  0x00007005,  0x78000000,  0x78000000, /* 732 */
  0x40003006,  0x00007005,  0x00003008,  0x00003008, /* 736 */
  0x00003008,  0x40003006,  0x40003006,  0x40003006, /* 740 */
  0x40003006,  0x00003008,  0x00003008,  0x00003008, /* 744 */
  0x00003008,  0x40003006,  0x78000000,  0x78000000, /* 748 */
  0x00007005,  0x40003006,  0x40003006,  0x40003006, /* 752 */
  0x40003006,  0x78000000,  0x78000000,  0x78000000, /* 756 */
  0x00007005,  0x00007005,  0x40003006,  0x40003006, /* 760 */
  0x00000018,  0x00000018,  0x00003409,  0x00003429, /* 764 */
  0x00003449,  0x00003469,  0x00003489,  0x000034a9, /* 768 */
  0x000034c9,  0x000034e9,  0x00003509,  0x00003529, /* 772 */
  0x00000018,  0x00007004,  0x00007005,  0x78000000, /* 776 */
  0x78000000,  0x40003006,  0x00003008,  0x00003008, /* 780 */
  0x78000000,  0x00007005,  0x00007005,  0x00007005, /* 784 */
  0x00007005,  0x78000000,  0x78000000,  0x00007005, /* 788 */
  0x00007005,  0x78000000,  0x78000000,  0x00007005, /* 792 */
  0x00007005,  0x78000000,  0x00007005,  0x00007005, /* 796 */
  0x00007005,  0x78000000,  0x00007005,  0x78000000, /* 800 */
  0x40003006,  0x78000000,  0x78000000,  0x00003008, /* 804 */
  0x00003008,  0x78000000,  0x78000000,  0x00003008, /* 808 */
  0x00003008,  0x40003006,  0x00007005,  0x78000000, /* 812 */
  0x78000000,  0x78000000,  0x78000000,  0x00003008, /* 816 */
  0x78000000,  0x78000000,  0x00003409,  0x00003429, /* 820 */
  0x00007005,  0x00007005,  0x2800501a,  0x2800501a, /* 824 */
  0x0000042b,  0x0000044b,  0x0000046b,  0x0000048b, /* 828 */
  0x0000000b,  0x0000060b,  0x0000001c,  0x78000000, /* 832 */
  0x40003006,  0x78000000,  0x00003008,  0x00003008, /* 836 */
  0x00003008,  0x40003006,  0x40003006,  0x78000000, /* 840 */
  0x78000000,  0x78000000,  0x78000000,  0x40003006, /* 844 */
  0x40003006,  0x78000000,  0x78000000,  0x40003006, /* 848 */
  0x40003006,  0x40003006,  0x00007005,  0x00007005, /* 852 */
  0x00007005,  0x40003006,  0x78000000,  0x78000000, /* 856 */
  0x40003006,  0x40003006,  0x78000000,  0x40003006, /* 860 */
  0x40003006,  0x00003008,  0x78000000,  0x00003008, /* 864 */
  0x78000000,  0x2800501a,  0x78000000,  0x78000000, /* 868 */
  0x40003006,  0x00007005,  0x00003008,  0x40003006, /* 872 */
  0x0000001c,  0x00007005,  0x78000000,  0x78000000, /* 876 */
  0x00003008,  0x78000000,  0x00003008,  0x00003008, /* 880 */
  0x0000054b,  0x0000088b,  0x0000090b,  0x6800001c, /* 884 */
  0x6800001c,  0x6800001c,  0x6800001c,  0x6800001c, /* 888 */
  0x6800001c,  0x2800501a,  0x6800001c,  0x78000000, /* 892 */
  0x00003008,  0x78000000,  0x40003006,  0x40003006, /* 896 */
  0x6800040b,  0x6800042b,  0x6800044b,  0x6800046b, /* 900 */
  0x6800042b,  0x6800044b,  0x6800046b,  0x0000001c, /* 904 */
  0x40003006,  0x00007005,  0x00003008,  0x00003006, /* 908 */
  0x00003008,  0x78000000,  0x00003006,  0x00003008, /* 912 */
  0x78000000,  0x78000000,  0x00007005,  0x78000000, /* 916 */
  0x78000000,  0x6800001c,  0x6800001c,  0x78000000, /* 920 */
  0x78000000,  0x00007005,  0x00003008,  0x00003008, /* 924 */
  0x0000054b,  0x0000088b,  0x0000090b,  0x00000beb, /* 928 */
  0x00000beb,  0x00000beb,  0x78000000,  0x78000000, /* 932 */
  0x78000000,  0x0000001c,  0x00007005,  0x00007005, /* 936 */
  0x78000000,  0x78000000,  0x40003006,  0x78000000, /* 940 */
  0x40003006,  0x78000000,  0x40003006,  0x78000000, /* 944 */
  0x00000018,  0x78000000,  0x78000000,  0x78000000, /* 948 */
  0x00007005,  0x40003006,  0x00007005,  0x00007005, /* 952 */
  0x78000000,  0x78000000,  0x78000000,  0x2800501a, /* 956 */
  0x00007005,  0x00007005,  0x00007004,  0x40003006, /* 960 */
  0x40003006,  0x40003006,  0x40003006,  0x00000018, /* 964 */
  0x00003509,  0x00003529,  0x00000018,  0x00000018, /* 968 */
  0x78000000,  0x00007005,  0x78000000,  0x00007005, /* 972 */
  0x00007005,  0x78000000,  0x00007004,  0x78000000, /* 976 */
  0x00003509,  0x00003529,  0x78000000,  0x78000000, /* 980 */
  0x00007005,  0x0000001c,  0x0000001c,  0x0000001c, /* 984 */
  0x00000018,  0x00000018,  0x00000018,  0x0000001c, /* 988 */
  0x0000001c,  0x0000001c,  0x0000001c,  0x0000001c, /* 992 */
  0x40003006,  0x40003006,  0x0000001c,  0x0000001c, /* 996 */
  0x00003509,  0x00003529,  0x00000beb,  0x00000beb, /* 1000 */
  0x00000beb,  0x00000beb,  0x00000beb,  0x00000beb, /* 1004 */
  0x0000001c,  0x40003006,  0x0000001c,  0x40003006, /* 1008 */
  0x0000001c,  0x40003006,  0xe8000015,  0xe8000016, /* 1012 */
  0xe8000015,  0xe8000016,  0x00003008,  0x00003008, /* 1016 */
  0x40003006,  0x00000018,  0x40003006,  0x40003006, /* 1020 */
  0x40003006,  0x78000000,  0x0000001c,  0x0000001c, /* 1024 */
  0x0000001c,  0x0000001c,  0x40003006,  0x0000001c, /* 1028 */
  0x0000001c,  0x78000000,  0x0000001c,  0x0000001c, /* 1032 */
  0x00007005,  0x00007005,  0x00007005,  0x00003008, /* 1036 */
  0x40003006,  0x00003008,  0x40003006,  0x40003006, /* 1040 */
  0x00003008,  0x40003006,  0x40003006,  0x00003008, /* 1044 */
  0x00003008,  0x40003006,  0x40003006,  0x00007005, /* 1048 */
  0x00007005,  0x00007005,  0x00003008,  0x00003008, /* 1052 */
  0x00003008,  0x00007005,  0x00007005,  0x00003008, /* 1056 */
  0x00007005,  0x00007005,  0x40003006,  0x00003008, /* 1060 */
  0x00003008,  0x40003006,  0x00007005,  0x00003008, /* 1064 */
  0x78000000,  0x78000000,  0x0000001c,  0x0000001c, /* 1068 */
  0x07fe7001,  0x07fe7001,  0x07fe7001,  0x07fe7001, /* 1072 */
  0x07fe7001,  0x07fe7001,  0x07fe7001,  0x07fe7001, /* 1076 */
  0x07fe7001,  0x07fe7001,  0x78000000,  0x78000000, /* 1080 */
  0x00007005,  0x00007005,  0x00007005,  0x00000018, /* 1084 */
  0x00007004,  0x78000000,  0x78000000,  0x78000000, /* 1088 */
  0x00000018,  0x0000042b,  0x0000044b,  0x0000046b, /* 1092 */
  0x0000048b,  0x000004ab,  0x000004cb,  0x000004eb, /* 1096 */
  0x0000050b,  0x0000052b,  0x0000054b,  0x0000068b, /* 1100 */
  0x000007cb,  0x0000090b,  0x00000a4b,  0x00000b8b, /* 1104 */
  0x000008cb,  0x00000a0b,  0x00000b4b,  0x0000088b, /* 1108 */
  0x00000a0b,  0x78000000,  0x78000000,  0x78000000, /* 1112 */
  0x00007005,  0x00000018,  0x00000018,  0x00007005, /* 1116 */
  0x6000400c,  0x00007005,  0x00007005,  0x00007005, /* 1120 */
  0x00007005,  0x00007005,  0x00007005,  0xe8000015, /* 1124 */
  0xe8000016,  0x78000000,  0x78000000,  0x78000000, /* 1128 */
  0x00000018,  0x00000018,  0x0000762a,  0x0000764a, /* 1132 */
  0x0000766a,  0x78000000,  0x78000000,  0x78000000, /* 1136 */
  0x40003006,  0x00000018,  0x00000018,  0x78000000, /* 1140 */
  0x00007005,  0x78000000,  0x40003006,  0x40003006, /* 1144 */
  0x00001010,  0x00001010,  0x00003008,  0x40003006, /* 1148 */
  0x00003008,  0x00003008,  0x40003006,  0x00003008, /* 1152 */
  0x00000018,  0x00000018,  0x00000018,  0x00007004, /* 1156 */
  0x00000018,  0x00000018,  0x00000018,  0x2800501a, /* 1160 */
  0x6800048b,  0x680004ab,  0x680004cb,  0x680004eb, /* 1164 */
  0x6800050b,  0x6800052b,  0x78000000,  0x78000000, /* 1168 */
  0x68000018,  0x68000018,  0x68000018,  0x68000018, /* 1172 */
  0x68000018,  0x68000018,  0x68000014,  0x68000018, /* 1176 */
  0x68000018,  0x68000018,  0x68000018,  0x40003006, /* 1180 */
  0x40003006,  0x40003006,  0x6000400c,  0x78000000, /* 1184 */
  0x00007005,  0x00007005,  0x00007005,  0x00007004, /* 1188 */
  0x00007005,  0x40003006,  0x00007005,  0x78000000, /* 1192 */
  0x6800001c,  0x78000000,  0x78000000,  0x78000000, /* 1196 */
  0x68000018,  0x68000018,  0x00003409,  0x00003429, /* 1200 */
  0x00003008,  0x00007005,  0x00007005,  0x00007005, /* 1204 */
  0x00003008,  0x00007005,  0x00007005,  0x00007005, /* 1208 */
  0x0000001c,  0x78000000,  0x78000000,  0x78000000, /* 1212 */
  0x00007005,  0x00003008,  0x40003006,  0x40003006, /* 1216 */
  0x00003509,  0x00003529,  0x00007005,  0x00007005, /* 1220 */
  0x00007004,  0x00007004,  0x00000018,  0x00000018, /* 1224 */
  0x00007004,  0x00007004,  0x00007002,  0x00007002, /* 1228 */
  0x00007004,  0x07fd7002,  0x00007002,  0x00007002, /* 1232 */
  0x07fd7002,  0x07fd7002,  0x07fd7002,  0x00ed7002, /* 1236 */
  0x00007002,  0x00007002,  0x07fe7001,  0x00007002, /* 1240 */
  0x07e17002,  0x07e17002,  0x07e17002,  0x07e17002, /* 1244 */
  0x07e17002,  0x07e17002,  0x07e17002,  0x07e17002, /* 1248 */
  0x07e27001,  0x07e27001,  0x07e27001,  0x07e27001, /* 1252 */
  0x07e27001,  0x07e27001,  0x07e27001,  0x07e27001, /* 1256 */
  0x07e17002,  0x07e17002,  0x78000000,  0x78000000, /* 1260 */
  0x07e27001,  0x07e27001,  0x78000000,  0x78000000, /* 1264 */
  0x07e27001,  0x07e27001,  0x78000000,  0x78000000, /* 1268 */
  0x07fd7002,  0x07e17002,  0x07fd7002,  0x07e17002, /* 1272 */
  0x07fd7002,  0x07e17002,  0x07fd7002,  0x07e17002, /* 1276 */
  0x78000000,  0x07e27001,  0x78000000,  0x07e27001, /* 1280 */
  0x78000000,  0x07e27001,  0x78000000,  0x07e27001, /* 1284 */
  0x06d97002,  0x06d97002,  0x06a97002,  0x06a97002, /* 1288 */
  0x06a97002,  0x06a97002,  0x06717002,  0x06717002, /* 1292 */
  0x06017002,  0x06017002,  0x06417002,  0x06417002, /* 1296 */
  0x06097002,  0x06097002,  0x78000000,  0x78000000, /* 1300 */
  0x07fd7002,  0x07fd7002,  0x07fd7002,  0x07fd7002, /* 1304 */
  0x07fd7002,  0x07fd7002,  0x07fd7002,  0x07fd7002, /* 1308 */
  0x07fd7003,  0x07fd7003,  0x07fd7003,  0x07fd7003, /* 1312 */
  0x07fd7003,  0x07fd7003,  0x07fd7003,  0x07fd7003, /* 1316 */
  0x07e17002,  0x07e17002,  0x07fd7002,  0x07fd7002, /* 1320 */
  0x07fd7002,  0x78000000,  0x07fd7002,  0x07fd7002, /* 1324 */
  0x07e27001,  0x07e27001,  0x06da7001,  0x06da7001, /* 1328 */
  0x07fd7003,  0x6800001b,  0x07fd7002,  0x6800001b, /* 1332 */
  0x6800001b,  0x6800001b,  0x07fd7002,  0x07fd7002, /* 1336 */
  0x06aa7001,  0x06aa7001,  0x06aa7001,  0x06aa7001, /* 1340 */
  0x07fd7003,  0x6800001b,  0x6800001b,  0x6800001b, /* 1344 */
  0x07e27001,  0x07e27001,  0x06727001,  0x06727001, /* 1348 */
  0x78000000,  0x6800001b,  0x6800001b,  0x6800001b, /* 1352 */
  0x07fd7002,  0x07e57002,  0x07fd7002,  0x07fd7002, /* 1356 */
  0x07e27001,  0x07e27001,  0x06427001,  0x06427001, /* 1360 */
  0x07e67001,  0x6800001b,  0x6800001b,  0x6800001b, /* 1364 */
  0x06027001,  0x06027001,  0x060a7001,  0x060a7001, /* 1368 */
  0x07fd7003,  0x6800001b,  0x6800001b,  0x78000000, /* 1372 */
  0x6000400c,  0x6000400c,  0x6000400c,  0x6000400c, /* 1376 */
  0x6000400c,  0x6000400c,  0x6000400c,  0x6000000c, /* 1380 */
  0x6000400c,  0x6000400c,  0x6000400c,  0x48001010, /* 1384 */
  0x48001010,  0x48001010,  0x00001010,  0x08001010, /* 1388 */
  0x68000014,  0x68000014,  0x68000014,  0x68000014, /* 1392 */
  0x68000014,  0x68000014,  0x68000018,  0x68000018, /* 1396 */
  0x6800001d,  0x6800001e,  0x68000015,  0x6800001d, /* 1400 */
  0x6800001d,  0x6800001e,  0x68000015,  0x6800001d, /* 1404 */
  0x6000400d,  0x5000400e,  0x78001010,  0x78001010, /* 1408 */
  0x78001010,  0x78001010,  0x78001010,  0x3800000c, /* 1412 */
  0x28000018,  0x28000018,  0x28000018,  0x28000018, /* 1416 */
  0x28000018,  0x68000018,  0x68000018,  0x68000018, /* 1420 */
  0x68000018,  0xe800001d,  0xe800001e,  0x68000018, /* 1424 */
  0x68000018,  0x68000018,  0x68000018,  0x68002017, /* 1428 */
  0x68002017,  0x68000018,  0x68000018,  0x68000018, /* 1432 */
  0x38000019,  0xe8000015,  0xe8000016,  0x68000018, /* 1436 */
  0x68000018,  0x68000018,  0x68000019,  0x68000018, /* 1440 */
  0x68000018,  0x68000018,  0x68000018,  0x6000400c, /* 1444 */
  0x48001010,  0x48001010,  0x48001010,  0x48001010, /* 1448 */
  0x48001010,  0x78000000,  0x78000000,  0x78000000, /* 1452 */
  0x78000000,  0x78000000,  0x48001010,  0x48001010, /* 1456 */
  0x1800040b,  0x00007002,  0x78000000,  0x78000000, /* 1460 */
  0x1800048b,  0x180004ab,  0x180004cb,  0x180004eb, /* 1464 */
  0x1800050b,  0x1800052b,  0x20000019,  0x20000019, /* 1468 */
  0x68000019,  0xe8000015,  0xe8000016,  0x00007002, /* 1472 */
  0x1800040b,  0x1800042b,  0x1800044b,  0x1800046b, /* 1476 */
  0x68000019,  0xe8000015,  0xe8000016,  0x78000000, /* 1480 */
  0x2800501a,  0x2800501a,  0x78000000,  0x78000000, /* 1484 */
  0x40003006,  0x40000007,  0x40000007,  0x40000007, /* 1488 */
  0x40000007,  0x40003006,  0x40000007,  0x40000007, /* 1492 */
  0x40000007,  0x40003006,  0x40003006,  0x40003006, /* 1496 */
  0x6800001c,  0x6800001c,  0x00007001,  0x6800001c, /* 1500 */
  0x6800001c,  0x6800001c,  0x6800001c,  0x00007001, /* 1504 */
  0x6800001c,  0x6800001c,  0x00007002,  0x00007001, /* 1508 */
  0x00007001,  0x00007001,  0x00007002,  0x00007002, /* 1512 */
  0x6800001c,  0x00007001,  0x00007001,  0x00007001, /* 1516 */
  0x00007001,  0x00007001,  0x6800001c,  0x6800001c, /* 1520 */
  0x00007001,  0x6800001c,  0x07fe7001,  0x6800001c, /* 1524 */
  0x00007001,  0x6800001c,  0x07fe7001,  0x07fe7001, /* 1528 */
  0x00007001,  0x00007001,  0x2800001c,  0x00007002, /* 1532 */
  0x00007001,  0x00007001,  0x00727001,  0x00007001, /* 1536 */
  0x00007002,  0x00007005,  0x00007005,  0x00007005, /* 1540 */
  0x00007005,  0x00007002,  0x6800001c,  0x6800001c, /* 1544 */
  0x00007002,  0x00007002,  0x00007001,  0x00007001, /* 1548 */
  0xe8000019,  0x68000019,  0x68000019,  0x68000019, /* 1552 */
  0x68000019,  0x00007001,  0x00007002,  0x00007002, /* 1556 */
  0x00007002,  0x00007002,  0x6800001c,  0x68000019, /* 1560 */
  0x6800001c,  0x6800001c,  0x00717002,  0x0000001c, /* 1564 */
  0x78000000,  0x78000000,  0x78000000,  0x68000beb, /* 1568 */
  0x68000beb,  0x68000beb,  0x68000beb,  0x68000beb, /* 1572 */
  0x68000beb,  0x68000beb,  0x68000beb,  0x6800082b, /* 1576 */
  0x0042742a,  0x0042744a,  0x0042746a,  0x0042748a, /* 1580 */
  0x004274aa,  0x004274ca,  0x004274ea,  0x0042750a, /* 1584 */
  0x0042752a,  0x0042754a,  0x0042756a,  0x0042758a, /* 1588 */
  0x00427a4a,  0x0042788a,  0x00427a8a,  0x0042790a, /* 1592 */
  0x0041742a,  0x0041744a,  0x0041746a,  0x0041748a, /* 1596 */
  0x004174aa,  0x004174ca,  0x004174ea,  0x0041750a, /* 1600 */
  0x0041752a,  0x0041754a,  0x0041756a,  0x0041758a, /* 1604 */
  0x00417a4a,  0x0041788a,  0x00417a8a,  0x0041790a, /* 1608 */
  0x0000790a,  0x0000790a,  0x00007a0a,  0x00067001, /* 1612 */
  0x00057002,  0x000074ca,  0x00007a4a,  0x00007a0a, /* 1616 */
  0x0000780a,  0x78000000,  0x78000000,  0x78000000, /* 1620 */
  0x68000019,  0x6800001c,  0x6800001c,  0x6800001c, /* 1624 */
  0x6800001c,  0x6800001c,  0x68000019,  0x68000019, /* 1628 */
  0x68000019,  0x6800001c,  0x6800001c,  0x68000019, /* 1632 */
  0x6800001c,  0x6800001c,  0x68000019,  0x6800001c, /* 1636 */
  0x68000019,  0xe8000019,  0xe8000019,  0xe8000019, /* 1640 */
  0xe8000019,  0xe8000019,  0xe8000019,  0xe8000019, /* 1644 */
  0xe8000019,  0xe8000019,  0x68000019,  0x68000019, /* 1648 */
  0x68000019,  0xe8000019,  0x20000019,  0x28000019, /* 1652 */
  0x68000019,  0xe8000019,  0xe8000019,  0x68000019, /* 1656 */
  0x68000019,  0x68000019,  0xe8000019,  0xe8000019, /* 1660 */
  0xe8000019,  0xe8000019,  0x68000019,  0xe8000019, /* 1664 */
  0xe8000019,  0x68000019,  0xe8000019,  0x68000019, /* 1668 */
  0x68000019,  0xe8000019,  0x68000019,  0xe8000019, /* 1672 */
  0xe8000019,  0xe8000019,  0x6800001c,  0x6800001c, /* 1676 */
  0x6800001c,  0xe8000015,  0xe8000016,  0x6800001c, /* 1680 */
  0x6800001c,  0x6800001c,  0x0000001c,  0x0000001c, /* 1684 */
  0x0000001c,  0x0000001c,  0x0000001c,  0x6800001c, /* 1688 */
  0x6800001c,  0x0000001c,  0x6800001c,  0x6800001c, /* 1692 */
  0x6800001c,  0x6800001c,  0x6800001c,  0x78000000, /* 1696 */
  0x6800001c,  0x6800001c,  0x6800001c,  0x78000000, /* 1700 */
  0x6800042b,  0x6800044b,  0x6800046b,  0x6800048b, /* 1704 */
  0x6800052b,  0x6800054b,  0x6800056b,  0x6800058b, /* 1708 */
  0x680005ab,  0x680005cb,  0x680005eb,  0x6800060b, /* 1712 */
  0x6800062b,  0x6800064b,  0x6800066b,  0x6800068b, /* 1716 */
  0x6800062b,  0x6800064b,  0x6800066b,  0x6800068b, /* 1720 */
  0x1800042b,  0x1800044b,  0x1800046b,  0x1800048b, /* 1724 */
  0x1800052b,  0x1800054b,  0x1800056b,  0x1800058b, /* 1728 */
  0x180005ab,  0x180005cb,  0x180005eb,  0x1800060b, /* 1732 */
  0x1800062b,  0x1800064b,  0x1800066b,  0x1800068b, /* 1736 */
  0x0000001c,  0x0000001c,  0x006a001c,  0x006a001c, /* 1740 */
  0x006a001c,  0x006a001c,  0x006a001c,  0x006a001c, /* 1744 */
  0x0069001c,  0x0069001c,  0x0069001c,  0x0069001c, /* 1748 */
  0x0069001c,  0x0069001c,  0x0069001c,  0x0069001c, /* 1752 */
  0x0069001c,  0x0069001c,  0x6800040b,  0x6800056b, /* 1756 */
  0x6800068b,  0x6800042b,  0x6800044b,  0x6800046b, /* 1760 */
  0x6800050b,  0x6800052b,  0x6800054b,  0x6800040b, /* 1764 */
  0x78000000,  0x6800001c,  0x78000000,  0x6800001c, /* 1768 */
  0x78000000,  0x78000000,  0x6800001c,  0x78000000, /* 1772 */
  0xe8000015,  0xe8000016,  0x6800042b,  0x6800044b, /* 1776 */
  0x6800046b,  0x6800048b,  0x680004ab,  0x680004cb, /* 1780 */
  0x680004eb,  0x6800050b,  0x6800052b,  0x6800054b, /* 1784 */
  0x6800052b,  0x6800054b,  0x6800042b,  0x6800044b, /* 1788 */
  0xe8000019,  0xe8000015,  0xe8000016,  0x68000019, /* 1792 */
  0xe8000019,  0xe8000019,  0x68000019,  0x78000000, /* 1796 */
  0xe8000019,  0x78000000,  0x78000000,  0x78000000, /* 1800 */
  0xe8000019,  0xe8000019,  0xe8000015,  0xe8000016, /* 1804 */
  0x68000019,  0x68000019,  0x68000019,  0xe8000015, /* 1808 */
  0xe8000016,  0xe8000015,  0xe8000016,  0xe8000015, /* 1812 */
  0xe8000016,  0xe8000015,  0xe8000016,  0xe8000015, /* 1816 */
  0xe8000016,  0x68000019,  0x68000019,  0xe8000019, /* 1820 */
  0x68000019,  0x78000000,  0x78000000,  0x78000000, /* 1824 */
  0x00c17002,  0x00c17002,  0x00c17002,  0x78000000, /* 1828 */
  0x00067001,  0x00057002,  0x07fe7001,  0x07fe7001, /* 1832 */
  0x07fe7001,  0x07fd7002,  0x07fd7002,  0x00067001, /* 1836 */
  0x78000000,  0x00007002,  0x00067001,  0x00057002, /* 1840 */
  0x00007002,  0x00007004,  0x78000000,  0x78000000, /* 1844 */
  0x00007002,  0x6800001c,  0x6800001c,  0x6800001c, /* 1848 */
  0x68000018,  0x68000beb,  0x68000018,  0x68000018, /* 1852 */
  0x07fd7002,  0x07fd7002,  0x78000000,  0x78000000, /* 1856 */
  0x78000000,  0x78000000,  0x78000000,  0x00007004, /* 1860 */
  0xe800001d,  0xe800001e,  0xe8000015,  0xe8000016, /* 1864 */
  0x68000018,  0x68000018,  0x68000018,  0x68007004, /* 1868 */
  0x6000400c,  0x68000018,  0x68000018,  0x68000018, /* 1872 */
  0x6800001c,  0x00007004,  0x00007005,  0x0000740a, /* 1876 */
  0x68000014,  0x68000015,  0x68000016,  0x68000016, /* 1880 */
  0x6800001c,  0x0000742a,  0x0000744a,  0x0000746a, /* 1884 */
  0x0000748a,  0x000074aa,  0x000074ca,  0x000074ea, /* 1888 */
  0x0000750a,  0x0000752a,  0x40003006,  0x40003006, /* 1892 */
  0x68000014,  0x00007004,  0x00007004,  0x00007004, /* 1896 */
  0x00007004,  0x00007004,  0x6800001c,  0x6800001c, /* 1900 */
  0x0000754a,  0x0000768a,  0x000077ca,  0x00007004, /* 1904 */
  0x00007005,  0x68000018,  0x6800001c,  0x6800001c, /* 1908 */
  0x78000000,  0x40003006,  0x40003006,  0x6800001b, /* 1912 */
  0x6800001b,  0x00007004,  0x00007004,  0x00007005, /* 1916 */
  0x68000014,  0x00007005,  0x00007005,  0x00007005, /* 1920 */
  0x00007005,  0x00007005,  0x00007005,  0x68000018, /* 1924 */
  0x00007004,  0x00007004,  0x00007004,  0x00007005, /* 1928 */
  0x0000001c,  0x0000001c,  0x0000042b,  0x0000044b, /* 1932 */
  0x0000046b,  0x0000048b,  0x0000001c,  0x0000001c, /* 1936 */
  0x0000001c,  0x6800001c,  0x6800001c,  0x78000000, /* 1940 */
  0x0000052b,  0x0000054b,  0x0000001c,  0x0000001c, /* 1944 */
  0x6800001c,  0x680006ab,  0x680006cb,  0x680006eb, /* 1948 */
  0x6800070b,  0x6800072b,  0x6800074b,  0x6800076b, /* 1952 */
  0x6800078b,  0x680007ab,  0x680007cb,  0x680007eb, /* 1956 */
  0x6800080b,  0x6800082b,  0x6800084b,  0x6800086b, /* 1960 */
  0x0000001c,  0x6800088b,  0x680008ab,  0x680008cb, /* 1964 */
  0x680008eb,  0x6800090b,  0x6800092b,  0x6800094b, /* 1968 */
  0x6800096b,  0x6800098b,  0x680009ab,  0x680009cb, /* 1972 */
  0x680009eb,  0x68000a0b,  0x68000a2b,  0x68000a4b, /* 1976 */
  0x0000001c,  0x0000001c,  0x0000001c,  0x78000000, /* 1980 */
  0x00007005,  0x00007004,  0x00007005,  0x00007005, /* 1984 */
  0x00007004,  0x68000018,  0x68000018,  0x68000018, /* 1988 */
  0x78000000,  0x78000000,  0x00067001,  0x00057002, /* 1992 */
  0x00067001,  0x00057002,  0x00007005,  0x40003006, /* 1996 */
  0x40000007,  0x40000007,  0x40000007,  0x68000018, /* 2000 */
  0x40003006,  0x40003006,  0x68000018,  0x68007004, /* 2004 */
  0x6800001b,  0x6800001b,  0x00067001,  0x00057002, /* 2008 */
  0x00007004,  0x00007002,  0x00007002,  0x00007002, /* 2012 */
  0x00057002,  0x07fe7001,  0x00067001,  0x00057002, /* 2016 */
  0x68007004,  0x0000001b,  0x0000001b,  0x00067001, /* 2020 */
  0x00057002,  0x78000000,  0x78000000,  0x78000000, /* 2024 */
  0x00007005,  0x00007005,  0x40003006,  0x00007005, /* 2028 */
  0x00007005,  0x00007005,  0x40003006,  0x00007005, /* 2032 */
  0x40003006,  0x00003008,  0x78000000,  0x78000000, /* 2036 */
  0x00000013,  0x00000013,  0x00000013,  0x00000013, /* 2040 */
  0x00000013,  0x00000013,  0x00000013,  0x00000013, /* 2044 */
  0x00000012,  0x00000012,  0x00000012,  0x00000012, /* 2048 */
  0x00000012,  0x00000012,  0x00000012,  0x00000012, /* 2052 */
  0x00007005,  0x00007005,  0x00007005,  0x00007465, /* 2056 */
  0x00007005,  0x00007005,  0x00007005,  0x00007545, /* 2060 */
  0x00007445,  0x00007005,  0x00007005,  0x00007005, /* 2064 */
  0x00007005,  0x00007005,  0x00007405,  0x00007005, /* 2068 */
  0x00007005,  0x000074c5,  0x00007005,  0x000074c5, /* 2072 */
  0x00007005,  0x00007545,  0x00007005,  0x00007005, /* 2076 */
  0x78000000,  0x78000000,  0x78000000,  0x07fd7002, /* 2080 */
  0x78000000,  0x08007005,  0x40003006,  0x08007005, /* 2084 */
  0x08007005,  0x20000019,  0x08007005,  0x08007005, /* 2088 */
  0x08007005,  0x78000000,  0x08007005,  0x78000000, /* 2092 */
  0x10007005,  0x10007005,  0x78000000,  0x78000000, /* 2096 */
  0x78000000,  0x78000000,  0x78000000,  0x10007005, /* 2100 */
  0x10007005,  0x10007005,  0x68000015,  0x68000016, /* 2104 */
  0x1000501a,  0x6800001c,  0x78000000,  0x78000000, /* 2108 */
  0x68000018,  0x68000018,  0x68000018,  0x68000015, /* 2112 */
  0x68000016,  0x68000018,  0x78000000,  0x78000000, /* 2116 */
  0x68000018,  0x68000014,  0x68000014,  0x68002017, /* 2120 */
  0x68002017,  0x68000015,  0x68000016,  0x68000015, /* 2124 */
  0x68000016,  0x68000015,  0x68000016,  0x68000015, /* 2128 */
  0x68000016,  0x68000018,  0x68000018,  0x68000015, /* 2132 */
  0x68000016,  0x68000018,  0x68000018,  0x68000018, /* 2136 */
  0x68000018,  0x68002017,  0x68002017,  0x68002017, /* 2140 */
  0x38000018,  0x68000018,  0x38000018,  0x78000000, /* 2144 */
  0x68000018,  0x38000018,  0x68000018,  0x68000018, /* 2148 */
  0x68000014,  0xe8000015,  0xe8000016,  0xe8000015, /* 2152 */
  0xe8000016,  0xe8000015,  0xe8000016,  0x28000018, /* 2156 */
  0x68000018,  0x68000018,  0x20000019,  0x20000014, /* 2160 */
  0x68000018,  0x2800501a,  0x28000018,  0x68000018, /* 2164 */
  0x10007005,  0x78000000,  0x10007005,  0x10007005, /* 2168 */
  0x10007005,  0x78000000,  0x78000000,  0x48001010, /* 2172 */
  0x78000000,  0x68000018,  0x68000018,  0x28000018, /* 2176 */
  0x00827ce1,  0x00827d01,  0x00827d21,  0x00827d41, /* 2180 */
  0x00817ce2,  0x00817d02,  0x00817d22,  0x00817d42, /* 2184 */
  0x68000019,  0xe8000016,  0x68000019,  0xe8000015, /* 2188 */
  0xe8000016,  0x68000018,  0xe8000015,  0xe8000016, /* 2192 */
  0x68000018,  0x68000018,  0x00007005,  0x00007005, /* 2196 */
  0x00007004,  0x00007005,  0x00007005,  0x00007005, /* 2200 */
  0x2800501a,  0x2800501a,  0x68000019,  0x6800001b, /* 2204 */
  0x6800001c,  0x2800501a,  0x2800501a,  0x78000000, /* 2208 */
  0x68000019,  0x6800001c,  0x6800001c,  0x78000000, /* 2212 */
  0x78000000,  0x68001010,  0x68001010,  0x68001010, /* 2216 */
  0x00000018,  0x68000018,  0x0000001c,  0x78000000, /* 2220 */
  0x78000000,  0x78000000,  0x78000000,  0x0000042b, /* 2224 */
  0x00000b4b,  0x0000088b,  0x0000090b,  0x0000098b, /* 2228 */
  0x00000a0b,  0x00000a8b,  0x00000b0b,  0x00000b8b, /* 2232 */
  0x0000080b,  0x0000088b,  0x0000090b,  0x00000a0b, /* 2236 */
  0x00000b0b,  0x0000080b,  0x0000090b,  0x00000a0b, /* 2240 */
  0x00000b0b,  0x0000080b,  0x0000090b,  0x00000a0b, /* 2244 */
  0x0000080b,  0x00000a0b,  0x0000080b,  0x00000a0b, /* 2248 */
  0x0000080b,  0x00000a0b,  0x0000080b,  0x00000a0b, /* 2252 */
  0x68007bea,  0x68007bea,  0x6800742a,  0x680074aa, /* 2256 */
  0x68007a4a,  0x68007a8a,  0x6800790a,  0x68007a0a, /* 2260 */
  0x680074aa,  0x6800754a,  0x68007a4a,  0x6800788a, /* 2264 */
  0x68007a8a,  0x6800790a,  0x6800790a,  0x680074aa, /* 2268 */
  0x6800790a,  0x68007a0a,  0x68007a0a,  0x6800754a, /* 2272 */
  0x6800742a,  0x6800742a,  0x6800742a,  0x6800744a, /* 2276 */
  0x6800744a,  0x6800744a,  0x6800744a,  0x680074aa, /* 2280 */
  0x6800754a,  0x6800754a,  0x6800754a,  0x6800754a, /* 2284 */
  0x6800754a,  0x680077ca,  0x68007a4a,  0x68007a4a, /* 2288 */
  0x68007a4a,  0x68007a4a,  0x6800788a,  0x6800798a, /* 2292 */
  0x68007a8a,  0x68007a8a,  0x68007a8a,  0x68007a8a, /* 2296 */
  0x68007a4a,  0x68000beb,  0x68000beb,  0x68000beb, /* 2300 */
  0x68000beb,  0x6800001c,  0x6800001c,  0x6800001c, /* 2304 */
  0x6800001c,  0x6800001c,  0x6800040b,  0x78000000, /* 2308 */
  0x0000001c,  0x40003006,  0x78000000,  0x78000000, /* 2312 */
  0x0000042b,  0x000004ab,  0x0000054b,  0x00000a4b, /* 2316 */
  0x00007005,  0x00007b4a,  0x00007005,  0x00007005, /* 2320 */
  0x00007005,  0x00007005,  0x0000788a,  0x78000000, /* 2324 */
  0x00007005,  0x00007005,  0x78000000,  0x00000018, /* 2328 */
  0x00000018,  0x0000742a,  0x0000744a,  0x0000754a, /* 2332 */
  0x0000768a,  0x0000788a,  0x78000000,  0x78000000, /* 2336 */
  0x00a27001,  0x00a27001,  0x00a27001,  0x00a27001, /* 2340 */
  0x00a27001,  0x00a27001,  0x00a27001,  0x00a27001, /* 2344 */
  0x00a17002,  0x00a17002,  0x00a17002,  0x00a17002, /* 2348 */
  0x00a17002,  0x00a17002,  0x00a17002,  0x00a17002, /* 2352 */
  0x08007005,  0x08007005,  0x78000000,  0x78000000, /* 2356 */
  0x08007005,  0x78000000,  0x78000000,  0x78000000, /* 2360 */
  0x08007005,  0x08007005,  0x0800042b,  0x0800054b, /* 2364 */
  0x0800068b,  0x0800088b,  0x78000000,  0x78000000, /* 2368 */
  0x78000000,  0x78000000,  0x78000000,  0x08000018, /* 2372 */
  0x08007005,  0x40003006,  0x40003006,  0x40003006, /* 2376 */
  0x0800042b,  0x0800044b,  0x0800046b,  0x0800048b, /* 2380 */
  0x0800054b,  0x0800068b,  0x0800088b,  0x0800090b, /* 2384 */
  0x08000018,  0x08000018,  0x08000018,  0x08000018, /* 2388 */
  0x08000018,  0x08000018,  0x08000018,  0x08000018, /* 2392 */
  0x000074ea,  0x0000750a,  0x0000752a,  0x0000748a, /* 2396 */
  0x0000752a,  0x0000742a,  0x0000744a,  0x0000746a, /* 2400 */
  0x0000750a,  0x0000752a,  0x0000742a,  0x0000744a, /* 2404 */
  0x0000746a,  0x0000748a,  0x000074aa,  0x0000744a, /* 2408 */
  0x0000746a,  0x0000746a,  0x0000748a,  0x000074aa, /* 2412 */
  0x0000742a,  0x0000744a,  0x0000746a,  0x0000746a, /* 2416 */
  0x0000748a,  0x000074aa,  0x0000700a,  0x0000700a, /* 2420 */
  0x0000748a,  0x000074aa,  0x0000746a,  0x0000746a, /* 2424 */
  0x0000748a,  0x0000748a,  0x0000748a,  0x0000748a, /* 2428 */
  0x000074ca,  0x000074ea,  0x000074ea,  0x000074ea, /* 2432 */
  0x0000750a,  0x0000750a,  0x0000752a,  0x0000752a, /* 2436 */
  0x0000752a,  0x0000752a,  0x0000744a,  0x0000746a, /* 2440 */
  0x0000748a,  0x000074aa,  0x000074ca,  0x0000742a, /* 2444 */
  0x0000744a,  0x0000746a,  0x0000748a,  0x0000748a, /* 2448 */
  0x000074aa,  0x000074aa,  0x0000700a,  0x0000700a, /* 2452 */
  0x0000742a,  0x0000744a,  0x00007bea,  0x00007bea, /* 2456 */
  0x00007bea,  0x00007bea,  0x00007bea,  0x00007bea, /* 2460 */
  0x00007bea,  0x00007bea,  0x00007bea,  0x78000000, /* 2464 */
  0x0000001c,  0x0000001c,  0x78000000,  0x78000000, /* 2468 */
  0x0000001c,  0x00003008,  0x00003008,  0x40003006, /* 2472 */
  0x0000001c,  0x00003008,  0x00003008,  0x00003008, /* 2476 */
  0x00003008,  0x00003008,  0x00003008,  0x48001010, /* 2480 */
  0x48001010,  0x48001010,  0x48001010,  0x40003006, /* 2484 */
  0x40003006,  0x40003006,  0x40003006,  0x0000001c, /* 2488 */
  0x0000001c,  0x40003006,  0x40003006,  0x40003006, /* 2492 */
  0x40003006,  0x6800001c,  0x78000000,  0x78000000, /* 2496 */
  0x00000a0b,  0x00000b4b,  0x78000000,  0x78000000, /* 2500 */
  0x00007002,  0x78000000,  0x00007002,  0x00007002, /* 2504 */
  0x00007001,  0x78000000,  0x00007001,  0x00007001, /* 2508 */
  0x78000000,  0x78000000,  0x00007001,  0x78000000, /* 2512 */
  0x78000000,  0x00007001,  0x00007001,  0x00007001, /* 2516 */
  0x00007002,  0x00007002,  0x78000000,  0x00007002, /* 2520 */
  0x78000000,  0x00007002,  0x00007002,  0x00007002, /* 2524 */
  0x78000000,  0x00007002,  0x00007002,  0x00007002, /* 2528 */
  0x00007001,  0x00007001,  0x78000000,  0x00007001, /* 2532 */
  0x00007001,  0x00007001,  0x00007001,  0x78000000, /* 2536 */
  0x00007001,  0x78000000,  0x00007002,  0x00007002, /* 2540 */
  0x00007001,  0x78000000,  0x00007002,  0x00007002, /* 2544 */
  0x00007002,  0x00007002,  0x78000000,  0x78000000, /* 2548 */
  0x00007001,  0x00000019,  0x00007002,  0x00007002, /* 2552 */
  0x00007002,  0x00007002,  0x00007002,  0x80000019, /* 2556 */
  0x00007001,  0x00007001,  0x00007001,  0x00000019, /* 2560 */
  0x00007002,  0x80000019,  0x00007002,  0x00007002, /* 2564 */
  0x00007002,  0x80000019,  0x00007002,  0x00007002, /* 2568 */
  0x00007002,  0x00007002,  0x00007001,  0x00007002, /* 2572 */
  0x78000000,  0x78000000,  0x18003409,  0x18003429, /* 2576 */
  0x18003509,  0x18003529,  0x18003409,  0x18003429, /* 2580 */
  0x18003509,  0x18003529,  0x18003409,  0x18003429, /* 2584 */
  0x00007525,  0x00007005,  0x00007005,  0x00007005, /* 2588 */
  0x78000000,  0x48001010,  0x78000000,  0x78000000, /* 2592 */
  0x00000012,  0x00000012,  0x78000000,  0x78000000, /* 2596 */
  0x00000012,  0x00000012,
};

#define UNI_CODE(ch) (prop[block[plane[(ch>>8)&8191]+((ch>>2)&63)]+(ch&3)])

/**
 * Get type part of code

 */
#define UNI_CODE_TO_TYPE(ch) (ch & 0x1f)

/**
 * Fetch the category type

 */
#define UNI_TYPE(ch) (UNI_CODE_TO_TYPE(UNI_CODE(ch)))

/**
 * Fetch the digit offset
 */
#define UNI_DIGIT_OFFSET(ch) ((UNI_CODE(ch)>>5) & 0x1f)

/**
 * Fetch the numeric property
 */
#define UNI_NUM_PROP(ch) ((UNI_CODE(ch)>>10) & 0x3)

/**
 * Fetch the lexical property
 */
#define UNI_LEX_PROP(ch) ((UNI_CODE(ch)>>12) & 0x7)

/**
 * Fetch the case mapping offset
 */
#define UNI_CASE_OFFSET(ch) ((UNI_CODE(ch)>>18) & 0x1ff)


/**
 * Special case mappings, not covered by UnicodeData.txt
 */
typedef struct
{
    int sourceChar;
    int nrMaps;
    int map[3];
} CaseMapEntry;

static CaseMapEntry caseMap[] =
{
    { 0x1fc2, 2, { 0xffff, 0x0159 } },
    { 0x1fc3, 1, { 0xffff } },
    { 0x1fc6, 2, { 0x018d, 0x0156 } },
    { 0x1fc7, 3, { 0x018d, 0x0156, 0x0159 } },
    { 0x1fc4, 2, { 0x0185, 0x0159 } },
    { 0x1fcc, 1, { 0xffff } },
    { 0x1fd3, 3, { 0x018f, 0x0134, 0x012d } },
    { 0x1fd2, 3, { 0x018f, 0x0134, 0x012c } },
    { 0x1fd7, 3, { 0x018f, 0x0134, 0x0156 } },
    { 0x1fd6, 2, { 0x018f, 0x0156 } },
    { 0x0130, 1, { 0x0082 } },
    { 0x1fe2, 3, { 0xffff, 0x0134, 0x012c } },
    { 0x1fe3, 3, { 0xffff, 0x0134, 0x012d } },
    { 0x1fe4, 2, { 0xffff, 0x0139 } },
    { 0x1fe6, 2, { 0xffff, 0x0156 } },
    { 0x1fe7, 3, { 0xffff, 0x0134, 0x0156 } },
    { 0x0307, 1, { 0x0133 } },
    { 0x1ff3, 1, { 0xffff } },
    { 0x1ff2, 2, { 0xffff, 0x0159 } },
    { 0x1ff4, 2, { 0xffff, 0x0159 } },
    { 0x1ff7, 3, { 0xffff, 0x0156, 0x0159 } },
    { 0x1ff6, 2, { 0xffff, 0x0156 } },
    { 0x0128, 1, { 0x0080 } },
    { 0x1ffc, 1, { 0xffff } },
    { 0x012e, 1, { 0xffff } },
    { 0x1f86, 1, { 0xffff } },
    { 0x1f87, 1, { 0xffff } },
    { 0x1f84, 1, { 0xffff } },
    { 0x1e97, 2, { 0x0036, 0x0134 } },
    { 0x1f85, 1, { 0xffff } },
    { 0x1e96, 2, { 0x0030, 0x014b } },
    { 0x1f82, 1, { 0xffff } },
    { 0x1f83, 1, { 0xffff } },
    { 0x1f80, 1, { 0xffff } },
    { 0x1f81, 1, { 0xffff } },
    { 0xfb01, 2, { 0x002e, 0x0045 } },
    { 0x1f8e, 1, { 0xffff } },
    { 0xfb00, 2, { 0x002e, 0x0042 } },
    { 0x1f8f, 1, { 0xffff } },
    { 0xfb03, 3, { 0x002e, 0x0042, 0x0045 } },
    { 0x1f8c, 1, { 0xffff } },
    { 0xfb02, 2, { 0x002e, 0xffff } },
    { 0x1f8d, 1, { 0xffff } },
    { 0xfb05, 2, { 0x0035, 0x004a } },
    { 0x1e99, 2, { 0x003b, 0xffff } },
    { 0x1f8a, 1, { 0xffff } },
    { 0x0049, 1, { 0x0031 } },
    { 0xfb04, 3, { 0x002e, 0x0042, 0xffff } },
    { 0x1e98, 2, { 0x0039, 0xffff } },
    { 0x1f8b, 1, { 0xffff } },
    { 0x004a, 1, { 0xffff } },
    { 0x1f88, 1, { 0xffff } },
    { 0xfb06, 2, { 0x0035, 0x004a } },
    { 0x1e9a, 2, { 0x0029, 0xffff } },
    { 0x1f89, 1, { 0xffff } },
    { 0x1f97, 1, { 0xffff } },
    { 0x1f96, 1, { 0xffff } },
    { 0x1f95, 1, { 0xffff } },
    { 0x1f94, 1, { 0xffff } },
    { 0x1f93, 1, { 0xffff } },
    { 0x1f92, 1, { 0xffff } },
    { 0x1f91, 1, { 0xffff } },
    { 0x1f90, 1, { 0xffff } },
    { 0x1f9f, 1, { 0xffff } },
    { 0x1f9e, 1, { 0xffff } },
    { 0x1f9d, 1, { 0xffff } },
    { 0xfb13, 2, { 0x0220, 0x0240 } },
    { 0x1f9c, 1, { 0xffff } },
    { 0xfb14, 2, { 0x0220, 0x0235 } },
    { 0x1f9b, 1, { 0xffff } },
    { 0xfb15, 2, { 0x0220, 0xffff } },
    { 0x1f9a, 1, { 0xffff } },
    { 0xfb16, 2, { 0xffff, 0x0240 } },
    { 0x1f99, 1, { 0xffff } },
    { 0xfb17, 2, { 0x0220, 0xffff } },
    { 0x0149, 2, { 0xffff, 0xffff } },
    { 0x1f98, 1, { 0xffff } },
    { 0x1fa4, 1, { 0xffff } },
    { 0x1fa5, 1, { 0xffff } },
    { 0x1fa6, 1, { 0xffff } },
    { 0x1fa7, 1, { 0xffff } },
    { 0x1fa0, 1, { 0xffff } },
    { 0x1fa1, 1, { 0xffff } },
    { 0x1fa2, 1, { 0xffff } },
    { 0x1fa3, 1, { 0xffff } },
    { 0x1fac, 1, { 0xffff } },
    { 0x1fad, 1, { 0xffff } },
    { 0x1fae, 1, { 0xffff } },
    { 0x1faf, 1, { 0xffff } },
    { 0x1fa8, 1, { 0xffff } },
    { 0x1fa9, 1, { 0xffff } },
    { 0x1faa, 1, { 0xffff } },
    { 0x0069, 1, { 0x0082 } },
    { 0x1fab, 1, { 0xffff } },
    { 0x1fb4, 2, { 0x0182, 0x0159 } },
    { 0x1fb7, 3, { 0x0187, 0x0156, 0x0159 } },
    { 0x1fb6, 2, { 0x0187, 0x0156 } },
    { 0x1fb3, 1, { 0xffff } },
    { 0x1fb2, 2, { 0xffff, 0x0159 } },
    { 0x1fbc, 1, { 0xffff } },
    { 0x03b0, 3, { 0xffff, 0x0134, 0x012d } },
    { 0x1f52, 3, { 0xffff, 0x0139, 0x012c } },
    { 0x1f50, 2, { 0xffff, 0x0139 } },
    { 0x1f56, 3, { 0xffff, 0x0139, 0x0156 } },
    { 0x03a3, 1, { 0xffff } },
    { 0x1f54, 3, { 0xffff, 0x0139, 0x012d } },
    { 0x0390, 3, { 0x018f, 0x0134, 0x012d } },
    { 0x00cd, 1, { 0xffff } },
    { 0x00cc, 1, { 0xffff } },
    { 0x00df, 2, { 0x0035, 0x0049 } },
    { 0x0587, 2, { 0x0217, 0x0246 } },
    { 0x01f0, 2, { 0xffff, 0xffff } },
    { 0,  0,  {} }
};






unsigned int uni_code(int ch)
{
    return UNI_CODE(ch);
}

unsigned int uni_type(int ch)
{
    return UNI_TYPE(ch);
}

int uni_is_lower(int ch)
{
    return (UNI_TYPE(ch) == UNI_LOWERCASE_LETTER);
}

int uni_is_upper(int ch)
{
    return (UNI_TYPE(ch) == UNI_UPPERCASE_LETTER);
}

int uni_is_title(int ch)
{
    return (UNI_TYPE(ch) == UNI_TITLECASE_LETTER);
}

int uni_is_digit(int ch)
{
    return (UNI_TYPE(ch) == UNI_DECIMAL_DIGIT_NUMBER);
}

int uni_is_defined(int ch)
{
    return (UNI_TYPE(ch) != UNI_UNASSIGNED);
}

int uni_is_letter(int ch)
{
    int c = UNI_TYPE(ch);
    return (c>=UNI_UPPERCASE_LETTER && c<=UNI_OTHER_LETTER);
}

int uni_is_letter_or_digit(int ch)
{
    int c = UNI_TYPE(ch);
    return ((c>=UNI_UPPERCASE_LETTER && c<=UNI_OTHER_LETTER)
              || c==UNI_DECIMAL_DIGIT_NUMBER);
}

int uni_is_space(int ch)
{
    int c = UNI_TYPE(ch);
    return (c==UNI_SPACE_SEPARATOR || c==UNI_LINE_SEPARATOR
              || c==UNI_PARAGRAPH_SEPARATOR || (ch>= 0x09 && ch <= 0x0d));
}

int uni_to_lower(int ch)
{
    int c = UNI_CODE(ch);
    if (UNI_CODE_TO_TYPE(c) == UNI_LOWERCASE_LETTER)
        return ch;
    ch -= (c>>18) & 0x1ff;
    return ch;
}

int uni_to_upper(int ch)
{
    int c = UNI_CODE(ch);
    if (UNI_CODE_TO_TYPE(c) == UNI_UPPERCASE_LETTER)
        return ch;
    ch += (c>>18) & 0x1ff;
    return ch;
}

int uni_to_title(int ch)
{
    int c = UNI_CODE(ch);
    if (UNI_CODE_TO_TYPE(c) == UNI_TITLECASE_LETTER)
        return ch;
    ch += (c>>18) & 0x1ff;
    return ch;
}

int uni_block(int ch)
{
    int ret;
    UcdBlockData *entry;
    for (entry = ucd_blocks, ret=0 ; entry->name ; entry++, ret++)
        if (ch >= entry->low && ch <= entry->high)
            return ret;
    return UCD_BLOCK_NO_BLOCK;
}

UcdBlockData *uni_block_data(int blockNr)
{
    if (blockNr >= 0 && blockNr < UCD_BLOCK_NO_BLOCK)
        return &(ucd_blocks[blockNr]);
    else
        return (UcdBlockData *)0;
}





