#ifndef _NFNETLINK_CONNTRACK_H
#define _NFNETLINK_CONNTRACK_H
#include <linux/netfilter/nfnetlink.h>
#include <linux/netfilter_ipv4/ip_conntrack.h>

/* CTNETLINK for ip_conntrack */

/* TODO: Add more message types:
 *
 * 	o IPCTNL_MSG_UPDCONNTRACK, update conntracks
 */
enum cntl_msg_types {
	IPCTNL_MSG_CT_NEW,
	IPCTNL_MSG_CT_GET,
	IPCTNL_MSG_CT_DELETE,
	IPCTNL_MSG_CT_GET_CTRZERO,
	IPCTNL_MSG_CT_FLUSH,

	IPCTNL_MSG_EXP_NEW,
	IPCTNL_MSG_EXP_GET,
	IPCTNL_MSG_EXP_DELETE,

	IPCTNL_MSG_CONFIG,
	IPCTNL_MSG_COUNT,
};

enum ctnl_dump_mask {
	DUMP_TUPLE_BIT = 0,
	DUMP_TUPLE = (1 << DUMP_TUPLE_BIT),

	DUMP_STATUS_BIT = 1,
	DUMP_STATUS = (1 << DUMP_STATUS_BIT),

	DUMP_TIMEOUT_BIT = 2,
	DUMP_TIMEOUT = (1 << DUMP_TIMEOUT_BIT),

	DUMP_PROTOINFO_BIT = 3,
	DUMP_PROTOINFO = (1 << DUMP_PROTOINFO_BIT),

	DUMP_HELPINFO_BIT = 4,
	DUMP_HELPINFO = (1 << DUMP_HELPINFO_BIT),

	DUMP_COUNTERS_BIT = 5,
	DUMP_COUNTERS = (1 << DUMP_COUNTERS_BIT),

	DUMP_MARK_BIT = 6,
	DUMP_MARK = (1 << DUMP_MARK_BIT),
};

/* ctnetlink attribute types.
 */

enum ctattr_type_t
{
	CTA_UNSPEC,     /* [none] I don't know (unspecified). */
	CTA_ORIG,       /* [ip_conntrack_tuple] Original tuple. */
	CTA_RPLY,       /* [ip_conntrack_tuple] Reply tuple. */
	CTA_STATUS,     /* [unsigned long] Status of connection. */
	CTA_PROTOINFO,  /* [cta_proto] Protocol specific ct information. */
	CTA_HELPINFO,   /* [cta_help] Helper specific information. */
	CTA_TIMEOUT,    /* [unsigned long] timer */
	CTA_MARK,       /* [unsigned long] mark .*/
	CTA_COUNTERS,	/* [cta_counters] packet/byte counters */
	CTA_DUMPMASK,	/* [unsigned int] mask for table dumping */
	CTA_EVENTMASK,	/* [unsigned int] mask for event notification */
	
	CTA_EXP_TUPLE,	/* [ip_conntrack_tuple] Expected tuple */
	CTA_EXP_MASK,	/* [ip_conntrack_tuple] Mask for EXP_TUPLE */
	CTA_EXP_SEQNO,	/* [u_int32_t] sequence number */
	CTA_EXP_PROTO,	/* [cta_exp_proto] */
	CTA_EXP_TIMEOUT,/* [unsigned long] timer */

	CTA_MAX = CTA_EXP_TIMEOUT
};

/* Attribute specific data structures.
 */

struct cta_proto {
	unsigned char num_proto;	/* Protocol number IPPROTO_X */
	union ip_conntrack_proto proto;
};

#define CTA_HELP_MAXNAMESZ	31

struct cta_help {
	char name[CTA_HELP_MAXNAMESZ];	/* name of conntrack helper */
	union ip_conntrack_help help;
};

struct cta_exp_proto {
	union ip_conntrack_expect_proto proto;
};

struct cta_counters {
	struct ip_conntrack_counter orig;
	struct ip_conntrack_counter reply;
};

/* ctnetlink multicast groups: reports any change of ctinfo,
 * ctstatus, or protocol state change.
 */
#define NFGRP_IPV4_CT_TCP	0x01
#define NFGRP_IPV4_CT_UDP	0x02
#define NFGRP_IPV4_CT_ICMP	0x04
#define NFGRP_IPV4_CT_OTHER 	0x08

#define NFGRP_IPV6_CT_TCP       0x10
#define NFGRP_IPV6_CT_UDP       0x20
#define NFGRP_IPV6_CT_ICMP      0x40
#define NFGRP_IPV6_CT_OTHER 	0x80

#endif /* _NFNETLINK_CONNTRACK_H */
