#ifndef _IPT_POLICY_H
#define _IPT_POLICY_H

#define POLICY_MAX_ELEM	4

enum ipt_policy_flags
{
	POLICY_MATCH_IN		= 0x1,
	POLICY_MATCH_OUT	= 0x2,
	POLICY_MATCH_NONE	= 0x4,
	POLICY_MATCH_STRICT	= 0x8,
};

enum ipt_policy_modes
{
	POLICY_MODE_TRANSPORT,
	POLICY_MODE_TUNNEL
};

struct ipt_policy_spec
{
	u_int8_t	saddr:1,
			daddr:1,
			proto:1,
			mode:1,
			spi:1,
			reqid:1;
};

struct ipt_policy_elem
{
	u_int32_t	saddr;
	u_int32_t	smask;
	u_int32_t	daddr;
	u_int32_t	dmask;
	u_int32_t	spi;
	u_int32_t	reqid;
	u_int8_t	proto;
	u_int8_t	mode;

	struct ipt_policy_spec	match;
	struct ipt_policy_spec	invert;
};

struct ipt_policy_info
{
	struct ipt_policy_elem pol[POLICY_MAX_ELEM];
	u_int16_t flags;
	u_int16_t len;
};

#endif /* _IPT_POLICY_H */
