#!/usr/bin/env python

# (c) 2007 Canonical Ltd.
# Author: Martin Pitt <martin.pitt@ubuntu.com>

# This script needs python-distutils-extra, an extension to the standard
# distutils which provides i18n, icon support, etc.
# https://launchpad.net/python-distutils-extra

from glob import glob
import subprocess
import os
import os.path
import shutil
from distutils.core import setup
from DistUtilsExtra.command import *

class mybuild(build_extra.build_extra):
    description = 'convert KDE .ui files into .py files'

    def run(self):
        dir = os.path.join('jockey', 'kdeui')
        try:
            os.mkdir(dir)
            open(os.path.join(dir, '__init__.py'), 'w').close()
        except OSError:
            pass # already exists
        for ui in glob('kde/*.ui'):
            destination = os.path.join(dir, 'ui_' +
                ui.replace('kde/', '').replace('.ui', '.py'))
            result = subprocess.call(['python', '/usr/bin/pykdeuic4', '-o', destination, ui])
            if result != 0:
                raise SystemError('the KDE .ui file %s can not be converted/updated' % (ui))
        build_extra.build_extra.run(self)

class myclean(clean_i18n.clean_i18n):
    description = '''clean up kde/jockey_kdeui/ and i18n files'''

    def run(self):
        shutil.rmtree(os.path.join('jockey', 'kdeui'), ignore_errors=True)
        clean_i18n.clean_i18n.run(self)

setup(
    name='jockey',
    version='0.5',

    description='UI for managing third-party and non-free drivers',
    url='https://launchpad.net/jockey',
    license='GPL v2 or later',
    author='Martin Pitt',
    author_email='martin.pitt@ubuntu.com',

    packages=['jockey', 'jockey/kdeui'],

    data_files = [
        ('share/jockey', glob('gtk/*.glade')),
        ('share/jockey', ['backend/jockey-backend']),
        ('/etc/dbus-1/system.d/', glob('backend/*.conf')),
        ('share/dbus-1/system-services', glob('backend/*.service')),
        ('share/dbus-1/services', glob('gtk/*.service')),
        ('share/jockey/modaliases', glob('data/modalias-overrides/*')),
        ('share/jockey/handlers', glob('data/handlers/*')),
        ],

    scripts = ['gtk/jockey-gtk', 'kde/jockey-kde'],

    cmdclass = { 'build': mybuild,
                 'build_i18n': build_i18n.build_i18n,
                 'build_icons': build_icons.build_icons,
                 'clean': myclean,
               }
)
