/***************************************************************************
                          channeleditor.h  -  description
                             -------------------
    begin                : Mon Mar 22 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/03/31 09:09:32 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHANNELEDITOR_H
#define CHANNELEDITOR_H

#include <qstringlist.h>

#include "channeleditorui.h"
#include "channeldesc.h"



class ChannelEditor : public ChannelEditorUI
{
	Q_OBJECT

public:

	ChannelEditor( QStringList src, bool m, ChannelDesc *chan, QPtrList<ChannelDesc> *cdesc, QWidget *parent );
	~ChannelEditor();

protected:

	virtual void accept();

private slots:

	void editAudio();
	void editSubtitle();

private:

	void initS();
	void initC();
	void initT();
	QStringList inversionList();
	QStringList coderateList();
	QStringList modulationList();
	QStringList transmissionList();
	QStringList bandwidthList();
	QStringList hierarchyList();
	QStringList guardList();

	ChannelDesc *channel;
	QPtrList<ChannelDesc> *chandesc;
	bool mode;
	QString orgName;
	int chanNum;

};
#endif
