/***************************************************************************
 *   Copyright (C) 2004-2005 by Jürgen Kofler                                   *
 *   kaffeine@gmx.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 /*
  * Last modified: $Date: 2005/04/29 20:45:50 $ by $Author: hftom $
  */

#include "pref.h"
#include "pref.moc"

#include <kglobal.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <klocale.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlineedit.h>

#include <qtextcodec.h>

KaffeinePreferences::KaffeinePreferences()
    : KDialogBase(IconList,i18n("Kaffeine Setup"),
                  Ok|Apply|Cancel, Ok)
{
    QGroupBox *gb;
    QVBoxLayout *vb;
    QGridLayout *grid;
    KIconLoader *icon = new KIconLoader();

    setInitialSize(QSize(400,400), false);

//-----------behavior----------------
    QFrame *behavior = addPage(i18n("Behavior"), i18n("Behavior"),
           KGlobal::iconLoader()->loadIcon("kaffeine", KIcon::Panel, KIcon::SizeMedium));
    vb = new QVBoxLayout( behavior, 6, 6 );
    gb = new QGroupBox( "", behavior );
    grid = new QGridLayout( gb, 1, 1, 20, 6 );
    m_pauseVideo = new QCheckBox(i18n("Pause video when hidden"), gb);
    grid->addMultiCellWidget(m_pauseVideo, 0, 0, 0, 1);
    vb->addWidget( gb );

    gb = new QGroupBox( "", behavior );
    grid = new QGridLayout( gb, 1, 1, 20, 6 );
    m_timeout = new QSpinBox(gb);
    m_timeout->setMinValue(0);
    m_timeout->setMaxValue(10);
    m_timeout->setSuffix(i18n(" min"));
    m_timeout->setSpecialValueText(i18n("off"));
    grid->addWidget(m_timeout, 0,0);
    QLabel* timeoutLabel = new QLabel(i18n("Interval to fake keypresses\n(prevent screensaver from activating)"), gb);
    grid->addWidget(timeoutLabel, 0,1);
    vb->addWidget( gb );

    vb->addItem( new QSpacerItem( 20, 20, QSizePolicy::Ignored, QSizePolicy::Ignored ) );
#ifndef HAVE_XTEST
    m_timeout->setEnabled(false);
    timeoutLabel->setEnabled(false);
#endif

//-----------appearance--------------
    QFrame *looknfeel = addPage(i18n("Appearance"), i18n("Appearance"),
           KGlobal::iconLoader()->loadIcon("looknfeel", KIcon::Panel, KIcon::SizeMedium));
    vb = new QVBoxLayout( looknfeel, 6, 6 );
    gb = new QGroupBox( "", looknfeel );
    grid = new QGridLayout( gb, 1, 1, 20, 6 );
    m_showGoTab = new QCheckBox(i18n("Create Go!-Tab"), gb);
    grid->addMultiCellWidget(m_showGoTab, 0, 0, 0, 1);
    vb->addWidget( gb );

    gb = new QGroupBox( "", looknfeel );
    grid = new QGridLayout( gb, 1, 1, 20, 6 );
    m_systemTray = new QCheckBox(i18n("Embed in system tray"), gb);
    connect(m_systemTray, SIGNAL(toggled(bool)), this, SLOT(slotEmbedInTrayToggled(bool)));
    grid->addMultiCellWidget(m_systemTray, 0, 0, 0, 1);
    m_osdTimeout = new QSpinBox(gb);
    m_osdTimeout->setMinValue(0);
    m_osdTimeout->setMaxValue(60);
    m_osdTimeout->setSuffix(i18n(" sec"));
    m_osdTimeout->setSpecialValueText(i18n("off"));
    grid->addWidget(m_osdTimeout, 1,0);
    QLabel* osdTimeoutLabel = new QLabel(i18n("Duration of title announcement in system tray"), gb);
    grid->addWidget(osdTimeoutLabel, 1,1);
    vb->addWidget( gb );

    vb->addItem( new QSpacerItem( 20, 20, QSizePolicy::Ignored, QSizePolicy::Ignored ) );

//-----------dvbclient--------------
    QFrame *dc = addPage(i18n("DVB client"), i18n("DVB client"),
           KGlobal::iconLoader()->loadIcon("network_local", KIcon::Panel, KIcon::SizeMedium));
    vb = new QVBoxLayout( dc, 6, 6 );
    m_dcEnabled = new QCheckBox(i18n("Enable DVB client"), dc);
    vb->addWidget( m_dcEnabled );
    gb = new QGroupBox( "", dc );
    grid = new QGridLayout( gb, 1, 1, 20, 6 );
    QLabel *lab = new QLabel( i18n("Broadcast address :"), gb );
    grid->addWidget( lab, 0, 0 );
    m_dcAddress = new QLineEdit( gb );
    grid->addWidget( m_dcAddress, 0, 1 );
    lab = new QLabel( i18n("Broadcast port :"), gb );
    grid->addWidget( lab, 1, 0 );
    m_dcPort = new QSpinBox( 1, 65535, 1, gb );
    grid->addWidget( m_dcPort, 1, 1 );
    lab = new QLabel( i18n("Info port :"), gb );
    grid->addWidget( lab, 2, 0 );
    m_dcInfo = new QSpinBox( 1, 65535, 1, gb );
    grid->addWidget( m_dcInfo, 2, 1 );

    lab = new QLabel( i18n("Time shifting directory :"), gb );
    grid->addWidget( lab, 3, 0 );
    m_shiftDirLe = new QLineEdit( gb );
    m_shiftDirLe->setReadOnly( true );
    grid->addWidget( m_shiftDirLe, 3, 1 );
    m_shiftDirBtn = new QToolButton( gb );
    m_shiftDirBtn->setIconSet( icon->loadIconSet("fileopen", KIcon::Small) );
    grid->addWidget( m_shiftDirBtn, 3, 2 );
    connect( m_shiftDirBtn, SIGNAL(clicked()), this, SLOT(setShiftDir()) );

    vb->addWidget( gb );
    vb->addItem( new QSpacerItem( 20, 20, QSizePolicy::Ignored, QSizePolicy::Ignored ) );

//-----------misc----------------
    QFrame *misc = addPage(i18n("Misc"), i18n("Miscellaneous options"),
           KGlobal::iconLoader()->loadIcon("misc", KIcon::Panel, KIcon::SizeMedium));
    vb = new QVBoxLayout( misc, 6, 6 );
    gb = new QGroupBox( "", misc );
    grid = new QGridLayout( gb, 1, 1, 20, 6 );
    m_useAlternateEncoding = new QCheckBox(i18n("Use alternate (non-Unicode) encoding for Meta tags"), gb);
    connect(m_useAlternateEncoding, SIGNAL(toggled(bool)), this, SLOT(slotUseAlternateEncodingToggled(bool)));
    grid->addMultiCellWidget(m_useAlternateEncoding, 0, 0, 0, 1);
    m_alternateEncoding = new QComboBox(gb);

//*** addind Western, European & Middle-Eastern Codecs to the combo box ***//
    QTextCodec *codec;
    QString codecName;
    QStringList codecNames;
    for (int i = 0; (codec = QTextCodec::codecForIndex(i)); i++) {
       codecName = codec->name();
       if ((codecName.left(2) == "CP") || (codecName.left(4) == "ISO ") || (codecName.left(3) == "IBM") || (codecName.left(3) == "KOI"))
       {
          codecNames.append(codecName);
       }
    }
    codecNames.sort();
    m_alternateEncoding->insertStringList(codecNames);
    grid->addWidget(m_alternateEncoding, 1, 0);

    QLabel* encodingLabel = new QLabel(i18n("Choose alternate encoding name for Meta tags\n(in order to convert to Unicode)"), gb);
    grid->addWidget(encodingLabel, 1, 1);
    vb->addWidget( gb );

    gb = new QGroupBox( "", misc );
    grid = new QGridLayout( gb, 1, 1, 20, 6 );
    KPushButton* clearRecent = new KPushButton( i18n("Clear"), gb);
    clearRecent->setSizePolicy( QSizePolicy (QSizePolicy::Minimum, QSizePolicy::Fixed));
    connect(clearRecent, SIGNAL(clicked()), this, SIGNAL(signalClearRecent()));
    grid->addWidget(clearRecent, 0, 0);
    QLabel* clearLabel = new QLabel(i18n("Clear recent files list"), gb);
    grid->addWidget(clearLabel, 0, 1);
    vb->addWidget( gb );

    vb->addItem( new QSpacerItem( 20, 20, QSizePolicy::Ignored, QSizePolicy::Ignored ) );

    delete icon;

    connect(this, SIGNAL(okClicked()), SLOT(slotOkPressed()));
    connect(this, SIGNAL(applyClicked()), SLOT(slotApplyPressed()));
}

void KaffeinePreferences::setConfig(bool pauseVideo, int timeout, bool tray, uint duration, bool showGoTab, bool useEncoding, const QString& encoding)
{
  m_timeout->setValue(timeout);
  m_osdTimeout->setValue(duration);
  m_osdTimeout->setEnabled(tray);
  m_systemTray->setChecked(tray);
  m_showGoTab->setChecked(showGoTab);
  m_useAlternateEncoding->setChecked(useEncoding);
  m_alternateEncoding->setEnabled(useEncoding);
  m_alternateEncoding->setCurrentText(encoding);
  m_pauseVideo->setChecked(pauseVideo);
}

void KaffeinePreferences::setDvbClient( bool enabled, const QString &address, int port, int info, const QString &tspath )
{
  m_dcEnabled->setChecked(enabled);
  m_dcAddress->setText(address);
  m_dcPort->setValue(port);
  m_dcInfo->setValue(info);
  m_shiftDirLe->setText(tspath);
}

void KaffeinePreferences::slotApplyPressed()
{
  emit signalTimeoutInterval(m_timeout->value());
  emit signalEmbedSystemTray(m_systemTray->isChecked());
  emit signalUseAlternateEncoding(m_useAlternateEncoding->isChecked());
  emit signalAlternateEncoding(m_alternateEncoding->currentText());
  emit signalShowGoTab(m_showGoTab->isChecked());
  emit signalSetOSDTimeout(m_osdTimeout->value());
  emit signalPauseVideo(m_pauseVideo->isChecked());
  emit signalDvbClient(m_dcEnabled->isChecked(), m_dcAddress->text().stripWhiteSpace(), m_dcPort->value(), m_dcInfo->value(), m_shiftDirLe->text() );
}

void KaffeinePreferences::slotOkPressed()
{
  slotApplyPressed();
  hide();
}

void KaffeinePreferences::setShiftDir()
{
  QString s = KFileDialog::getExistingDirectory( m_shiftDirLe->text().stripWhiteSpace() );
  if ( s!="" ) m_shiftDirLe->setText( s );
}

void KaffeinePreferences::slotUseAlternateEncodingToggled(bool on)
{
  m_alternateEncoding->setEnabled(on);
}

void KaffeinePreferences::slotEmbedInTrayToggled(bool on)
{
  m_osdTimeout->setEnabled(on);
}


