/*
 * dvbevents.h
 *
 * Copyright (C) 2003-2007 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef DVBEVENTS_H
#define DVBEVENTS_H

#include <sys/poll.h>

#include <qtimer.h>
#include <qmutex.h>

#include "dvbsection.h"
#include "channeldesc.h"



class EventSid
{
public:
	EventSid( int s );
	~EventSid();
	int getSid() { return sid; }
	void lock() { mutex.lock(); }
	void unlock() { mutex.unlock(); }
	QPtrList<EventDesc> *getEvents() { return &events; }
	EventDesc *getEventDesc( int n );
	int getNDesc() { return events.count(); }
	void remove( EventDesc *d );
private:
	QMutex mutex;
	int sid;
	QPtrList<EventDesc> events;
};



class EventTsid
{
public:
	EventTsid( int t );
	~EventTsid();
	int getTsid() { return tsid; }
	EventSid *getEventSid( int sid );
	EventSid *getNEventSid( int n );
	int getNSid() { return sidList.count(); }
	EventDesc *getEventDesc( int sid, int n );
private:
	QMutex mutex;
	int tsid;
	QPtrList<EventSid> sidList;
};



class EventSource
{
public:
	EventSource( QString src );
	~EventSource();
	EventSid *getEventSid( int tsid, int sid );
	EventTsid *getNEventTsid( int n );
	int getNTsid() { return tsidList.count(); }
	EventDesc *getEventDesc( int tsid, int sid, int n );
	QString getSource() { return source; }
private:
	QMutex mutex;
	QString source;
	QPtrList<EventTsid> tsidList;
};



class EventTable : public QObject, public QThread
{
	Q_OBJECT
public:
	EventTable();
	~EventTable();
	EventSource *getEventSource( QString src );
	EventDesc *getEventDesc( QString src, int tsid, int sid, int n );
	EventSource *getNEventSource( int n );
	int getNSource() { return srcList.count(); }
	void doClean( bool b );
	void saveEpg();
	void loadEpg();
protected:
	virtual void run();
private:
	bool validString( QFile &f, EventDesc *d, int len, int buflen, int nev );
	QMutex mutex;
	QPtrList<EventSource> srcList;
	QTimer cleanTimer;
	bool epgLoaded;
private slots:
	void setClean();
};



class DVBevents : public DVBsection
{
	Q_OBJECT

public:

	DVBevents( bool *ok, int anum, int tnum, const QString &charset, EventTable *table );
	~DVBevents();
	bool go( QString src, bool all=false );
	void stop();

private:

	virtual void run();
	bool tableEIT( unsigned char* buffer );
	bool shortEventDesc( unsigned char *buf, EventDesc *desc );
	bool extEventDesc( unsigned char *buf, EventDesc *desc );
	bool safeLen( unsigned char* buf );

	unsigned char secbuf[4096];
	int readSize;
	struct pollfd pf[1];

	EventTable *events;
	EventSource *currentSrc;

signals:

	void newEvent( EventDesc* );

};

#endif /* DVBEVENTS_H */
