<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  ** Author: Marco Ladermann <marco.ladermann@gmx.de>
  ** Date:   Fri Mar 28 18:37:09 CET 2003 @775 /Internet Time/
  ** 
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet 
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:exsl="http://exslt.org/common"
    xmlns:func="http://exslt.org/functions"
    xmlns:date="http://exslt.org/dates-and-times"
    xmlns:kde="http://kde.org/functions"
    xmlns:java="http://kde.org/java"
    extension-element-prefixes="func"
 >
    <!--
      ** Utility functions for java output
      -->
 
    <!-- Are images in the ui file or in the project or loaded via function ? -->
    <func:function name="java:getPixmap">
        <xsl:param name="image" select="."/>
        <func:result>
            <xsl:choose>
                <xsl:when test="/UI/pixmapfunction">
                    <xsl:value-of select="concat(/UI/pixmapfunction,'( ',$image, ' )')"/>
                </xsl:when>
                <xsl:when test="/UI/pixmapinproject">
                    <xsl:value-of select="concat('QPixmap.fromMimeSource( &quot;',
                                                                          $images,
                                                                          $image,
                                                                          '&quot; )')"/>

                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$image"/>
                </xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>
    
    <!-- Function to generate the appropriate translate function for strings -->
    <func:function name="java:tr">
        <xsl:param name="isUtf8"/>
        <func:result>
            <xsl:choose>
                <xsl:when test="string($isUtf8) = 'true'">
                    <xsl:text>trUtf8</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>tr</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>

    <!-- Helper function to calculate the name of the containing node -->
    <func:function name="java:getNodeName">
        <xsl:param name="node" select="."/>
        <func:result>
            <xsl:variable name="nn" select="kde:getNodeName($node)"/>
            <xsl:choose>
                <xsl:when test="$nn = /UI/widget/property[@name = 'name']/cstring">
                    <xsl:value-of select="'this'"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$nn"/>
                </xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>
    
    <!-- Helper function to calculate the name of the containing container -->
    <func:function name="java:getContainerName">
        <xsl:param name="node" select="."/>
        <func:result>
            <xsl:choose>
                <xsl:when test="$node = /UI/widget and /UI/widget/@class = 'QMainWindow'">
                    <xsl:value-of select="'centralWidget()'"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="java:getNodeName($node)"/>
                </xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>
    
    <!--
      ** Change signal/slot signature
      -->
    <func:function name="java:cpp-to-java-signature">
        <xsl:param name="node"/>
        <func:result>
            <xsl:variable name="s1" select="translate($node, '&amp;*', '  ')"/>
            <xsl:variable name="s2" select="kde:replace($s1, 'QString', 'String')"/>
            <xsl:variable name="s3" select="kde:replace($s2, 'const', '')"/>
            <xsl:variable name="s4" select="kde:replace($s3, 'virtual', '')"/>
            <xsl:variable name="s5" select="kde:replace($s4, 'bool', 'boolean')"/>
            <xsl:variable name="result" select="$s5"/>
            <xsl:if test="$node != $result">
                <xsl:variable name="path" select="kde:printPath($node)"/>
                <xsl:message>
In element at <xsl:value-of select="$path"/>:
signature changed from C++: <xsl:value-of select="$node"/>
                   to Java: <xsl:value-of select="$result"/>
                </xsl:message>
            </xsl:if>
            <xsl:value-of select="$result"/>
        </func:result>
    </func:function>

	<!--
	  ** Mask backslash and quote characters
	  -->
    <func:function name="java:toJavaString">
      <xsl:param name="text"/>
      <func:result>
        <xsl:variable name="s1" select="kde:replace($text, '\', '\\')"/>
        <xsl:variable name="s2" select="kde:replace($s1, '&quot;', '\&quot;')" />
        <xsl:variable name="s3" select="kde:replace($s2, '&#xA;', '\n')" />
        <xsl:variable name="s4" select="kde:replace($s3, '&#xD;', '\r')" />
        <xsl:variable name="result" select="$s4" />
        <xsl:value-of select="$result"/>
      </func:result>
    </func:function>
</xsl:stylesheet>

