/*!
 * PHP-Qt - The PHP language bindings for Qt
 *
 * Copyright (C) 2006 - 2007
 * Thomas Moenicke <tm at php-qt.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#ifndef PHPQT_INTERNALS_H
#define PHPQT_INTERNALS_H

#include "smoke.h"
#include <QtCore/qobjectdefs.h>
#include <php.h>

class QString;
class smokephp_object;

namespace PHPQt
{

void 				destroyHashtable(zend_rsrc_list_entry *rsrc);
void				readDebugLevels();

zval* 				callPHPMethod(const zval* zend_ptr, const char* methodname, const zend_uint param_count, zval** params);
bool 				methodExists(const zend_class_entry* ce_ptr, const char* methodname);
bool 				getMocData(zval* this_ptr, const char* classname, const QMetaObject* superdata,  QString* meta_stringdata, uint* signature);
void				createMetaObject(smokephp_object* o, zval* this_ptr);
bool 				qt_metacall(smokephp_object* o, Smoke::Stack args);
const char*			checkForOperator(const char* fname);

void* 				getQtObjectFromZval(const zval* this_ptr);
smokephp_object* 	getSmokePHPObjectFromZval(const zval* this_ptr);
smokephp_object*	getSmokePHPObjectFromQt(const void* QtPtr);
void				setSmokePHPObject(smokephp_object* o);
bool 				SmokePHPObjectExists(const zval* this_ptr);
bool				SmokePHPObjectExists(const void* ptr);

bool				unmapSmokePHPObject(const zval* o);
bool				unmapSmokePHPObject(smokephp_object* o);
void				mapSmokePHPObject( const zend_object_handle handle, smokephp_object* );

smokephp_object*	createObject(zval* zval_ptr, const void* ptr, const zend_class_entry* ce = 0, const Smoke::Index classId = 0);
smokephp_object*	cloneObject(zval* zval_ptr, smokephp_object* so, const void* copyPtr);
smokephp_object*	createOriginal(zval* zval_ptr, void* ptr);
void 				restoreObject( smokephp_object* o );

void				check_qobject(zval* zobject);
const char* 		printType(int type);

}; // namespace PHPQt

#endif
