
#ifndef CONTEXT_H
#define CONTEXT_H

#include <QStack>
class QByteArray;
#include "zend.h"

/*!
 * API to access to some context settings
 */

class Context
{
    static Context* m_Context;

    Context();
    ~Context(){};

public:
    enum CallType
    {
        ConstructorCall = 1,
        MethodCall,
	StaticMethodCall,
        VirtualMethodCall,
        SignalCall,
        SlotCall
    };

    static void createContext();
    static void destroyContext();

    static zend_class_entry* activeCe();
    static zval* activeScope();
    static bool parentCall();
    static void removeMethodName();
    static QByteArray* methodName();
    static const char* methodNameC();

    static void setActiveCe(zend_class_entry* activeCePtr);
    static void setActiveScope(zval* zval_ptr);
    static void removeActiveScope();
    static void setParentCall(bool pc);
    static void setMethodName(const char* name);

    static void removeActiveCe();

    static void setCallType( const CallType callType );
    static const CallType callType();

private:
    class Private;
    Context::Private *d;
};

#endif

