/* This file is part of the KDE Project
   Copyright (c) 2008 Sebastian Trueg <trueg@kde.org>

   Based on code generated by dbusxml2cpp version 0.6
   dbusxml2cpp is Copyright (C) 2006 Trolltech ASA. All rights reserved.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _STRIGISERVICE_ADAPTOR_H_
#define _STRIGISERVICE_ADAPTOR_H_

#include <QtDBus/QDBusAbstractAdaptor>

namespace Nepomuk {

    class StrigiService;

    class StrigiServiceAdaptor: public QDBusAbstractAdaptor
    {
        Q_OBJECT
        Q_CLASSINFO("D-Bus Interface", "org.kde.nepomuk.Strigi")
        Q_CLASSINFO("D-Bus Introspection", ""
                    "  <interface name=\"org.kde.nepomuk.Strigi\" >\n"
                    "    <method name=\"isIndexing\" >\n"
                    "      <arg direction=\"out\" type=\"b\" />\n"
                    "    </method>\n"
                    "    <method name=\"isSuspended\" >\n"
                    "      <arg direction=\"out\" type=\"b\" />\n"
                    "    </method>\n"
                    "    <method name=\"currentFolder\" >\n"
                    "      <arg direction=\"out\" type=\"s\" />\n"
                    "    </method>\n"
                    "    <method name=\"suspend\" />\n"
                    "    <method name=\"resume\" />\n"
                    "    <method name=\"updateFolder\" >\n"
                    "      <arg name=\"path\" direction=\"in\" type=\"s\" />\n"
                    "    </method>\n"
                    "    <method name=\"updateAllFolders\" />\n"
                    "    <method name=\"analyzeResource\" >\n"
                    "      <arg name=\"uri\" direction=\"in\" type=\"s\" />\n"
                    "      <arg name=\"lastModificationDate\" direction=\"in\" type=\"u\" />\n"
                    "      <arg name=\"data\" direction=\"in\" type=\"ay\" />\n"
                    "    </method>\n"
                    "    <method name=\"analyzeResourceFromTempFileAndDeleteTempFile\" >\n"
                    "      <arg name=\"uri\" direction=\"in\" type=\"s\" />\n"
                    "      <arg name=\"lastModificationDate\" direction=\"in\" type=\"u\" />\n"
                    "      <arg name=\"tmpFileName\" direction=\"in\" type=\"s\" />\n"
                    "    </method>\n"
                    "    <method name=\"userStatusString\" >\n"
                    "      <arg direction=\"out\" type=\"s\" />\n"
                    "    </method>\n"
                    "    <signal name=\"statusChanged\" />\n"
                    "    <signal name=\"indexingStarted\" />\n"
                    "    <signal name=\"indexingStopped\" />\n"
                    "    <signal name=\"indexingFolder\" >\n"
                    "      <arg type=\"s\" name=\"path\" />\n"
                    "    </signal>\n"
                    "  </interface>\n"
                    "")

    public:
        StrigiServiceAdaptor( StrigiService* parent );
        ~StrigiServiceAdaptor();

    public Q_SLOTS:
        bool isIndexing();
        bool isSuspended();
        QString currentFolder();
        void resume();
        void suspend();
        void updateFolder( const QString& path );
        void updateAllFolders();
        void analyzeResource( const QString& uri, uint mTime, const QByteArray& data );
        void analyzeResourceFromTempFileAndDeleteTempFile( const QString& uri, uint mTime, const QString& tmpFile );
        QString userStatusString() const;

    Q_SIGNALS:
        void statusChanged();
        void indexingFolder( const QString& path );
        void indexingStarted();
        void indexingStopped();

    private:
        StrigiService* m_service;
    };
}

#endif
