/*
 *   Copyright (C) 2007 Ivan Cukic <ivan.cukic+kde@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library/Lesser General Public License
 *   version 2, or (at your option) any later version, as published by the
 *   Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library/Lesser General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef PLASMA_CUSTOMDRAGTREEVIEW_P_H
#define PLASMA_CUSTOMDRAGTREEVIEW_P_H

#include <QTreeView>
#include "kcategorizeditemsviewmodels_p.h"

class KCategorizedItemsView;

class CustomDragTreeView: public QTreeView
{
public:
    CustomDragTreeView(QWidget *parent = 0);

protected:
    void focusInEvent(QFocusEvent *event);
    void startDrag(Qt::DropActions supportedActions);

private:
    KCategorizedItemsView *m_view;

    friend class KCategorizedItemsView;
};

#endif

