//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;

	/// <remarks>
	///    This class provides a spin box for fractional numbers.
	///    \image html kdoublespinbox.png "KDE Fractional Number Spinbox"
	///    See below for code examples on how to use this class.
	///    <li><b>Parameters </b></li>
	///    To make successful use of KDoubleSpinBox, you need to understand the
	///    relationship between precision and available range.
	/// 
	/// <li>
	/// precision: The number of digits after the decimal point.
	/// </li>
	/// 
	/// <li>
	/// maximum/minimum: upper and lower bounds of the valid range
	/// </li>
	/// 
	/// <li>
	/// lineStep: the size of the step that is made when the user hits
	///                  the up or down buttons
	/// </li>
	///    Since we work with fixed-point numbers internally, the maximum
	///    precision is a function of the valid range and vice versa. More
	///    precisely, the following relationships hold:
	///    <pre>
	///    max( abs(minimum()), abs(maximum() ) <= INT_MAX/10^precision
	///    maxPrecision = floor( log10( INT_MAX/max(abs(minimum()),abs(maximum())) ) )
	///    </pre>
	///    Since the value, bounds and lineStep are rounded to the current
	///    precision, you may find that the order of setting these
	///    parameters matters. As an example, the following are <b>not</b> equivalent (try
	///    it!):
	///    <pre>
	///    // sets precision,
	///    // then min/max value (rounded to precision and clipped to obtainable range if needed)
	///    // then value and lineStep
	///    KDoubleSpinBox  spin = new KDoubleSpinBox( 0, 9.999, 0.001, 4.321, 3, this );
	///    // sets minimum to 0; maximum to 10.00(!); value to 4.32(!) and only then
	///    // increases the precision - too late, since e.g. value has already been rounded...
	///    KDoubleSpinBox  spin = new KDoubleSpinBox( this );
	///    spin.SetMinimum( 0 );
	///    spin.SetMaximum( 9.999 );
	///    spin.SetValue( 4.321 );
	///    spin.SetPrecision( 3 );
	///    </pre>
	///  See <see cref="IKDoubleSpinBoxSignals"></see> for signals emitted by KDoubleSpinBox
	/// </remarks>		<author> Marc Mutz <mutz@kde.org>
	/// </author>
	/// 		<short> A spin box for fractional numbers. </short>

	[SmokeClass("KDoubleSpinBox")]
	public class KDoubleSpinBox : QSpinBox, IDisposable {
 		protected KDoubleSpinBox(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KDoubleSpinBox), this);
		}
		[Q_PROPERTY("bool", "acceptLocalizedNumbers")]
		public bool AcceptLocalizedNumbers {
			get { return (bool) interceptor.Invoke("acceptLocalizedNumbers", "acceptLocalizedNumbers()", typeof(bool)); }
			set { interceptor.Invoke("setAcceptLocalizedNumbers$", "setAcceptLocalizedNumbers(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("int", "precision")]
		public int Precision {
			get { return (int) interceptor.Invoke("precision", "precision()", typeof(int)); }
			set { interceptor.Invoke("setPrecision$", "setPrecision(int)", typeof(void), typeof(int), value); }
		}
		/// <remarks> Constructs a KDoubleSpinBox with parent <code>parent</code> and
		///       default values for range and value (whatever QRangeControl
		///       uses) and precision (2). </remarks>		<short>   Constructs a KDoubleSpinBox with parent <code>parent</code> and       default values for range and value (whatever QRangeControl       uses) and precision (2).</short>
		public KDoubleSpinBox(QWidget parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KDoubleSpinBox#", "KDoubleSpinBox(QWidget*)", typeof(void), typeof(QWidget), parent);
		}
		public KDoubleSpinBox() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KDoubleSpinBox", "KDoubleSpinBox()", typeof(void));
		}
		/// <remarks> Constructs a KDoubleSpinBox with parent <code>parent</code>, range
		///       [ <code>lower</code>, <code>upper</code> ], lineStep <code>step</code>, precision <code>precision</code> and initial value <code>value.</code> </remarks>		<short>   Constructs a KDoubleSpinBox with parent <code>parent</code>, range       [ <code>lower</code>, <code>upper</code> ], lineStep <code>step</code>, precision <code>precision</code> and initial value <code>value.</code></short>
		public KDoubleSpinBox(double lower, double upper, double step, double value, QWidget parent, int precision) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KDoubleSpinBox$$$$#$", "KDoubleSpinBox(double, double, double, double, QWidget*, int)", typeof(void), typeof(double), lower, typeof(double), upper, typeof(double), step, typeof(double), value, typeof(QWidget), parent, typeof(int), precision);
		}
		public KDoubleSpinBox(double lower, double upper, double step, double value, QWidget parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KDoubleSpinBox$$$$#", "KDoubleSpinBox(double, double, double, double, QWidget*)", typeof(void), typeof(double), lower, typeof(double), upper, typeof(double), step, typeof(double), value, typeof(QWidget), parent);
		}
		/// <remarks> Sets whether to use and accept localized numbers as returned by
		///       KLocale.FormatNumber() </remarks>		<short>   Sets whether to use and accept localized numbers as returned by       KLocale.FormatNumber() </short>
		[SmokeMethod("setAcceptLocalizedNumbers(bool)")]
		public virtual void SetAcceptLocalizedNumbers(bool accept) {
			interceptor.Invoke("setAcceptLocalizedNumbers$", "setAcceptLocalizedNumbers(bool)", typeof(void), typeof(bool), accept);
		}
		/// <remarks> Sets a new range for the spin box values. Note that <code>lower</code>, <code>upper</code> and <code>step</code> are rounded to <code>precision</code> decimal points
		///       first. </remarks>		<short>   Sets a new range for the spin box values.</short>
		public void SetRange(double lower, double upper, double step, int precision) {
			interceptor.Invoke("setRange$$$$", "setRange(double, double, double, int)", typeof(void), typeof(double), lower, typeof(double), upper, typeof(double), step, typeof(int), precision);
		}
		public void SetRange(double lower, double upper, double step) {
			interceptor.Invoke("setRange$$$", "setRange(double, double, double)", typeof(void), typeof(double), lower, typeof(double), upper, typeof(double), step);
		}
		public void SetRange(double lower, double upper) {
			interceptor.Invoke("setRange$$", "setRange(double, double)", typeof(void), typeof(double), lower, typeof(double), upper);
		}
		/// <remarks> Sets the precision (number of digits to the right of the decimal point). Note
		///       that there is a tradeoff between the precision used and the available range of
		///       values. See the class documentation above for more information on this.
		/// <param> name="precision" the new precision to use
		/// </param><param> name="force" if true, disables checking of bounds violations that can
		///              arise if you increase the precision so much that the
		///              minimum and maximum values can't be represented
		///              anymore. Disabling is useful if you were going to disable range
		///              control in any case.
		/// </param></remarks>		<short>   Sets the precision (number of digits to the right of the decimal point).</short>
		[SmokeMethod("setPrecision(int, bool)")]
		public virtual void SetPrecision(int precision, bool force) {
			interceptor.Invoke("setPrecision$$", "setPrecision(int, bool)", typeof(void), typeof(int), precision, typeof(bool), force);
		}
		/// <remarks> @return the current value </remarks>		<short>   @return the current value </short>
		public new double Value() {
			return (double) interceptor.Invoke("value", "value() const", typeof(double));
		}
		/// <remarks> @return the current lower bound </remarks>		<short>   @return the current lower bound </short>
		public new double Minimum() {
			return (double) interceptor.Invoke("minimum", "minimum() const", typeof(double));
		}
		/// <remarks> Sets the lower bound of the range to <code>value</code>, subject to the
		///       contraints that <code>value</code> is first rounded to the current
		///       precision and then clipped to the maximum range interval that can
		///       be handled at that precision.
		/// </remarks>		<short>   Sets the lower bound of the range to <code>value</code>, subject to the       contraints that <code>value</code> is first rounded to the current       precision and then clipped to the maximum range interval that can       be handled at that precision.</short>
		/// 		<see> maximum</see>
		/// 		<see> minimum</see>
		/// 		<see> setMaximum</see>
		/// 		<see> setRange</see>
		public void SetMinimum(double value) {
			interceptor.Invoke("setMinimum$", "setMinimum(double)", typeof(void), typeof(double), value);
		}
		/// <remarks> @return the current upper bound </remarks>		<short>   @return the current upper bound </short>
		public new double Maximum() {
			return (double) interceptor.Invoke("maximum", "maximum() const", typeof(double));
		}
		/// <remarks> Sets the upper bound of the range to <code>value</code>, subject to the
		///       contraints that <code>value</code> is first rounded to the current
		///       precision and then clipped to the maximum range interval
		///       that can be handled at that precision.
		/// </remarks>		<short>   Sets the upper bound of the range to <code>value</code>, subject to the       contraints that <code>value</code> is first rounded to the current       precision and then clipped to the maximum range interval       that can be handled at that precision.</short>
		/// 		<see> minimum</see>
		/// 		<see> maximum</see>
		/// 		<see> setMinimum</see>
		/// 		<see> setRange</see>
		public void SetMaximum(double value) {
			interceptor.Invoke("setMaximum$", "setMaximum(double)", typeof(void), typeof(double), value);
		}
		/// <remarks> @return the current step size </remarks>		<short>   @return the current step size </short>
		public new double SingleStep() {
			return (double) interceptor.Invoke("singleStep", "singleStep() const", typeof(double));
		}
		/// <remarks> Sets the step size for clicking the up/down buttons to <code>step</code>,
		///       subject to the constraints that <code>step</code> is first rounded to the
		///       current precision and then clipped to the meaningful interval
		///       [ 1, <code>maximum</code>() - <code>minimum</code>() ]. </remarks>		<short>   Sets the step size for clicking the up/down buttons to <code>step</code>,       subject to the constraints that <code>step</code> is first rounded to the       current precision and then clipped to the meaningful interval       [ 1, <code>maximum</code>() - <code>minimum</code>() ].</short>
		public void SetSingleStep(double step) {
			interceptor.Invoke("setSingleStep$", "setSingleStep(double)", typeof(void), typeof(double), step);
		}
		/// <remarks> Overridden to ignore any setValidator() calls. </remarks>		<short>   Overridden to ignore any setValidator() calls.</short>
		public void SetValidator(QValidator arg1) {
			interceptor.Invoke("setValidator#", "setValidator(const QValidator*)", typeof(void), typeof(QValidator), arg1);
		}
		/// <remarks> Sets the current value to <code>value</code>, subject to the constraints
		///       that <code>value</code> is first rounded to the current precision and then
		///       clipped to the interval [ <code>minimum</code>() , <code>maximum</code>() ]. </remarks>		<short>   Sets the current value to <code>value</code>, subject to the constraints       that <code>value</code> is first rounded to the current precision and then       clipped to the interval [ <code>minimum</code>() , <code>maximum</code>() ].</short>
		[Q_SLOT("void setValue(double)")]
		[SmokeMethod("setValue(double)")]
		public virtual void SetValue(double value) {
			interceptor.Invoke("setValue$", "setValue(double)", typeof(void), typeof(double), value);
		}
		[SmokeMethod("textFromValue(int) const")]
		protected override string TextFromValue(int arg1) {
			return (string) interceptor.Invoke("textFromValue$", "textFromValue(int) const", typeof(string), typeof(int), arg1);
		}
		[SmokeMethod("valueFromText(const QString&) const")]
		protected override int ValueFromText(string text) {
			return (int) interceptor.Invoke("valueFromText$", "valueFromText(const QString&) const", typeof(int), typeof(string), text);
		}
		[Q_SLOT("void slotValueChanged(int)")]
		protected void SlotValueChanged(int value) {
			interceptor.Invoke("slotValueChanged$", "slotValueChanged(int)", typeof(void), typeof(int), value);
		}
		~KDoubleSpinBox() {
			interceptor.Invoke("~KDoubleSpinBox", "~KDoubleSpinBox()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KDoubleSpinBox", "~KDoubleSpinBox()", typeof(void));
		}
		protected new IKDoubleSpinBoxSignals Emit {
			get { return (IKDoubleSpinBoxSignals) Q_EMIT; }
		}
	}

	public interface IKDoubleSpinBoxSignals : IQSpinBoxSignals {
		/// <remarks> Emitted whenever QSpinBox.ValueChanged( int ) is emitted. </remarks>		<short>   Emitted whenever QSpinBox.ValueChanged( int ) is emitted.</short>
		[Q_SIGNAL("void valueChanged(double)")]
		void ValueChanged(double value);
	}
}
