//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Collections.Generic;

	/// <remarks>
	///  KNotification is used to notify some event to the user.
	///  \section introduction
	///  There is mainly two kind of notifications 
	/// 
	/// <li>
	/// Feedback events:
	///  For notifying the user that he/she just performed an operation, like maximizing a
	///  window. This allows us to play sounds when a dialog appears.
	///  This is an instant notification.  It ends automatically after a small timeout
	/// </li>
	/// 
	/// <li>
	/// persistant notifications:
	///  Notify when one received a new message, or when something important happened
	///  the user has to know.  This notification has a start and a end.  It start when
	///  the event actually occurs, and finish when the message is acknowledged or read.
	/// </li>
	///  Example of a persistant notification in an instant messaging application:
	///  The application emit the notification whe the message actually received, and close it only
	///  when the user has read the message (when the message window has received the focus) using the close() slot
	///  Persistant notification must have the Persistant flag.
	///  In order to do a notification, you need to create a description files, which contains 
	///  default parametters of the notification, and use KNotification.Event at the place of the
	///  code where the notification occurs.
	///  the returned KNotification pointer may be used to connect signals or slots
	///  \section file The global config file
	///  On installation, there should be a file called 
	///   <em>$KDEDIR/share/apps/appname/appname.notifyrc</em>
	///   This file contains  mainly 3 parts
	///    <ol><li>\ref global "Global information"</li>
	///        <li>\ref context "Context information"</li>
	///        <li>\ref events "Information about every events"</li></ol>
	///   \subsection global Global information
	///  The global part looks like that
	///  <pre>
	/// 		   [Global]
	/// 		   IconName=Filename
	/// 		   Comment=Freindly Name of app
	///  </pre>
	///    The icon filename is just the name, without extension,  it's found with the KIconLoader
	///  \subsection context Context information
	///  This part is only hints for the configuration widget
	///   <pre>
	/// 		   [Context/group]
	/// 		   Name=Group name
	/// 		   Comment=The name of the group of the contact
	/// 		   [Context/folder]
	/// 		   Name=Group name
	///   </pre>
	///   the second part of the groupname is the context identifier.
	///   It should not contains special characters.
	///   The Name field is the one the user will see (and which is translated)
	///  \subsection events Description of Events
	///  Now comes the most important,  the description of each events.
	///  <pre>
	/// 		   [Event/newmail]
	/// 		   Name=New email
	/// 		   Comment=You have got a new email
	/// 		   Contexts=folder,group
	/// 		   Action=Sound|Popup
	/// 		   [Event/contactOnline]
	/// 		   Name=Contact goes online
	/// 		   Comment=One of your contact has been connected
	/// 		   Contexts=group
	/// 		   Sound=filetoplay.ogg
	/// 		   Action=None
	///   </pre>
	///    All you put there are the default value.
	///    Action is a bitmask of KNotification.NotifyPresentation
	///   Contexts is a comma separated list of possible context for this event.
	///   \section userfile The user's config file
	///   This is only an implementation detail, for your information.
	///  On the config file, there is two parts:  the events configuration, and the context information
	///  \subsection context Context information
	///   This is only hints for the configuration dialog. It contains both the internal id of the context, and the user visible string.
	///   <pre>
	/// 		   [Context/group]
	/// 		   Values=1:Friends,2:Work,3:Family
	///   </pre>
	///  \subsection event Events configuration
	///    This contains the configuration of events for the user.
	///    It contains the same fields as the description file.
	///     The key of groups is in the form 
	///   <em>Event/&lt;EventName&gt;/&lt;ContextName&gt;/&lt;ContextValue&gt;</em>
	///  <pre>
	/// 		   [Event/contactOnline]
	/// 		   Action=Sound
	/// 		   Sound=/usr/share/sounds/super.ogg
	/// 		   [Event/contactOnline/group/1]
	/// 		   Action=PassivePopup|Sound
	///  </pre>
	///  \section example Example of code
	///  This portion of code will fire the event for the "contactOnline" event
	///  @code
	/// 	KNotification notification= new KNotification ( "contactOnline" );
	/// 	notification.SetText( i18n("The contact <i>%1</i> has gone online").arg( contact.Name() ) );
	/// 	notification.SetPixmap( contact.Pixmap() );
	/// 	notification.SetActions( List<string>( i18n( "Open chat" ) ) );
	/// 	foreach( stringgroup , contact.Groups() ) {
	/// 		notification.AddContext( "group" , group ) ;
	/// 	}
	/// 	connect(notification, SIGNAL("activated(unsigned int )"), contact , SLOT("slotOpenChat()") );
	/// 	notification.SendEvent();
	///  @endcode
	///  See <see cref="IKNotificationSignals"></see> for signals emitted by KNotification
	/// </remarks>		<author> Olivier Goffart  \<ogoffart at kde.org\>
	///  </author>
	/// 		<short>    KNotification is used to notify some event to the user.</short>

	[SmokeClass("KNotification")]
	public class KNotification : QObject, IDisposable {
 		protected KNotification(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KNotification), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KNotification() {
			staticInterceptor = new SmokeInvocation(typeof(KNotification), null);
		}
		public enum NotificationFlag {
			RaiseWidgetOnActivation = 0x01,
			CloseOnTimeout = 0x00,
			Persistant = 0x02,
			CloseWhenWidgetActivated = 0x04,
			DefaultEvent = 0xF000,
		}
		/// <remarks>
		///  default events you can use in the event function
		/// 	 </remarks>		<short>    default events you can use in the event function 	 </short>
		public enum StandardEvent {
			Notification = 0,
			Warning = 1,
			Error = 2,
			Catastrophe = 3,
		}
		// KNotification* KNotification(const QString& arg1,QWidget* arg2,const KNotification::NotificationFlags& arg3); >>>> NOT CONVERTED
		// KNotification::ContextList contexts(); >>>> NOT CONVERTED
		// void setContexts(const KNotification::ContextList& arg1); >>>> NOT CONVERTED
		// void addContext(const KNotification::Context& arg1); >>>> NOT CONVERTED
		// void setFlags(const KNotification::NotificationFlags& arg1); >>>> NOT CONVERTED
		// KNotification* event(const QString& arg1,const QString& arg2,const QPixmap& arg3,QWidget* arg4,const KNotification::NotificationFlags& arg5,const KComponentData& arg6); >>>> NOT CONVERTED
		// KNotification* event(const QString& arg1,const QString& arg2,const QPixmap& arg3,QWidget* arg4,const KNotification::NotificationFlags& arg5); >>>> NOT CONVERTED
		// KNotification* event(KNotification::StandardEvent arg1,const QString& arg2,const QPixmap& arg3,QWidget* arg4,const KNotification::NotificationFlags& arg5); >>>> NOT CONVERTED
		/// <remarks>
		///  Create a new notification.
		///  you need to use sendEvent to show the notification.
		///  The pointer is automatically deleted when the event is closed.
		///  Make sure you use one of the CloseOnTimeOut or CloseWhenWidgetActivated, if not,
		///  you have to close yourself the notification.
		/// <param> name="eventId" is the name of the event
		/// </param><param> name="widget" is a widget where the notification reports to
		/// </param><param> name="flags" is a bitmask of NotificationFlag
		/// 	 </param></remarks>		<short>    Create a new notification.</short>
		public KNotification(string eventId, QWidget widget) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KNotification$#", "KNotification(const QString&, QWidget*)", typeof(void), typeof(string), eventId, typeof(QWidget), widget);
		}
		public KNotification(string eventId) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KNotification$", "KNotification(const QString&)", typeof(void), typeof(string), eventId);
		}
		/// <remarks>
		///  @brief the widget associated to the notification
		///  If the widget is destroyed, the notification will be automatically canceled.
		///  If the widget is activated, the notificaiton will be automatically closed if the flags said that
		///  When the notification is activated, the widget might be raised.
		///  Depending of the configuration, the taskbar entry of the window containing the widget may blink.
		/// 	 </remarks>		<short>    @brief the widget associated to the notification </short>
		public QWidget Widget() {
			return (QWidget) interceptor.Invoke("widget", "widget() const", typeof(QWidget));
		}
		/// <remarks>
		///  Set the widget associated to the notification.
		///  The notification is reparented to the new widget.
		///  \see widget()
		/// <param> name="widget" the new widget
		/// 	 </param></remarks>		<short>    Set the widget associated to the notification.</short>
		public void SetWidget(QWidget widget) {
			interceptor.Invoke("setWidget#", "setWidget(QWidget*)", typeof(void), typeof(QWidget), widget);
		}
		/// <remarks>
		/// </remarks>		<return> the name of the event
		/// 	 </return>
		/// 		<short>   </short>
		public string EventId() {
			return (string) interceptor.Invoke("eventId", "eventId() const", typeof(string));
		}
		/// <remarks>
		/// </remarks>		<return> the notification text
		/// </return>
		/// 		<short>   </short>
		/// 		<see> setText</see>
		public string Text() {
			return (string) interceptor.Invoke("text", "text() const", typeof(string));
		}
		/// <remarks>
		///  Set the notification text that will appears in the popup.
		///  The text is shown in a QLabel, you should make sure to escape the html is needed.
		///  You can use some of the qt basic html tags.
		/// <param> name="text" the text
		/// 	 </param></remarks>		<short>    Set the notification text that will appears in the popup.</short>
		public void SetText(string text) {
			interceptor.Invoke("setText$", "setText(const QString&)", typeof(void), typeof(string), text);
		}
		/// <remarks>
		///  \return the pixmap shown in the popup
		///  \see setPixmap
		/// 	 </remarks>		<short>    \return the pixmap shown in the popup  \see setPixmap 	 </short>
		public QPixmap Pixmap() {
			return (QPixmap) interceptor.Invoke("pixmap", "pixmap() const", typeof(QPixmap));
		}
		/// <remarks>
		///  set the pixmap that will be shown in the popup.
		/// <param> name="pix" the pixmap
		/// 	 </param></remarks>		<short>    set the pixmap that will be shown in the popup.</short>
		public void SetPixmap(QPixmap pix) {
			interceptor.Invoke("setPixmap#", "setPixmap(const QPixmap&)", typeof(void), typeof(QPixmap), pix);
		}
		/// <remarks>
		/// </remarks>		<return> the list of actions
		/// 	 </return>
		/// 		<short>   </short>
		public List<string> Actions() {
			return (List<string>) interceptor.Invoke("actions", "actions() const", typeof(List<string>));
		}
		/// <remarks>
		///  Set the list of actions link shown in the popup.
		/// <param> name="actions" the list of actions
		/// 	 </param></remarks>		<short>    Set the list of actions link shown in the popup.</short>
		public void SetActions(List<string> actions) {
			interceptor.Invoke("setActions?", "setActions(const QStringList&)", typeof(void), typeof(List<string>), actions);
		}
		/// <remarks>
		/// </remarks>		<return> the list of contexts, see KNotification.Context
		/// 	 </return>
		/// 		<short>   </short>
		/// <remarks>
		///  set the list of context, see KNotification.Context
		///  The list of context must be set before calling sendEvent;
		/// 	 </remarks>		<short>    set the list of context, see KNotification.Context </short>
		/// <remarks>
		///  append a context at the list of contexts, see KNotificaiton.Context
		/// <param> name="context" the context which is added
		/// 	 </param></remarks>		<short>    append a context at the list of contexts, see KNotificaiton.Context </short>
		/// <remarks>
		///  @overload
		/// <param> name="context_key" is the key of the context
		/// </param><param> name="context_value" is the value of the context
		/// 	 </param></remarks>		<short>    @overload </short>
		public void AddContext(string context_key, string context_value) {
			interceptor.Invoke("addContext$$", "addContext(const QString&, const QString&)", typeof(void), typeof(string), context_key, typeof(string), context_value);
		}
		/// <remarks>
		/// </remarks>		<return> the notifications flags.
		///      </return>
		/// 		<short>   </short>
		public uint Flags() {
			return (uint) interceptor.Invoke("flags", "flags() const", typeof(uint));
		}
		/// <remarks>
		///  Set the notification flags.
		///  should be called before sendEvent().
		///      </remarks>		<short>    Set the notification flags.</short>
		/// <remarks>
		///  The componentData is used to determine the location of the config file.  By default, kapp is used
		/// <param> name="componentData" the new componentData
		///      </param></remarks>		<short>    The componentData is used to determine the location of the config file.</short>
		public void SetComponentData(KComponentData componentData) {
			interceptor.Invoke("setComponentData#", "setComponentData(const KComponentData&)", typeof(void), typeof(KComponentData), componentData);
		}
		/// <remarks>
		///  @brief Active the action specified action
		///  If the action is zero, then the default action is activated
		/// 	 </remarks>		<short>    @brief Active the action specified action  If the action is zero, then the default action is activated 	 </short>
		[Q_SLOT("void activate(unsigned int)")]
		public void Activate(uint action) {
			interceptor.Invoke("activate$", "activate(unsigned int)", typeof(void), typeof(uint), action);
		}
		[Q_SLOT("void activate()")]
		public void Activate() {
			interceptor.Invoke("activate", "activate()", typeof(void));
		}
		/// <remarks>
		///  close the notification without activate it.
		///  This will delete the notification
		/// 	 </remarks>		<short>    close the notification without activate it.</short>
		[Q_SLOT("void close()")]
		public void Close() {
			interceptor.Invoke("close", "close()", typeof(void));
		}
		/// <remarks>
		///  @brief Raise the widget.
		///  This will change the desktop, activate the window, and the tab if needed.
		/// 	 </remarks>		<short>    @brief Raise the widget.</short>
		[Q_SLOT("void raiseWidget()")]
		public void RaiseWidget() {
			interceptor.Invoke("raiseWidget", "raiseWidget()", typeof(void));
		}
		/// <remarks>
		///  The notification will automatically be closed if all presentation are finished.
		///  if you want to show your own presentation in your application, you should use this
		///  function, so it will not be automatically closed when there is nothing to show.
		///  don't forgot to deref, or the notification may be never closed if there is no timeout.
		/// </remarks>		<short>    The notification will automatically be closed if all presentation are finished.</short>
		/// 		<see> ref</see>
		[Q_SLOT("void ref()")]
		public void Ref() {
			interceptor.Invoke("ref", "ref()", typeof(void));
		}
		/// <remarks>
		///  remove a reference made with ref()
		///  the notification may be closed when calling this.
		/// </remarks>		<short>    remove a reference made with ref()  the notification may be closed when calling this.</short>
		/// 		<see> ref</see>
		[Q_SLOT("void deref()")]
		public void Deref() {
			interceptor.Invoke("deref", "deref()", typeof(void));
		}
		/// <remarks>
		///  Emit or re-emit the event.
		/// 	 </remarks>		<short>    Emit or re-emit the event.</short>
		[Q_SLOT("void sendEvent()")]
		public void SendEvent() {
			interceptor.Invoke("sendEvent", "sendEvent()", typeof(void));
		}
		/// <remarks>
		///  reimplemented for internals raison
		/// 	 </remarks>		<short>    reimplemented for internals raison 	 </short>
		[SmokeMethod("eventFilter(QObject*, QEvent*)")]
		protected new virtual bool EventFilter(QObject watched, QEvent arg2) {
			return (bool) interceptor.Invoke("eventFilter##", "eventFilter(QObject*, QEvent*)", typeof(bool), typeof(QObject), watched, typeof(QEvent), arg2);
		}
		~KNotification() {
			interceptor.Invoke("~KNotification", "~KNotification()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KNotification", "~KNotification()", typeof(void));
		}
		/// <remarks>
		///  @brief emit an event
		///  This method creates the KNotification, setting every parameter, and fire the event.
		///  You don't need to call sendEvent
		///  A popup may be displayed or a sound may be played, depending the config.
		///  return a KNotification .  You may use that pointer to connect some signals or slot.
		///  the pointer is automatically deleted when the event is closed.
		///  Make sure you use one of the CloseOnTimeOut or CloseWhenWidgetActivated, if not,
		///  you have to close yourself the notification.
		///  @note the text is shown in a QLabel, you should escape HTML, if needed.
		/// <param> name="eventId" is the name of the event
		/// </param><param> name="text" is the text of the notification to show in the popup.
		/// </param><param> name="pixmap" is a picture which may be shown in the popup.
		/// </param><param> name="widget" is a widget where the notification reports to
		/// </param><param> name="flags" is a bitmask of NotificationFlag
		/// </param><param> name="componentData" used to determine the location of the config file.  by default, kapp is used
		/// 	 </param></remarks>		<short>    @brief emit an event </short>
		public static KNotification Event(string eventId, string text, QPixmap pixmap, QWidget widget) {
			return (KNotification) staticInterceptor.Invoke("event$$##", "event(const QString&, const QString&, const QPixmap&, QWidget*)", typeof(KNotification), typeof(string), eventId, typeof(string), text, typeof(QPixmap), pixmap, typeof(QWidget), widget);
		}
		public static KNotification Event(string eventId, string text, QPixmap pixmap) {
			return (KNotification) staticInterceptor.Invoke("event$$#", "event(const QString&, const QString&, const QPixmap&)", typeof(KNotification), typeof(string), eventId, typeof(string), text, typeof(QPixmap), pixmap);
		}
		public static KNotification Event(string eventId, string text) {
			return (KNotification) staticInterceptor.Invoke("event$$", "event(const QString&, const QString&)", typeof(KNotification), typeof(string), eventId, typeof(string), text);
		}
		public static KNotification Event(string eventId) {
			return (KNotification) staticInterceptor.Invoke("event$", "event(const QString&)", typeof(KNotification), typeof(string), eventId);
		}
		/// <remarks>
		///  @brief emit standard an event
		///  @overload
		///  This will emit a standard event
		/// <param> name="eventId" is the name of the event
		/// </param><param> name="text" is the text of the notification to show in the popup.
		/// </param><param> name="pixmap" is a picture which may be shown in the popup.
		/// </param><param> name="widget" is a widget where the notification reports to
		/// </param><param> name="flags" is a bitmask of NotificationFlag 
		/// 	 </param></remarks>		<short>    @brief emit standard an event  @overload </short>
		public static KNotification Event(KNotification.StandardEvent eventId, string text, QPixmap pixmap, QWidget widget) {
			return (KNotification) staticInterceptor.Invoke("event$$##", "event(KNotification::StandardEvent, const QString&, const QPixmap&, QWidget*)", typeof(KNotification), typeof(KNotification.StandardEvent), eventId, typeof(string), text, typeof(QPixmap), pixmap, typeof(QWidget), widget);
		}
		public static KNotification Event(KNotification.StandardEvent eventId, string text, QPixmap pixmap) {
			return (KNotification) staticInterceptor.Invoke("event$$#", "event(KNotification::StandardEvent, const QString&, const QPixmap&)", typeof(KNotification), typeof(KNotification.StandardEvent), eventId, typeof(string), text, typeof(QPixmap), pixmap);
		}
		public static KNotification Event(KNotification.StandardEvent eventId, string text) {
			return (KNotification) staticInterceptor.Invoke("event$$", "event(KNotification::StandardEvent, const QString&)", typeof(KNotification), typeof(KNotification.StandardEvent), eventId, typeof(string), text);
		}
		public static KNotification Event(KNotification.StandardEvent eventId) {
			return (KNotification) staticInterceptor.Invoke("event$", "event(KNotification::StandardEvent)", typeof(KNotification), typeof(KNotification.StandardEvent), eventId);
		}
		/// <remarks>
		///  This is a simple substitution for QApplication.Beep()
		/// <param> name="reason" a small text explaining what's happen (may be null)
		/// </param><param> name="widget" the widget where the notification refer to 
		/// 	 </param></remarks>		<short>    This is a simple substitution for QApplication.Beep() </short>
		public static void Beep(string reason, QWidget widget) {
			staticInterceptor.Invoke("beep$#", "beep(const QString&, QWidget*)", typeof(void), typeof(string), reason, typeof(QWidget), widget);
		}
		public static void Beep(string reason) {
			staticInterceptor.Invoke("beep$", "beep(const QString&)", typeof(void), typeof(string), reason);
		}
		public static void Beep() {
			staticInterceptor.Invoke("beep", "beep()", typeof(void));
		}
		protected new IKNotificationSignals Emit {
			get { return (IKNotificationSignals) Q_EMIT; }
		}
	}

	public interface IKNotificationSignals : IQObjectSignals {
		/// <remarks>
		///  Emit only when the default activation has occurred
		/// 	 </remarks>		<short>    Emit only when the default activation has occurred 	 </short>
		[Q_SIGNAL("void activated()")]
		void Activated();
		/// <remarks>
		///  Emit when an action has been activated.
		/// <param> name="action" will be 0 is the default aciton was activated, or any actiton id
		/// 	 </param></remarks>		<short>    Emit when an action has been activated.</short>
		[Q_SIGNAL("void activated(unsigned int)")]
		void Activated(uint action);
		/// <remarks>
		///  Convenance signal that is emitted when the first action is activated.
		///      </remarks>		<short>    Convenance signal that is emitted when the first action is activated.</short>
		[Q_SIGNAL("void action1Activated()")]
		void Action1Activated();
		/// <remarks>
		///  \overload
		///      </remarks>		<short>    \overload      </short>
		[Q_SIGNAL("void action2Activated()")]
		void Action2Activated();
		/// <remarks>
		///  \overload
		///      </remarks>		<short>    \overload      </short>
		[Q_SIGNAL("void action3Activated()")]
		void Action3Activated();
		/// <remarks>
		///  Emit when the notification is closed. Both if it's activated or just ignored
		/// 	 </remarks>		<short>    Emit when the notification is closed.</short>
		[Q_SIGNAL("void closed()")]
		void Closed();
		/// <remarks>
		///  The notification has been ignored
		/// 	 </remarks>		<short>    The notification has been ignored 	 </short>
		[Q_SIGNAL("void ignored()")]
		void Ignored();
	}
}
