//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;

	/// <remarks>
	///  Base class representing a source of time zone information.
	///  Derive subclasses from KTimeZoneSource to read and parse time zone details
	///  from a time zone database or other source of time zone information. If can know
	///  in advance what KTimeZone instances to create without having to parse the source
	///  data, you should reimplement the method parse(KTimeZone). Otherwise,
	///  you need to define your own parse() methods with appropriate signatures, to both
	///  read and parse the new data, and create new KTimeZone instances.
	///  KTimeZoneSource itself may be used as a dummy source which returns empty
	///  time zone details.
	/// </remarks>		<author> S.R.Haque <srhaque@iee.org>.
	///  </author>
	/// 		<short> Base class representing a source of time zone information.</short>
	/// 		<see> KTimeZone</see>
	/// 		<see> KTimeZoneData</see>
	/// 		<see> @ingroup</see>
	/// 		<see> timezones</see>

	[SmokeClass("KTimeZoneSource")]
	public class KTimeZoneSource : Object, IDisposable {
		protected SmokeInvocation interceptor = null;
		private IntPtr smokeObject;
		protected KTimeZoneSource(Type dummy) {}
		protected void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KTimeZoneSource), this);
		}
		public KTimeZoneSource() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KTimeZoneSource", "KTimeZoneSource()", typeof(void));
		}
		/// <remarks>
		///  Extracts detail information for one time zone from the source database.
		///  In this base class, the method always succeeds and returns an empty data
		///  instance. Derived classes should reimplement this method to return an
		///  appropriate data class derived from KTimeZoneData.
		/// <param> name="zone" the time zone for which data is to be extracted.
		/// </param></remarks>		<return> an instance of a class derived from KTimeZoneData containing
		///          the parsed data. The caller is responsible for deleting the
		///          KTimeZoneData instance.
		///          Null is returned on error.
		///      </return>
		/// 		<short>    Extracts detail information for one time zone from the source database.</short>
		[SmokeMethod("parse(const KTimeZone&) const")]
		public virtual KTimeZoneData Parse(KTimeZone zone) {
			return (KTimeZoneData) interceptor.Invoke("parse#", "parse(const KTimeZone&) const", typeof(KTimeZoneData), typeof(KTimeZone), zone);
		}
		~KTimeZoneSource() {
			interceptor.Invoke("~KTimeZoneSource", "~KTimeZoneSource()", typeof(void));
		}
		public void Dispose() {
			interceptor.Invoke("~KTimeZoneSource", "~KTimeZoneSource()", typeof(void));
		}
	}
}
