import org.kde.qt.*;

public class LCDRange extends QWidget {
	private QSlider slider;
	private QLabel label;
	
	public LCDRange(QWidget parent, String name) {
		super(parent, name);
		init();
	}
	
	public LCDRange(String s, QWidget parent, String name) {
		super(parent, name);
		init();
		setText(s);
	}

	private void init() {
		QLCDNumber lcd = new QLCDNumber(2, this, "lcd");
		slider = new QSlider(Horizontal, this, "slider");
		slider.setRange(0, 99);
		slider.setValue(0);

		label = new QLabel(" ", this, "label", 0);
		label.setAlignment(AlignCenter);
		
		connect(slider, SIGNAL("valueChanged(int)"),
						lcd, SLOT("display(int)"));
		connect(slider, SIGNAL("valueChanged(int)"),
						SIGNAL("valueChanged(int)"));

		setFocusProxy(slider);

		QVBoxLayout l = new QVBoxLayout(this);
		l.addWidget(lcd, 1);
		l.addWidget(slider);
		l.addWidget(label);
	}

	public int value() {
		return slider.value();
	}

	public void setValue(int value) {
		slider.setValue(value);
	}

	public void setRange(int minVal, int maxVal) {
		if (minVal < 0 || maxVal > 99 || minVal > maxVal) {
			qWarning("LCDRange::setRange("+minVal+","+maxVal+")\n"+
							 "\tRange must be 0..99\n"+
							 "\tand minVal must not be greater than maxVal");
			return;
		}
		slider.setRange(minVal, maxVal);
	}

	public void setText(String s) {
		label.setText(s);
	}
}
