import sys
sys.path.append ("./uimodules")

from qt import QSplitter, QWidgetStack, QWidget, QListViewItem, SIGNAL, QCString , QScrollView, QRect, Qt

from kdecore import KApplication, KCmdLineArgs, KAboutData
from kdeui import KMainWindow, KListView

from uidialogs import *
from uiwidgets import *
from uimenus import *
from uixml import *
from uimisc import *

False = 0
True  = not False

listItems = {"Dialogs":
                {"KAboutDialog": ["KAboutApplication", "KAboutContainer", "KImageTrackLabel",\
                                  "KAboutContainerBase", "KAboutContributor", "KAboutWidget"],\
                "KAboutKDE": [],\
                "KBugReport": [],\
                "KColorDialog": [],\
                "KDialog": [],\
                "KDialogBase": ["KDialogBaseButton", "KDialogBase::SButton", "KDialogBaseTile"],\
                "KFontDialog": [],\
                "KKeyDialog": [],\
                "KLineEditDlg": [],\
                "KMessageBox": [],\
                "KPasswordDialog": [],\
                "KWizard": []},\
            "Widgets":
                {"KAnimWidget": [],\
                 "KAuthIcon": ["KRootPermsIcon", "KWritePermsIcon"],\
                 "KButtonBox": [],\
                 "KCharSelect": ["KCharSelectTable"],\
                 "KColorButton": [],\
                 "KColorCells": [],\
                 "KColorCombo": [],\
                 "KColorPatch": [],\
                 "KComboBox": [],\
                 "KCompletionBox": [],\
                 "KContainerLayout": ["KContainerLayout::KContainerLayoutItem"],\
                 "KCursor": [],\
                 "KDatePicker": ["KDateInternalMonthPicker", "KDateInternalYearSelector"],\
                 "KDateTable": [],\
                 "KDualColorButton": [],\
                 "KEdit": ["KEdFind", "KEdGotoLine", "KEdReplace"],\
                 "KEditListBox": [],\
                 "KFontChooser": [],\
                 "KHSSelector": [],\
                 "KIconView": [],\
                 "KJanusWidget": ["KJanusWidget::IconListBox"],\
                 "KKeyChooser": [],\
                 "KLed": [],\
                 "KLineEdit": [],\
                 "KListBox": [],\
                 "KListView": [],\
                 "KNumInput": ["KDoubleNumInput", "KIntNumInput"],\
                 "KPaletteTable": [],\
                 "KPasswordEdit": [],\
                 "KProgress": [],\
                 "KRootPixmap": [],\
                 "KMainWindow": [],\
                 "KRestrictedLine": [],\
                 "KRuler": [],\
                 "KSelector": ["KGradientSelector", "KValueSelector", "KHSSelector", "KXYSelector"],\
                 "KSeparator": [],\
                 "KSqueezedTextLabel": [],\
                 "KTabCtl": [],\
                 "KTextBrowser": [],\
                 "KURLLabel": []},\
            "XML":
                {"KActionCollection": [],\
                 "KEditToolbar": [],\
                 "KEditToolbarWidget": [],\
                 "KXMLGUIBuilder": [],\
                 "KXMLGUIClient": ["KXMLGUIClient::DocStruct"],\
                 "KXMLGUIFactory": []},\
            "Menus/Toolbars":
                {"KAccelMenu": [],\
                 "KAction": ["KFontAction", "KFontSizeAction", "KListAction", "KRecentFilesAction", "KRadioAction",\
                             "KSelectAction", "KToggleAction"],\
                 "KActionMenu": [],\
                 "KActionSeparator": [],\
                 "KContextMenuManager": [],\
                 "KDCOPActionProxy": [],\
                 "KHelpMenu": [],\
                 "KMenuBar": [],\
                 "KPanelApplet": [],\
                 "KPanelExtension": [],\
                 "KPanelMenu": [],\
                 "KPopupFrame": [],\
                 "KPopupMenu": [],\
                 "KPopupTitle": [],\
                 "KStatusBar": [],\
                 "KStatusBarLabel": [],\
                 "KStdAction": [],\
                 "KToolBar": ["KToolBarButton", "KToolBarButtonList", "KToolBarPopupAction",\
                              "KToolBarRadioGroup", "KToolBarSeparator"],\
                 "KWindowListMenu": []},\
            "Other":
                {"KAlphaPainter": [],\
                 "KCModule": [],\
                 "KColor": [],\
                 "KColorDrag": [],\
                 "KCommand": ["KMacroCommand"],\
                 "KCommandHistory": [],\
                 "KDateValidator": [],\
                 "KDockWindow": ["KDockButton_Private - KPanelMenu", "KDockButton_Private",\
                                 "KDockSplitter", "KDockTabCtl_PrivateStruct", "KDockWidgetAbstractHeader",\
                                 "KDockWidgetAbstractHeaderDrag", "KDockWidgetHeader",\
                                 "KDockWidgetHeaderDrag", "KDockWidgetPrivate"],\
                 "KFloatValidator": [],\
                 "KIntValidator": [],\
                 "KPixmapIO": [],\
                 "KSharedPixmap": [],\
                 "KSystemTray": [],\
                 "KThemeBase": ["KThemeCache", "KThemePixmap", "KThemeStyle"],\
                 "QXEmbed": []}}

prefix = {"Dialogs": "dlg", "Widgets": "wid", "XML": "xml", "Menus/Toolbars": "menu", "Other": "misc"}

# The following leave about 375 x 390 for the rt hand panel
mainGeom  = QRect (0, 0, 640, 500)
treeWidth = 220

blankMsg = """ UISampler - provides examples of PyKDE widgets

Select a dialog/widget/menu/etc example from the tree at left
"""


class MainWin (KMainWindow):
    def __init__ (self, *args):
        apply (KMainWindow.__init__, (self,) + args)

        self.setCaption ("Samples of PyKDE widget usage")
        self.setGeometry (mainGeom)

        # create the main view - list view on the left and an
        # area to display frames on the right
        self.mainView  = QSplitter (self, "main view")
        self.tree      = KListView (self.mainView, "tree")
        self.page      = QWidgetStack (self.mainView, "page")
        self.blankPage = QWidget (self.page, "blank")
        self.blankPage.setGeometry (0, 0, 375, 390)
        self.blankPage.setBackgroundMode (QWidget.PaletteBase)

        blankLbl = QLabel (blankMsg, self.blankPage)
        blankLbl.setGeometry (40, 10, 380, 150)
        blankLbl.setBackgroundMode (QWidget.PaletteBase)

        blankPM = QPixmap ("pytestimage.png")
        pmLbl   = QLabel ("", self.blankPage)
        pmLbl.setPixmap (blankPM)
        pmLbl.setGeometry (40, 160, 300, 200)
        pmLbl.setBackgroundMode (QWidget.PaletteBase)

        self.page.addWidget (self.blankPage, 1)
        self.page.raiseWidget (1)

        self.setCentralWidget (self.mainView)

        self.initListView ()
        self.connect (self.tree, SIGNAL ("clicked (QListViewItem *)"), self.lvClicked)

        self.edit = None
        self.currentPageObj = None

    def initListView (self):
        self.tree.addColumn ("Category", treeWidth - 21)
#        self.tree.setMaximumWidth (treeWidth)
        self.mainView.setSizes ([treeWidth, 375])
        self.tree.setRootIsDecorated (True)
        self.tree.setVScrollBarMode (QScrollView.AlwaysOn)
        topLevel = listItems.keys ()
        for item_1 in topLevel:
            parent = QListViewItem (self.tree, item_1)
            secondLevel = listItems [item_1].keys ()
            for item_2 in secondLevel:
                child = QListViewItem (parent, item_2)
                for item_3 in listItems [item_1][item_2]:
                    QListViewItem (child, item_3)

    def lvClicked (self, lvItem):
        if not lvItem:
            return

        if lvItem.text (0).latin1 () in listItems.keys ():
            return

        p = lvItem.parent ()
        if p.text (0).latin1 () in listItems.keys ():
            pfx = prefix [p.text (0).latin1 ()]
            funcCall = pfx + lvItem.text (0).latin1 () + "(self)"
        else:
            pfx = prefix [p.parent ().text (0).latin1 ()]
            funcCall = pfx + lvItem.parent ().text (0).latin1 () + "(self)"

        eval (funcCall)

    def addPage (self):
        self.edit = None
        self.currentPageObj = None
        current = self.page.widget (2)
        if current:
            self.page.removeWidget (current)
            del current

        newPage = QWidget (self.page)
        newPage.setGeometry (0, 0, 375, 390)
#        newPage.setBackgroundMode (QWidget.PaletteBase)
        self.page.addWidget (newPage, 2)
        self.page.raiseWidget (2)

        return newPage


#-------------------- main ------------------------------------------------

appName = "UISampler"
app = KApplication (sys.argv, appName)
mainWindow = MainWin (None, "main window")
mainWindow.show()
app.exec_loop()

