#!/usr/bin/env kjscmd

// Demo that creates a tree from a ui file using QHBox and QBox.

function create_item( node, parent )
{
  var l = new QLabel( parent );
  l.paletteBackgroundColor = '#aaaaee';
  l.frameShape = 1;
  l.frameWidth = 1;
  l.alignment = 0x44;

  l.text = node.name;
  return l;
}

function create_subtree_layout( parent )
{
  var vb = new QVBox( parent );
  vb.margin = 12;

  return vb;
}

function create_child_layout( parent )
{
  var hb = new QHBox( parent );
  hb.margin = 6;

  return hb;
}

function create_tree( node, parent )
{
  var outer = create_subtree_layout( parent );

  create_item( node, outer );

  var inner = create_child_layout( outer );

  for ( var i = 0 ; i < node.childCount() ; i++ ) {
    var child = node.child(i);
    if ( child.isWidgetType() )
       create_tree( child, inner );
  }

  return outer;
}

var ui = Factory.loadui( 'treetest.ui' );
var top = new QHBox();
create_tree( ui, top );

top.show();


