# This is part of the dragdrop example.


from qt import *

import secret


class DropSite(QLabel):
    def __init__(self, parent=None, name=None):
        QLabel.__init__( self, parent, name )
        self.setAcceptDrops(1)

    # this is a normal event
    def mousePressEvent( self, e ):
        if ( self.pixmap() ) :
            drobj = QImageDrag( self.pixmap().convertToImage(), self )
            pm = QPixmap()
            pm.convertFromImage(self.pixmap().convertToImage().smoothScale(
                self.pixmap().width()/3,self.pixmap().height()/3))
            drobj.setPixmap(pm,QPoint(-5,-7))
        else :
            drobj = QTextDrag( self.text(), self )
        drobj.dragCopy()

    def backgroundColorChange( self, qcolor ):
        # Reduce flicker by using repaint() rather than update()
        self.repaint()

    def dragMoveEvent( self, e ):
        # Check if you want the drag at e.pos()...
        # Give the user some feedback...
        pass

    def dragEnterEvent( self, e ):
        # Check if you want the drag...
        if (secret.canDecode( e ) or
            QTextDrag.canDecode( e ) or 
            QImageDrag.canDecode( e ) or
            QUriDrag.canDecode( e )):
            e.accept()

        # Give the user some feedback...
        t = ''
        i = 0
        while e.format( i ):
            if ( t != '' ):
                t += "\n"
            t += str(e.format( i ))
            i += 1
        self.emit(PYSIGNAL('message(QString &)'), (QString(t),))
        self.setBackgroundColor(Qt.white)

    def dragLeaveEvent( self, QDragLeaveEvent ):
        # Give the user some feedback...
        self.emit(PYSIGNAL('message(QString &)'), (QString(''),))
        self.setBackgroundColor(Qt.lightGray)

    def dropEvent( self, e ):
        self.setBackgroundColor(Qt.lightGray)
        # Try to decode to the data you understand...
        str = QString()
        if ( QTextDrag.decode( e, str ) ) :
            self.setText( str )
            self.setMinimumSize( self.minimumSize().expandedTo(self.sizeHint()) )
            return

        pm = QPixmap()
        if ( QImageDrag.decode( e, pm ) ) :
            self.setPixmap( pm )
            self.setMinimumSize(self.minimumSize().expandedTo(self.sizeHint()))
            return

        # QStrList strings
        #strings = QStrList()
        strings = []
        if ( QUriDrag.decode( e, strings ) ) :
            m = QString("Full URLs:\n")
            for u in strings:
                m = m + "   " + u + '\n'
            # QStringList files
            files = []
            if ( QUriDrag.decodeLocalFiles( e, files ) ) :
                m += "Files:\n"
                # for (QStringList.Iterator i=files.begin() i!=files.end() ++i)
                for i in files:
                    m = m + "   " + i + '\n'
            self.setText( m )
            self.setMinimumSize(self.minimumSize().expandedTo(self.sizeHint()))
            return

        str = secret.decode( e ) 
        if str:
            self.setText( str )
            self.setMinimumSize(self.minimumSize().expandedTo(self.sizeHint()))
            return
