//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \brief Session config interface extension for the Document, View and Plugin.
    ///  \ingroup kte_group_doc_extensions
    ///  \ingroup kte_group_view_extensions
    ///  \ingroup kte_group_plugin_extensions
    ///  \section sessionconfig_intro Introduction
    ///  The SessionConfigInterface is an extension for Documents, Views and Plugins
    ///  to add support for session-specific configuration settings.
    ///  readSessionConfig() is called whenever session-specific settings are to be
    ///  read from the given KConfig and writeSessionConfig() whenever they are to
    ///  be written, for example when a session changed or was closed.
    ///  <b>Note:<> A \e session does not have anything to do with an X-session under Unix.
    ///        What is meant is rather a context, think of sessions in Kate or
    ///        projects in KDevelop for example.
    ///  \section sessionconfig_support Adding Session Support
    ///  To add support for sessions a KTextEditor implementation has to derive the
    ///  Document and View class from SessionConfigInterface and reimplement
    ///  readSessionConfig() and writeSessionConfig().
    ///  The same applies to a Plugin, read the detailed description for plugins.
    ///  \section sessionconfig_access Accessing the SessionConfigInterface
    ///  The SessionConfigInterface is supposed to be an extension interface for a
    ///  Document, a View or a Plugin, i.e. the Document/View/Plugin inherits the
    ///  interface \e provided that it implements the interface. Use qobject_cast to
    ///  access the interface:
    ///  <pre>
    ///  // object is of type KTextEditor.Document or View or Plugin
    ///  KTextEditor.SessionConfigInterface iface =
    ///      qobject_cast<KTextEditor.SessionConfigInterface>( object );
    ///  if( iface ) {
    ///      // interface is supported
    ///      // do stuff
    ///  }
    ///  </pre>
    ///  \see KTextEditor.Document, KTextEditor.View, KTextEditor.Plugin
    ///  \author Christoph Cullmann \<cullmann@kde.org\>
    ///  </remarks>        <short>    \brief Session config interface extension for the Document, View and Plugin.</short>
    [SmokeClass("KTextEditor::SessionConfigInterface")]
    public class SessionConfigInterface : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected SessionConfigInterface(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(SessionConfigInterface), this);
        }
        public SessionConfigInterface() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("SessionConfigInterface", "SessionConfigInterface()", typeof(void));
        }
        /// <remarks>
        ///  Read session settings from the given <pre>config</pre>.
        ///  That means for example
        ///   - a Document should reload the file, restore all marks etc...
        ///   - a View should scroll to the last position and restore the cursor
        ///     position etc...
        ///   - a Plugin should restore session specific settings
        ///   - If no file is being loaded, because an empty new document is going to be displayed,
        ///     this function should emit ReadOnlyPart.Completed
        ///  \param config read the session settings from this KConfigGroup
        ///  \see writeSessionConfig()
        ///      </remarks>        <short>    Read session settings from the given \p config.</short>
        [SmokeMethod("readSessionConfig(const KConfigGroup&)")]
        public virtual void ReadSessionConfig(KConfigGroup config) {
            interceptor.Invoke("readSessionConfig#", "readSessionConfig(const KConfigGroup&)", typeof(void), typeof(KConfigGroup), config);
        }
        /// <remarks>
        ///  Write session settings to the <pre>config</pre>.
        ///  See readSessionConfig() for more details.
        ///  \param config write the session settings to this KConfigGroup
        ///  \see readSessionConfig()
        ///      </remarks>        <short>    Write session settings to the \p config.</short>
        [SmokeMethod("writeSessionConfig(KConfigGroup&)")]
        public virtual void WriteSessionConfig(KConfigGroup config) {
            interceptor.Invoke("writeSessionConfig#", "writeSessionConfig(KConfigGroup&)", typeof(void), typeof(KConfigGroup), config);
        }
        ~SessionConfigInterface() {
            interceptor.Invoke("~SessionConfigInterface", "~SessionConfigInterface()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~SessionConfigInterface", "~SessionConfigInterface()", typeof(void));
        }
    }
}
