//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \brief Extension interface for a Command.
    ///  \ingroup kte_group_command_extensions
    ///  \section cmdext_intro Introduction
    ///  The CommandExtension extends the Command interface allowing to interact
    ///  with commands during typing. This allows for completion and for example
    ///  the isearch plugin. If you develop a command that wants to complete or
    ///  process text as the user types the arguments, or that has flags, you can
    ///  have your command inherit this class.
    ///  If your command supports flags return them by reimplementing
    ///  flagCompletions(). You can return your own KCompletion object if the
    ///  command has available completion data. If you want to interactively react
    ///  on changes return \e true in wantsToProcessText() for the given command
    ///  and reimplement processText().
    ///  \see KTextEditor.CommandInterface, KTextEditor.Command, KCompletion
    ///  \author Christoph Cullmann \<cullmann@kde.org\>
    ///  </remarks>        <short>    \brief Extension interface for a Command.</short>
    [SmokeClass("KTextEditor::CommandExtension")]
    public class CommandExtension : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected CommandExtension(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(CommandExtension), this);
        }
        /// <remarks>
        ///  Fill in a <pre>list</pre> of flags to complete from. Each flag is a single
        ///  letter, any following text in the string is taken to be a description
        ///  of the flag's meaning, and showed to the user as a hint.
        ///  Implement this method if your command has flags.
        ///  This method is called each time the flag string in the typed command
        ///  is changed, so that the available flags can be adjusted. When
        ///  completions are displayed, existing flags are left out.
        ///  \param list flag list
        ///      </remarks>        <short>    Fill in a \p list of flags to complete from.</short>
        [SmokeMethod("flagCompletions(QStringList&)")]
        public virtual void FlagCompletions(List<string> list) {
            interceptor.Invoke("flagCompletions?", "flagCompletions(QStringList&)", typeof(void), typeof(List<string>), list);
        }
        /// <remarks>
        ///  Return a KCompletion object that will substitute the command line
        ///  default one while typing the first argument of the command <pre>cmdname</pre>.
        ///  The text will be added to the command separated by one space character.
        ///  Implement this method if your command can provide a completion object.
        ///  \param view the view the command will work on
        ///  \param cmdname the command name associated with this request.
        ///  \return the completion object or NULL, if you do not support a
        ///          completion object
        ///      </remarks>        <short>    Return a KCompletion object that will substitute the command line  default one while typing the first argument of the command \p cmdname.</short>
        [SmokeMethod("completionObject(KTextEditor::View*, const QString&)")]
        public virtual KCompletion CompletionObject(KTextEditor.View view, string cmdname) {
            return (KCompletion) interceptor.Invoke("completionObject#$", "completionObject(KTextEditor::View*, const QString&)", typeof(KCompletion), typeof(KTextEditor.View), view, typeof(string), cmdname);
        }
        /// <remarks>
        ///  Check, whether the command wants to process text interactively for the
        ///  given command with name <pre>cmdname</pre>.
        ///  If you return true, the command's processText() method is called
        ///  whenever the text in the command line changed.
        ///  Reimplement this to return true, if your commands wants to process the
        ///  text while typing.
        ///  \param cmdname the command name associated with this query.
        ///  \return \e true, if your command wants to process text interactively,
        ///          otherwise \e false
        ///  \see processText()
        ///      </remarks>        <short>    Check, whether the command wants to process text interactively for the  given command with name \p cmdname.</short>
        [SmokeMethod("wantsToProcessText(const QString&)")]
        public virtual bool WantsToProcessText(string cmdname) {
            return (bool) interceptor.Invoke("wantsToProcessText$", "wantsToProcessText(const QString&)", typeof(bool), typeof(string), cmdname);
        }
        /// <remarks>
        ///  This is called by the command line each time the argument text for the
        ///  command changed, if wantsToProcessText() returns \e true.
        ///  \param view the current view
        ///  \param text the current command text typed by the user
        ///  \see wantsToProcessText()
        ///      </remarks>        <short>    This is called by the command line each time the argument text for the  command changed, if wantsToProcessText() returns \e true.</short>
        [SmokeMethod("processText(KTextEditor::View*, const QString&)")]
        public virtual void ProcessText(KTextEditor.View view, string text) {
            interceptor.Invoke("processText#$", "processText(KTextEditor::View*, const QString&)", typeof(void), typeof(KTextEditor.View), view, typeof(string), text);
        }
        public CommandExtension() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CommandExtension", "CommandExtension()", typeof(void));
        }
        ~CommandExtension() {
            interceptor.Invoke("~CommandExtension", "~CommandExtension()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~CommandExtension", "~CommandExtension()", typeof(void));
        }
    }
}
