//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  This is one of the most central classes in kdelibs as
    ///  it provides a basic service: It knows where the files
    ///  reside on the user's hard disk. And it's meant to be the
    ///  only one that knows -- to make the real location as
    ///  transparent as possible to both the user and the applications.
    ///  To this end it insulates the application from all information
    ///  and applications always refer to a file with a resource type
    ///  (e.g. icon) and a filename (e.g. <tt>khexdit.xpm</tt>). In an ideal world
    ///  the application would make no assumption where this file is and
    ///  leave it up to KStandardDirs.FindResource("apps", "Home.desktop")
    ///  to apply this knowledge to return <tt>/opt/kde/share/applnk/Home.desktop</tt>
    ///  or .Locate("data", "kgame/background.jpg") to return
    ///  <tt>/opt/kde/share/apps/kgame/background.jpg</tt>
    ///  The main idea behind KStandardDirs is that there are several
    ///  toplevel prefixes below which the files lie. One of these prefixes is
    ///  the one where the user installed kdelibs, one is where the
    ///  application was installed, and one is <tt>$HOME/.kde</tt>, but there
    ///  may be even more. Under these prefixes there are several well
    ///  defined suffixes where specific resource types are to be found.
    ///  For example, for the resource type @c "html" the suffixes could be
    ///  <code>share</code>/doc/HTML and <code>share</code>/doc/kde/HTML.
    ///  So the search algorithm basically appends to each prefix each registered
    ///  suffix and tries to locate the file there.
    ///  To make the thing even more complex, it's also possible to register
    ///  absolute paths that KStandardDirs looks up after not finding anything
    ///  in the former steps. They can be useful if the user wants to provide
    ///  specific directories that aren't in his <tt>$HOME/.kde</tt> directory for,
    ///  for example, icons.
    ///  <li><b>Standard resources that kdelibs allocates are:</b></li>
    /// 
    /// <li>
    /// <code>apps</code> - Applications menu (.desktop files).
    /// </li>
    /// 
    /// <li>
    /// <code>cache</code> - Cached information (e.g. favicons, web-pages)
    /// </li>
    /// 
    /// <li>
    /// <code>cgi</code> - CGIs to run from kdehelp.
    /// </li>
    /// 
    /// <li>
    /// <code>config</code> - Configuration files.
    /// </li>
    /// 
    /// <li>
    /// <code>data</code> - Where applications store data.
    /// </li>
    /// 
    /// <li>
    /// <code>emoticons</code> - Emoticons themes
    /// </li>
    /// 
    /// <li>
    /// <code>exe</code> - Executables in $prefix/bin. findExe() for a function that takes $PATH into account.
    /// </li>
    /// 
    /// <li>
    /// <code>html</code> - HTML documentation.
    /// </li>
    /// 
    /// <li>
    /// <code>icon</code> - Icons, see KIconLoader.
    /// </li>
    /// 
    /// <li>
    /// <code>kcfg</code> - KConfigXT config files.
    /// </li>
    /// 
    /// <li>
    /// <code>lib</code> - Libraries.
    /// </li>
    /// 
    /// <li>
    /// <code>locale</code> - Translation files for KLocale.
    /// </li>
    /// 
    /// <li>
    /// <code>mime</code> - Mime types defined by KDE-specific .desktop files.
    /// </li>
    /// 
    /// <li>
    /// <code>module</code> - Module (dynamically loaded library).
    /// </li>
    /// 
    /// <li>
    /// <code>qtplugins</code> - Qt plugins (dynamically loaded objects for Qt)
    /// </li>
    /// 
    /// <li>
    /// <code>services</code> - Services.
    /// </li>
    /// 
    /// <li>
    /// <code>servicetypes</code> - Service types.
    /// </li>
    /// 
    /// <li>
    /// <code>sound</code> - Application sounds.
    /// </li>
    /// 
    /// <li>
    /// <code>templates</code> - Templates for the "Create new file" functionality.
    /// </li>
    /// 
    /// <li>
    /// <code>wallpaper</code> - Wallpapers.
    /// </li>
    /// 
    /// <li>
    /// <code>tmp</code> - Temporary files (specific for both current host and current user)
    /// </li>
    /// 
    /// <li>
    /// <code>socket</code> - UNIX Sockets (specific for both current host and current user)
    /// </li>
    /// 
    /// <li>
    /// <code>xdgconf</code>-menu - Freedesktop.org standard location for menu layout (.menu) files.
    /// </li>
    /// 
    /// <li>
    /// <code>xdgdata</code>-apps - Freedesktop.org standard location for application desktop files.
    /// </li>
    /// 
    /// <li>
    /// <code>xdgdata</code>-dirs - Freedesktop.org standard location for menu descriptions (.directory files).
    /// </li>
    /// 
    /// <li>
    /// <code>xdgdata</code>-mime - Freedesktop.org standard location for MIME type definitions.
    /// </li>
    /// 
    /// <li>
    /// <code>xdgdata</code>-icon - Freedesktop.org standard location for icons.
    /// </li>
    /// 
    /// <li>
    /// <code>xdgdata</code>-pixmap - Gnome-compatibility location for pixmaps.
    /// </li>
    ///  A type that is added by the class KApplication if you use it, is
    ///  <code>appdata.</code> This one makes the use of the type data a bit easier as it
    ///  appends the name of the application.
    ///  So while you had to .Locate("data", "appname/filename") so you can
    ///  also write .Locate("appdata", "filename") if your KApplication instance
    ///  is called @c "appname" (as set via KApplication's constructor or KAboutData, if
    ///  you use the global KStandardDirs object KGlobal.Dirs()).
    ///  Please note though that you cannot use the @c "appdata"
    ///  type if you intend to use it in an applet for Kicker because 'appname' would
    ///  be @c "Kicker" instead of the applet's name. Therefore, for applets, you've got
    ///  to work around this by using .Locate("data", "appletname/filename").
    ///  <b>KStandardDirs supports the following environment variables:</b>
    /// 
    /// <li>
    /// <code>KDEDIRS</code> - This may set an additional number of directory prefixes to
    ///           search for resources. The directories should be separated
    ///           by <tt>':'</tt>. The directories are searched in the order they are
    ///           specified.
    /// </li>
    /// 
    /// <li>
    /// <code>KDEHOME</code> - The directory where changes are saved to. This directory is
    ///           used to search for resources first. If <code>KDEHOME</code> is not
    ///           specified it defaults to @c "$HOME/.kde"
    /// </li>
    /// 
    /// <li>
    /// <code>KDEROOTHOME</code> - Like KDEHOME, but used for the root user.
    ///           If <code>KDEROOTHOME</code> is not set it defaults to the <tt>.kde</tt> directory in the
    ///           home directory of root, usually @c "/root/.kde".
    ///           Note that the setting of @c $HOME is ignored in this case.
    /// </li>
    ///  On The Usage Of 'locate' and 'locateLocal'
    ///  Typical KDE applications use resource files in one out of
    ///  three ways:
    ///  1) A resource file is read but is never written. A system
    ///     default is supplied but the user can override this
    ///     default in his local .kde directory:
    ///     @code
    ///     // Code example
    ///     myFile = KStandardDirs.Locate("appdata", "groups.lst");
    ///     myData =  myReadGroups(myFile); // myFile may be null
    ///     @endcode
    ///  2) A resource file is read and written. If the user has no
    ///     local version of the file the system default is used.
    ///     The resource file is always written to the users local
    ///     .kde directory.
    ///     @code
    ///     // Code example
    ///     myFile = KStandardDirs.Locate("appdata", "groups.lst")
    ///     myData =  myReadGroups(myFile);
    ///     ...
    ///     doSomething(myData);
    ///     ...
    ///     myFile = KStandardDirs.LocateLocal("appdata", "groups.lst");
    ///     myWriteGroups(myFile, myData);
    ///     @endcode
    ///  3) A resource file is read and written. No system default
    ///     is used if the user has no local version of the file.
    ///     The resource file is always written to the users local
    ///     .kde directory.
    ///     @code
    ///     // Code example
    ///     myFile = KStandardDirs.LocateLocal("appdata", "groups.lst");
    ///     myData =  myReadGroups(myFile);
    ///     ...
    ///     doSomething(myData);
    ///     ...
    ///     myFile = KStandardDirs.LocateLocal("appdata", "groups.lst");
    ///     myWriteGroups(myFile, myData);
    ///     @endcode
    /// </remarks>        <author> Stephan Kulow <coolo@kde.org> and Sirtaj Singh Kang <taj@kde.org>
    /// </author>
    ///         <short> Site-independent access to standard KDE directories. </short>
    ///         <see> KGlobalSettings</see>
    [SmokeClass("KStandardDirs")]
    public class KStandardDirs : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected KStandardDirs(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KStandardDirs), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KStandardDirs() {
            staticInterceptor = new SmokeInvocation(typeof(KStandardDirs), null);
        }
        public enum SearchOption {
            NoSearchOptions = 0,
            Recursive = 1,
            NoDuplicates = 2,
            IgnoreExecBit = 4,
        }
        /// <remarks>
        ///  KStandardDirs' constructor. It just initializes the caches.
        /// </remarks>        <short>    KStandardDirs' constructor.</short>
        public KStandardDirs() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KStandardDirs", "KStandardDirs()", typeof(void));
        }
        /// <remarks>
        ///  Adds another search dir to front of the <code>fsstnd</code> list.
        /// 
        /// <li>
        /// When compiling kdelibs, the prefix is added to this.
        /// </li>
        /// 
        /// <li>
        /// <code>KDEDIRS</code> is taken into account
        /// </li>
        /// 
        /// <li>
        /// Additional dirs may be loaded from kdeglobals.
        /// </li>
        /// <param> name="dir" The directory to append relative paths to.
        ///      </param></remarks>        <short>    Adds another search dir to front of the <code>fsstnd</code> list.</short>
        public void AddPrefix(string dir) {
            interceptor.Invoke("addPrefix$", "addPrefix(const QString&)", typeof(void), typeof(string), dir);
        }
        /// <remarks>
        ///  Adds another search dir to front of the <code>XDG_CONFIG_XXX</code> list
        ///  of prefixes.
        ///  This prefix is only used for resources that start with @c "xdgconf-"
        /// <param> name="dir" The directory to append relative paths to.
        ///      </param></remarks>        <short>    Adds another search dir to front of the @c XDG_CONFIG_XXX list  of prefixes.</short>
        public void AddXdgConfigPrefix(string dir) {
            interceptor.Invoke("addXdgConfigPrefix$", "addXdgConfigPrefix(const QString&)", typeof(void), typeof(string), dir);
        }
        /// <remarks>
        ///  Adds another search dir to front of the <code>XDG_DATA_XXX</code> list
        ///  of prefixes.
        ///  This prefix is only used for resources that start with @c "xdgdata-"
        /// <param> name="dir" The directory to append relative paths to.
        ///      </param></remarks>        <short>    Adds another search dir to front of the @c XDG_DATA_XXX list  of prefixes.</short>
        public void AddXdgDataPrefix(string dir) {
            interceptor.Invoke("addXdgDataPrefix$", "addXdgDataPrefix(const QString&)", typeof(void), typeof(string), dir);
        }
        /// <remarks>
        ///  Adds suffixes for types.
        ///  You may add as many as you need, but it is advised that there
        ///  is exactly one to make writing definite.
        ///  All basic types are added by addKDEDefaults(),
        ///  but for those you can add more relative paths as well.
        ///  The later a suffix is added, the higher its priority. Note, that the
        ///  suffix should end with / but doesn't have to start with one (as prefixes
        ///  should end with one). So adding a suffix for app_pics would look
        ///  like KGlobal.Dirs().AddResourceType("app_pics", "data", "app/pics");
        /// <param> name="type" Specifies a short descriptive string to access
        ///  files of this type.
        /// </param><param> name="basetype" Specifies an already known type, or 0 if none
        /// </param><param> name="relativename" Specifies a directory relative to the basetype
        /// </param><param> name="priority" if true, the directory is added before any other,
        ///  otherwise after
        /// </param></remarks>        <return> true if successful, false otherwise.
        ///      </return>
        ///         <short>    Adds suffixes for types.</short>
        public bool AddResourceType(string type, string basetype, string relativename, bool priority) {
            return (bool) interceptor.Invoke("addResourceType$$$$", "addResourceType(const char*, const char*, const QString&, bool)", typeof(bool), typeof(string), type, typeof(string), basetype, typeof(string), relativename, typeof(bool), priority);
        }
        public bool AddResourceType(string type, string basetype, string relativename) {
            return (bool) interceptor.Invoke("addResourceType$$$", "addResourceType(const char*, const char*, const QString&)", typeof(bool), typeof(string), type, typeof(string), basetype, typeof(string), relativename);
        }
        /// <remarks>
        ///  Adds absolute path at the beginning of the search path for
        ///  particular types (for example in case of icons where
        ///  the user specifies extra paths).
        ///  You shouldn't need this
        ///  function in 99% of all cases besides adding user-given
        ///  paths.
        /// <param> name="type" Specifies a short descriptive string to access files
        ///  of this type.
        /// </param><param> name="absdir" Points to directory where to look for this specific
        ///  type. Non-existent directories may be saved but pruned.
        /// </param><param> name="priority" if true, the directory is added before any other,
        ///  otherwise after
        /// </param></remarks>        <return> true if successful, false otherwise.
        ///      </return>
        ///         <short>    Adds absolute path at the beginning of the search path for  particular types (for example in case of icons where  the user specifies extra paths).</short>
        public bool AddResourceDir(string type, string absdir, bool priority) {
            return (bool) interceptor.Invoke("addResourceDir$$$", "addResourceDir(const char*, const QString&, bool)", typeof(bool), typeof(string), type, typeof(string), absdir, typeof(bool), priority);
        }
        public bool AddResourceDir(string type, string absdir) {
            return (bool) interceptor.Invoke("addResourceDir$$", "addResourceDir(const char*, const QString&)", typeof(bool), typeof(string), type, typeof(string), absdir);
        }
        /// <remarks>
        ///  Tries to find a resource in the following order:
        /// 
        /// <li>
        /// All PREFIX/\<relativename> paths (most recent first).
        /// </li>
        /// 
        /// <li>
        /// All absolute paths (most recent first).
        /// </li>
        ///  The filename should be a filename relative to the base dir
        ///  for resources. So is a way to get the path to libkdecore.la
        ///  to findResource("lib", "libkdecore.la"). KStandardDirs will
        ///  then look into the subdir lib of all elements of all prefixes
        ///  ($KDEDIRS) for a file libkdecore.la and return the path to
        ///  the first one it finds (e.g. /opt/kde/lib/libkdecore.la)
        /// <param> name="type" The type of the wanted resource
        /// </param><param> name="filename" A relative filename of the resource.
        /// </param></remarks>        <return> A full path to the filename specified in the second
        ///          argument, or string() if not found.
        ///      </return>
        ///         <short>    Tries to find a resource in the following order: </short>
        public string FindResource(string type, string filename) {
            return (string) interceptor.Invoke("findResource$$", "findResource(const char*, const QString&) const", typeof(string), typeof(string), type, typeof(string), filename);
        }
        /// <remarks>
        ///  Checks whether a resource is restricted as part of the KIOSK
        ///  framework. When a resource is restricted it means that user-
        ///  specific files in the resource are ignored.
        ///  E.g. by restricting the @c "wallpaper" resource, only system-wide
        ///  installed wallpapers will be found by this class. Wallpapers
        ///  installed under the @c $KDEHOME directory will be ignored.
        /// <param> name="type" The type of the resource to check
        /// </param><param> name="relPath" A relative path in the resource.
        /// </param></remarks>        <return> True if the resource is restricted.
        ///      </return>
        ///         <short>    Checks whether a resource is restricted as part of the KIOSK  framework.</short>
        public bool IsRestrictedResource(string type, string relPath) {
            return (bool) interceptor.Invoke("isRestrictedResource$$", "isRestrictedResource(const char*, const QString&) const", typeof(bool), typeof(string), type, typeof(string), relPath);
        }
        public bool IsRestrictedResource(string type) {
            return (bool) interceptor.Invoke("isRestrictedResource$", "isRestrictedResource(const char*) const", typeof(bool), typeof(string), type);
        }
        /// <remarks>
        ///  Returns a number that identifies this version of the resource.
        ///  When a change is made to the resource this number will change.
        /// <param> name="type" The type of the wanted resource
        /// </param><param> name="filename" A relative filename of the resource.
        /// </param><param> name="options" If the flags includes Recursive,
        ///                 all resources are taken into account
        ///                 otherwise only the one returned by findResource().
        /// </param></remarks>        <return> A number identifying the current version of the
        ///           resource.
        ///      </return>
        ///         <short>    Returns a number that identifies this version of the resource.</short>
        public uint CalcResourceHash(string type, string filename, uint options) {
            return (uint) interceptor.Invoke("calcResourceHash$$$", "calcResourceHash(const char*, const QString&, KStandardDirs::SearchOptions) const", typeof(uint), typeof(string), type, typeof(string), filename, typeof(uint), options);
        }
        public uint CalcResourceHash(string type, string filename) {
            return (uint) interceptor.Invoke("calcResourceHash$$", "calcResourceHash(const char*, const QString&) const", typeof(uint), typeof(string), type, typeof(string), filename);
        }
        /// <remarks>
        ///  Tries to find all directories whose names consist of the
        ///  specified type and a relative path. So would
        ///  findDirs("apps", "Settings") return
        /// 
        /// <li>
        /// /opt/kde/share/applnk/Settings/
        /// </li>
        /// 
        /// <li>
        /// /home/joe/.kde/share/applnk/Settings/
        /// </li>
        ///  Note that it appends @c / to the end of the directories,
        ///  so you can use this right away as directory names.
        /// <param> name="type" The type of the base directory.
        /// </param><param> name="reldir" Relative directory.
        /// </param></remarks>        <return> A list of matching directories, or an empty
        ///          list if the resource specified is not found.
        ///      </return>
        ///         <short>    Tries to find all directories whose names consist of the  specified type and a relative path.</short>
        public List<string> FindDirs(string type, string reldir) {
            return (List<string>) interceptor.Invoke("findDirs$$", "findDirs(const char*, const QString&) const", typeof(List<string>), typeof(string), type, typeof(string), reldir);
        }
        /// <remarks>
        ///  Tries to find the directory the file is in.
        ///  It works the same as findResource(), but it doesn't
        ///  return the filename but the name of the directory.
        ///  This way the application can access a couple of files
        ///  that have been installed into the same directory without
        ///  having to look for each file.
        ///  findResourceDir("lib", "libkdecore.la") would return the
        ///  path of the subdir libkdecore.la is found first in
        ///  (e.g. /opt/kde/lib/)
        /// <param> name="type" The type of the wanted resource
        /// </param><param> name="filename" A relative filename of the resource.
        /// </param></remarks>        <return> The directory where the file specified in the second
        ///          argument is located, or string() if the type
        ///          of resource specified is unknown or the resource
        ///          cannot be found.
        ///      </return>
        ///         <short>    Tries to find the directory the file is in.</short>
        public string FindResourceDir(string type, string filename) {
            return (string) interceptor.Invoke("findResourceDir$$", "findResourceDir(const char*, const QString&) const", typeof(string), typeof(string), type, typeof(string), filename);
        }
        /// <remarks>
        ///  Tries to find all resources with the specified type.
        ///  The function will look into all specified directories
        ///  and return all filenames in these directories.
        /// <param> name="type" The type of resource to locate directories for.
        /// </param><param> name="filter" Only accept filenames that fit to filter. The filter
        ///         may consist of an optional directory and a QRegExp
        ///         wildcard expression. E.g. <tt>"images\.jpg"</tt>.
        ///         Use string() if you do not want a filter.
        /// </param><param> name="options" if the flags passed include Recursive, subdirectories
        ///         will also be search; if NoDuplicates is passed then only entries with
        ///         unique filenames will be returned eliminating duplicates.
        /// </param></remarks>        <return> List of all the files whose filename matches the
        ///          specified filter.
        ///      </return>
        ///         <short>    Tries to find all resources with the specified type.</short>
        public List<string> FindAllResources(string type, string filter, uint options) {
            return (List<string>) interceptor.Invoke("findAllResources$$$", "findAllResources(const char*, const QString&, KStandardDirs::SearchOptions) const", typeof(List<string>), typeof(string), type, typeof(string), filter, typeof(uint), options);
        }
        public List<string> FindAllResources(string type, string filter) {
            return (List<string>) interceptor.Invoke("findAllResources$$", "findAllResources(const char*, const QString&) const", typeof(List<string>), typeof(string), type, typeof(string), filter);
        }
        public List<string> FindAllResources(string type) {
            return (List<string>) interceptor.Invoke("findAllResources$", "findAllResources(const char*) const", typeof(List<string>), typeof(string), type);
        }
        /// <remarks>
        ///  Tries to find all resources with the specified type.
        ///  The function will look into all specified directories
        ///  and return all filenames (full and relative paths) in
        ///  these directories.
        /// <param> name="type" The type of resource to locate directories for.
        /// </param><param> name="filter" Only accept filenames that fit to filter. The filter
        ///         may consist of an optional directory and a QRegExp
        ///         wildcard expression. E.g. <tt>"images\.jpg"</tt>.
        ///         Use string() if you do not want a filter.
        /// </param><param> name="options" if the flags passed include Recursive, subdirectories
        ///         will also be search; if NoDuplicates is passed then only entries with
        ///         unique filenames will be returned eliminating duplicates.
        /// </param><param> name="relPaths" The list to store the relative paths into
        ///         These can be used later to .Locate() the file
        /// </param></remarks>        <return> List of all the files whose filename matches the
        ///          specified filter.
        ///      </return>
        ///         <short>    Tries to find all resources with the specified type.</short>
        public List<string> FindAllResources(string type, string filter, uint options, List<string> relPaths) {
            return (List<string>) interceptor.Invoke("findAllResources$$$?", "findAllResources(const char*, const QString&, KStandardDirs::SearchOptions, QStringList&) const", typeof(List<string>), typeof(string), type, typeof(string), filter, typeof(uint), options, typeof(List<string>), relPaths);
        }
        /// <remarks>
        ///  Reads customized entries out of the given config object and add
        ///  them via addResourceDirs().
        /// <param> name="config" The object the entries are read from. This should
        ///         contain global config files
        /// </param></remarks>        <return> @c true if new config paths have been added
        ///  from <code>config.</code>
        /// </return>
        ///         <short>    Reads customized entries out of the given config object and add  them via addResourceDirs().</short>
        public bool AddCustomized(KConfig config) {
            return (bool) interceptor.Invoke("addCustomized#", "addCustomized(KConfig*)", typeof(bool), typeof(KConfig), config);
        }
        /// <remarks>
        ///  This function is used internally by almost all other function as
        ///  it serves and fills the directories cache.
        /// <param> name="type" The type of resource
        /// </param></remarks>        <return> The list of possible directories for the specified <code>type.</code>
        ///  The function updates the cache if possible.  If the resource
        ///  type specified is unknown, it will return an empty list.
        ///  Note, that the directories are assured to exist beside the save
        ///  location, which may not exist, but is returned anyway.
        ///      </return>
        ///         <short>    This function is used internally by almost all other function as  it serves and fills the directories cache.</short>
        public List<string> ResourceDirs(string type) {
            return (List<string>) interceptor.Invoke("resourceDirs$", "resourceDirs(const char*) const", typeof(List<string>), typeof(string), type);
        }
        /// <remarks>
        ///  This function will return a list of all the types that KStandardDirs
        ///  supports.
        /// </remarks>        <return> All types that KDE supports
        ///      </return>
        ///         <short>    This function will return a list of all the types that KStandardDirs  supports.</short>
        public List<string> AllTypes() {
            return (List<string>) interceptor.Invoke("allTypes", "allTypes() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Finds a location to save files into for the given type
        ///  in the user's home directory.
        /// <param> name="type" The type of location to return.
        /// </param><param> name="suffix" A subdirectory name.
        ///              Makes it easier for you to create subdirectories.
        ///    You can't pass filenames here, you _have_ to pass
        ///        directory names only and add possible filename in
        ///        that directory yourself. A directory name always has a
        ///        trailing slash ('/').
        /// </param><param> name="create" If set, saveLocation() will create the directories
        ///         needed (including those given by <code>suffix</code>).
        /// </param></remarks>        <return> A path where resources of the specified type should be
        ///          saved, or string() if the resource type is unknown.
        ///      </return>
        ///         <short>    Finds a location to save files into for the given type  in the user's home directory.</short>
        public string SaveLocation(string type, string suffix, bool create) {
            return (string) interceptor.Invoke("saveLocation$$$", "saveLocation(const char*, const QString&, bool) const", typeof(string), typeof(string), type, typeof(string), suffix, typeof(bool), create);
        }
        public string SaveLocation(string type, string suffix) {
            return (string) interceptor.Invoke("saveLocation$$", "saveLocation(const char*, const QString&) const", typeof(string), typeof(string), type, typeof(string), suffix);
        }
        public string SaveLocation(string type) {
            return (string) interceptor.Invoke("saveLocation$", "saveLocation(const char*) const", typeof(string), typeof(string), type);
        }
        /// <remarks>
        ///  Converts an absolute path to a path relative to a certain
        ///  resource.
        ///  If "abs = .Locate(resource, rel)"
        ///  then "rel = relativeLocation(resource, abs)" and vice versa.
        /// <param> name="type" The type of resource.
        /// </param><param> name="absPath" An absolute path to make relative.
        /// </param></remarks>        <return> A relative path relative to resource <code>type</code> that
        ///  will find <code>absPath.</code> If no such relative path exists, <code>absPath</code>
        ///  will be returned unchanged.
        ///      </return>
        ///         <short>    Converts an absolute path to a path relative to a certain  resource.</short>
        public string RelativeLocation(string type, string absPath) {
            return (string) interceptor.Invoke("relativeLocation$$", "relativeLocation(const char*, const QString&)", typeof(string), typeof(string), type, typeof(string), absPath);
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        public string Kfsstnd_prefixes() {
            return (string) interceptor.Invoke("kfsstnd_prefixes", "kfsstnd_prefixes()", typeof(string));
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        public string Kfsstnd_xdg_conf_prefixes() {
            return (string) interceptor.Invoke("kfsstnd_xdg_conf_prefixes", "kfsstnd_xdg_conf_prefixes()", typeof(string));
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        public string Kfsstnd_xdg_data_prefixes() {
            return (string) interceptor.Invoke("kfsstnd_xdg_data_prefixes", "kfsstnd_xdg_data_prefixes()", typeof(string));
        }
        /// <remarks>
        ///  Returns the toplevel directory in which KStandardDirs
        ///  will store things. Most likely <tt>$HOME/.kde</tt>.
        ///  Don't use this function if you can use locateLocal()
        /// </remarks>        <return> the toplevel directory
        ///      </return>
        ///         <short>    Returns the toplevel directory in which KStandardDirs  will store things.</short>
        public string Localkdedir() {
            return (string) interceptor.Invoke("localkdedir", "localkdedir() const", typeof(string));
        }
        /// <remarks>
        /// </remarks>        <return> @c $XDG_DATA_HOME
        ///  See also http://www.freedesktop.org/standards/basedir/draft/basedir-spec/basedir-spec.html
        ///      </return>
        ///         <short>   </short>
        public string Localxdgdatadir() {
            return (string) interceptor.Invoke("localxdgdatadir", "localxdgdatadir() const", typeof(string));
        }
        /// <remarks>
        /// </remarks>        <return> @c $XDG_CONFIG_HOME
        ///  See also http://www.freedesktop.org/standards/basedir/draft/basedir-spec/basedir-spec.html
        ///      </return>
        ///         <short>   </short>
        public string Localxdgconfdir() {
            return (string) interceptor.Invoke("localxdgconfdir", "localxdgconfdir() const", typeof(string));
        }
        ~KStandardDirs() {
            interceptor.Invoke("~KStandardDirs", "~KStandardDirs()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KStandardDirs", "~KStandardDirs()", typeof(void));
        }
        /// <remarks>
        ///  Returns a List<string> list of pathnames in the system path.
        /// <param> name="pstr" The path which will be searched. If this is
        ///  		null (default), the @c $PATH environment variable will
        /// 		be searched.
        /// </param></remarks>        <return> a List<string> list of pathnames in the system path.
        ///      </return>
        ///         <short>    Returns a List<string> list of pathnames in the system path.</short>
        public static List<string> SystemPaths(string pstr) {
            return (List<string>) staticInterceptor.Invoke("systemPaths$", "systemPaths(const QString&)", typeof(List<string>), typeof(string), pstr);
        }
        public static List<string> SystemPaths() {
            return (List<string>) staticInterceptor.Invoke("systemPaths", "systemPaths()", typeof(List<string>));
        }
        /// <remarks>
        ///  Finds the executable in the system path.
        ///  A valid executable must
        ///  be a file and have its executable bit set.
        /// <param> name="appname" The name of the executable file for which to search.
        ///                 if this contains a path separator, it will be resolved
        ///                 according to the current working directory 
        ///                 (shell-like behaviour).
        /// </param><param> name="pathstr" The path which will be searched. If this is
        ///                 null (default), the @c $PATH environment variable will
        ///                 be searched.
        /// </param><param> name="options" if the flags passed include IgnoreExecBit the path returned
        ///                 may not have the executable bit set.
        /// </param></remarks>        <return> The path of the executable. If it was not found,
        ///          it will return string().
        /// </return>
        ///         <short>    Finds the executable in the system path.</short>
        ///         <see> findAllExe</see>
        public static string FindExe(string appname, string pathstr, uint options) {
            return (string) staticInterceptor.Invoke("findExe$$$", "findExe(const QString&, const QString&, KStandardDirs::SearchOptions)", typeof(string), typeof(string), appname, typeof(string), pathstr, typeof(uint), options);
        }
        public static string FindExe(string appname, string pathstr) {
            return (string) staticInterceptor.Invoke("findExe$$", "findExe(const QString&, const QString&)", typeof(string), typeof(string), appname, typeof(string), pathstr);
        }
        public static string FindExe(string appname) {
            return (string) staticInterceptor.Invoke("findExe$", "findExe(const QString&)", typeof(string), typeof(string), appname);
        }
        /// <remarks>
        ///  Finds all occurrences of an executable in the system path.
        /// <param> name="list" will be filled with the pathnames of all the
        ///              executables found. Will be empty if the executable
        ///              was not found.
        /// </param><param> name="appname" the name of the executable for which to
        ///                 search.
        /// </param><param> name="pathstr" the path list which will be searched. If this
        ///                 is 0 (default), the @c $PATH environment variable will
        ///                 be searched.
        /// </param><param> name="options" if the flags passed include IgnoreExecBit the path returned
        ///                 may not have the executable bit set.
        /// </param></remarks>        <return> The number of executables found, 0 if none were found.
        /// </return>
        ///         <short>    Finds all occurrences of an executable in the system path.</short>
        ///         <see> findExe</see>
        public static int FindAllExe(List<string> list, string appname, string pathstr, uint options) {
            return (int) staticInterceptor.Invoke("findAllExe?$$$", "findAllExe(QStringList&, const QString&, const QString&, KStandardDirs::SearchOptions)", typeof(int), typeof(List<string>), list, typeof(string), appname, typeof(string), pathstr, typeof(uint), options);
        }
        public static int FindAllExe(List<string> list, string appname, string pathstr) {
            return (int) staticInterceptor.Invoke("findAllExe?$$", "findAllExe(QStringList&, const QString&, const QString&)", typeof(int), typeof(List<string>), list, typeof(string), appname, typeof(string), pathstr);
        }
        public static int FindAllExe(List<string> list, string appname) {
            return (int) staticInterceptor.Invoke("findAllExe?$", "findAllExe(QStringList&, const QString&)", typeof(int), typeof(List<string>), list, typeof(string), appname);
        }
        /// <remarks>
        ///  Recursively creates still-missing directories in the given path.
        ///  The resulting permissions will depend on the current umask setting.
        ///  <tt>permission = mode & ~umask</tt>.
        /// <param> name="dir" Absolute path of the directory to be made.
        /// </param><param> name="mode" Directory permissions.
        /// </param></remarks>        <return> true if successful, false otherwise
        ///      </return>
        ///         <short>    Recursively creates still-missing directories in the given path.</short>
        public static bool MakeDir(string dir, int mode) {
            return (bool) staticInterceptor.Invoke("makeDir$$", "makeDir(const QString&, int)", typeof(bool), typeof(string), dir, typeof(int), mode);
        }
        public static bool MakeDir(string dir) {
            return (bool) staticInterceptor.Invoke("makeDir$", "makeDir(const QString&)", typeof(bool), typeof(string), dir);
        }
        /// <remarks>
        /// </remarks>        <return> the path where type was installed to by kdelibs. This is an absolute path and only
        ///  one out of many search paths
        ///      </return>
        ///         <short>   </short>
        public static string InstallPath(string type) {
            return (string) staticInterceptor.Invoke("installPath$", "installPath(const char*)", typeof(string), typeof(string), type);
        }
        /// <remarks>
        ///  Checks for existence and accessability of a file or directory.
        ///  Faster than creating a QFileInfo first.
        /// <param> name="fullPath" the path to check. IMPORTANT: must end with a slash if expected to be a directory
        ///                  (and no slash for a file, obviously).
        /// </param></remarks>        <return> @c true if the directory exists, @c false otherwise
        ///      </return>
        ///         <short>    Checks for existence and accessability of a file or directory.</short>
        public static bool Exists(string fullPath) {
            return (bool) staticInterceptor.Invoke("exists$", "exists(const QString&)", typeof(bool), typeof(string), fullPath);
        }
        /// <remarks>
        ///  Expands all symbolic links and resolves references to
        ///  '/./', '/../' and extra  '/' characters in <code>dirname</code>
        ///  and returns the canonicalized absolute pathname.
        ///  The resulting path will have no symbolic link, '/./'
        ///  or '/../' components.
        ///      </remarks>        <short>    Expands all symbolic links and resolves references to  '/.</short>
        public static string RealPath(string dirname) {
            return (string) staticInterceptor.Invoke("realPath$", "realPath(const QString&)", typeof(string), typeof(string), dirname);
        }
        /// <remarks>
        ///  Expands all symbolic links and resolves references to
        ///  '/./', '/../' and extra  '/' characters in <code>filename</code>
        ///  and returns the canonicalized absolute pathname.
        ///  The resulting path will have no symbolic link, '/./'
        ///  or '/../' components.
        ///      </remarks>        <short>    Expands all symbolic links and resolves references to  '/.</short>
        public static string RealFilePath(string filename) {
            return (string) staticInterceptor.Invoke("realFilePath$", "realFilePath(const QString&)", typeof(string), typeof(string), filename);
        }
        /// <remarks>
        ///  This function is just for convenience. It simply calls
        ///  instance.Dirs().<see> KStandardDirs.FindResource() findResource</see>(type, filename).
        /// <param> name="type" The type of the wanted resource, see KStandardDirs
        /// </param><param> name="filename" A relative filename of the resource
        /// </param><param> name="cData" The KComponentData object
        /// </param></remarks>        <return> A full path to the filename specified in the second
        ///          argument, or string() if not found
        /// </return>
        ///         <short>    This function is just for convenience.</short>
        public static string Locate(string type, string filename, KComponentData cData) {
            return (string) staticInterceptor.Invoke("locate$$#", "locate(const char*, const QString&, const KComponentData&)", typeof(string), typeof(string), type, typeof(string), filename, typeof(KComponentData), cData);
        }
        public static string Locate(string type, string filename) {
            return (string) staticInterceptor.Invoke("locate$$", "locate(const char*, const QString&)", typeof(string), typeof(string), type, typeof(string), filename);
        }
        /// <remarks>
        ///  This function is much like locate. However it returns a
        ///  filename suitable for writing to. No check is made if the
        ///  specified <code>filename</code> actually exists. Missing directories
        ///  are created. If <code>filename</code> is only a directory, without a
        ///  specific file, <code>filename</code> must have a trailing slash.
        /// <param> name="type" The type of the wanted resource, see KStandardDirs
        /// </param><param> name="filename" A relative filename of the resource
        /// </param><param> name="cData" The KComponentData object
        /// </param></remarks>        <return> A full path to the filename specified in the second
        ///          argument, or string() if not found
        /// </return>
        ///         <short>    This function is much like locate.</short>
        public static string LocateLocal(string type, string filename, KComponentData cData) {
            return (string) staticInterceptor.Invoke("locateLocal$$#", "locateLocal(const char*, const QString&, const KComponentData&)", typeof(string), typeof(string), type, typeof(string), filename, typeof(KComponentData), cData);
        }
        public static string LocateLocal(string type, string filename) {
            return (string) staticInterceptor.Invoke("locateLocal$$", "locateLocal(const char*, const QString&)", typeof(string), typeof(string), type, typeof(string), filename);
        }
        /// <remarks>
        ///  This function is much like locate. No check is made if the
        ///  specified filename actually exists. Missing directories
        ///  are created if <code>createDir</code> is true. If <code>filename</code> is only
        ///  a directory, without a specific file, <code>filename</code> must have
        ///  a trailing slash.
        /// <param> name="type" The type of the wanted resource, see KStandardDirs
        /// </param><param> name="filename" A relative filename of the resource
        /// </param><param> name="createDir" If <code>true</code>, missing directories are created,
        ///         if <code>false</code>, no directory is created
        /// </param><param> name="cData" The KComponentData object
        /// </param></remarks>        <return> A full path to the filename specified in the second
        ///          argument, or string() if not found
        /// </return>
        ///         <short>    This function is much like locate.</short>
        public static string LocateLocal(string type, string filename, bool createDir, KComponentData cData) {
            return (string) staticInterceptor.Invoke("locateLocal$$$#", "locateLocal(const char*, const QString&, bool, const KComponentData&)", typeof(string), typeof(string), type, typeof(string), filename, typeof(bool), createDir, typeof(KComponentData), cData);
        }
        public static string LocateLocal(string type, string filename, bool createDir) {
            return (string) staticInterceptor.Invoke("locateLocal$$$", "locateLocal(const char*, const QString&, bool)", typeof(string), typeof(string), type, typeof(string), filename, typeof(bool), createDir);
        }
        /// <remarks>
        ///  Check, if a file may be accessed in a given mode.
        ///  This is a wrapper around the access() system call.
        ///  checkAccess() calls access() with the given parameters.
        ///  If this is OK, checkAccess() returns true. If not, and W_OK
        ///  is part of mode, it is checked if there is write access to
        ///  the directory. If yes, checkAccess() returns true.
        ///  In all other cases checkAccess() returns false.
        ///  Other than access() this function EXPLICITLY ignores non-existent
        ///  files if checking for write access.
        /// <param> name="pathname" The full path of the file you want to test
        /// </param><param> name="mode" The access mode, as in the access() system call.
        /// </param></remarks>        <return> Whether the access is allowed, true = Access allowed
        ///      </return>
        ///         <short>    Check, if a file may be accessed in a given mode.</short>
        public static bool CheckAccess(string pathname, int mode) {
            return (bool) staticInterceptor.Invoke("checkAccess$$", "checkAccess(const QString&, int)", typeof(bool), typeof(string), pathname, typeof(int), mode);
        }
    }
}
