/*
 *
 *  KBluetooth4 - KDE Bluetooth Framework
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kbluetooth4.
 *
 *  kbluetooth4 is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kbluetooth4 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth4; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#ifndef DEVICESEL_H
#define DEVICESEL_H

#include <QtGui>
#include <KIcon>
#include <KDebug>
#include <klocalizedstring.h>
#include <solid/control/bluetoothmanager.h>

#include "ui_deviceselector.h"

class DeviceSel : public QDialog,
		  private Ui_deviceSelector
{

Q_OBJECT

public:
	DeviceSel(QObject* parent,QStringList filter);
	~DeviceSel();
	
	void setOkButtonText(const QString&);
	void setInfoLabel(const QString&);
	void hideExtraCheckBox();

private:

	 Solid::Control::BluetoothInterface* adapter;

	 QMap<QString,Solid::Control::BluetoothRemoteDevice*> deviceMap;
	 QMap<QString,QString> macMap;
	 Solid::Control::BluetoothRemoteDevice* dev;
	 Solid::Control::BluetoothRemoteDevice* finalDev;
	 QListWidgetItem* item;
	 QStringList filterList;

public slots:

	void slotCancel();
	void slotRemoteDeviceFound(QString,int,int);
	void slotDiscoveryCompleted();
	void slotDiscoveryStarted();
	void slotSend();
	void slotSearch();
	void slotNewNameFound(const QString& , const QString&);
	void slotUnlockChecker(bool);

signals:
	void deviceSelected(const QString& mac, const QString& ubi);
	void selectorCancelled();
	void unlockChanged(bool);

};

#endif
