/*
 * newsfeedmanager.h
 *
 * Copyright (c) 2007 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef NEWSFEEDMANAGER_H
#define NEWSFEEDMANAGER_H

#include <QMap>
#include <QObject>
#include <QUrl>
#include <QStringList>

#include <syndication/loader.h>

class NewsFeedManager : public QObject
{
    Q_OBJECT
public:
    static NewsFeedManager *self();

    void setSubscriptions( const QStringList &urls );

    const QMap<QUrl, Syndication::FeedPtr> &availableFeeds() const;

public Q_SLOTS:
    void update();
    void updateFeed( const QUrl &url );

Q_SIGNALS:
    void feedLoaded( const QUrl &url );
    void updateFinished();

private Q_SLOTS:
    void loaderFinished( Syndication::Loader *loader, Syndication::FeedPtr feed,
                         Syndication::ErrorCode status );

private:
    NewsFeedManager();
    NewsFeedManager( const NewsFeedManager &other ); // disabled
    void operator=( const NewsFeedManager &rhs ); // disabled

    static NewsFeedManager *s_instance;

    QStringList m_subscriptions;
    QMap<Syndication::Loader *, QUrl> m_activeLoaders;
    QMap<QUrl, Syndication::FeedPtr> m_availableFeeds;
};

#endif // NEWSFEEDMANAGER_H

