/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2002-2005  Stanislav Visnovsky
                            <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the Qt library by Trolltech AS, Norway (or with modified versions
  of Qt that use the same license as Qt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  Qt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#ifndef CONTEXT_H
#define CONTEXT_H

#include <qvaluelist.h>
#include <qwidget.h>

#include <ktexteditor/document.h>
#include <ktexteditor/view.h>

#include <kbproject.h>

class QComboBox;
class QVBoxLayout;
class QLineEdit;
class KListEditor;
class KConfig;

struct ContextInfo
{
    QString path;
    uint line;
};

/**
* Widget for displaying source code context of for the given GNU gettext comment.
* The searched paths can be configured using variables @PACKAGE@, @PACKAGEDIR@,
* @CODEROOT@ and @COMMENTPATH@. It requires a KPart implementing KTextEditor interface
* with selections.
*
* @short Class for displaying source code context
* @author Stanislav Visnovsky <visnovsky@kde.org>
*/
class SourceContext : public QWidget
{
    Q_OBJECT
public:
    SourceContext(QWidget* parent, KBabel::Project::Ptr project); 
    
    void setProject(KBabel::Project::Ptr project);

public slots:
    /**
     * Try to find the corresponding file and load it to this widget.
     * @param packageDir	path of the package, where to find the source file
     * @param packageName	name of the package, where to find the source file
     * @param gettextComment	comment string with context as generated by xgettext (can start with #:)
     */
    void setContext( const QString& packageDir, const QString& packageName, const QString& gettextComment );

private:
    QValueList<ContextInfo> resolvePath( const QString& packageDir, const QString& packageName, const QString& gettextComment);
    bool loadPart();
    
    KTextEditor::Document* _part;
    KTextEditor::View* _view;
    QComboBox *_referenceCombo;
    QVBoxLayout *_layout;
    
    QValueList<ContextInfo> _referenceList;
    
    KBabel::Project::Ptr _project;
private slots:
    void updateToSelected(int index);
};

#endif // CONTEXT_H
