/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include <klocale.h>
#include <kcmdlineargs.h>
#include <kwin.h>
#include <kaboutdata.h>
#include <kuniqueapplication.h>
#include <kdebug.h>

#include "keepmainwindow.h"

static const char *description = 
        I18N_NOOP( "KDE Backup System" );

int main(int argc, char **argv)
{
	KAboutData aboutData( "keep", I18N_NOOP( "Keep" ),"0.3.0", description, KAboutData::License_GPL_V2,
        "(c) 2005 Jean-Rémy Falleri" );
	aboutData.addAuthor( "Jean-Rémy Falleri", I18N_NOOP( "Maintainer" ),
        "jr.falleri@laposte.net" );
	aboutData.addCredit("Anthony Mercatante",I18N_NOOP("Ubuntu packages"));
	aboutData.addCredit("John Eckerson", I18N_NOOP("Application wording"));
	
	KCmdLineArgs::init( argc, argv, &aboutData );
	KUniqueApplication::addCmdLineOptions();

	if ( !KUniqueApplication::start() )
	{
		kdDebug() << "Already running, exiting." << endl;
		return 0;
	}

	KUniqueApplication app;
	app.disableSessionManagement();

	KeepMainWindow *keep = new KeepMainWindow( 0, "keep" );
	keep->show();
	app.setMainWidget( keep );

	return app.exec();
}

