#!/bin/sh
# written by jan gerber <j@v2v.cc>
# profiles added by Dan Dennedy

usage()
{
	# Title
	echo "Title: Ogg Theora (ffmpeg2theora)"

	# Usable?
	which ffmpeg2theora > /dev/null
	[ $? -eq 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: single-pass file-producer
	
	# Profiles
	echo "Profile: High Quality (640x480)"
	echo "Profile: Medium Quality (320x240)"
	echo "Profile: Broadband Quality (320x240, 564 Kbps)"
	echo "Profile: Low Quality (160x128, 128Kbps)"
}

execute()
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"
	project="$5"
	[ "x$file" = "x" ] && file="kino_export_"`date +%Y-%m-%d_%H.%M.%S`

	# Create metadata options
	title=`awk '/title="/ {split($0, x, "\""); z = 0; for (y in x) if (x[y] ~ /title=/) z = y + 1; print x[z]; exit}' "$project"`
	artist=`awk '/author="/ {split($0, x, "\""); z = 0; for (y in x) if (x[y] ~ /author=/) z = y + 1; print x[z]; exit}' "$project"`
	location=`awk '/abstract="/ {split($0, x, "\""); z = 0; for (y in x) if (x[y] ~ /abstract=/) z = y + 1; print x[z]; exit}' "$project"`
	copyright=`awk '/copyright="/ {split($0, x, "\""); z = 0; for (y in x) if (x[y] ~ /copyright=/) z = y + 1; print x[z]; exit}' "$project"`

	# Run the command
	case "$profile" in 
		"0" ) 	ffmpeg2theora -f dv -x 640 -y 480 -d -v 7 -a 3 -H 48000 \
				--title "$title" --artist "$artist" --location "$location" --copyright "$copyright" \
				-o "$file".ogg - ;;
		"1" ) 	ffmpeg2theora -f dv -x 320 -y 240 -d -v 7 -a 3 -H 48000 \
				--title "$title" --artist "$artist" --location "$location" --copyright "$copyright" \
				-o "$file".ogg - ;;
		"2" ) 	ffmpeg2theora -f dv -x 320 -y 240 -d -v 5 -V 500 -a 3 -A 64 -H 44100 \
				--title "$title" --artist "$artist" --location "$location" --copyright "$copyright" \
				-o "$file".ogg - ;;
		"3" ) 	ffmpeg2theora -f dv -x 160 -y 128 -d -v 1 -V 45 -a 0 -A 45 -H 22000 \
				--title "$title" --artist "$artist" --location "$location" --copyright "$copyright" \
				-o "$file".ogg - ;;
	esac
}

[ "$1" = "--usage" ] || [ -z "$1" ] && usage "$@" || execute "$@"
