/***************************************************************************
*   Copyright (C) 2003 by Sylvain Joyeux                                  *
*   sylvain.joyeux@m4x.org                                                *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KIOAPT_APTCACHE_H
#define KIOAPT_APTCACHE_H

#include <qvaluelist.h>
#include <qmap.h>
#include <qstring.h>
#include <kprocess.h>

class AptProtocol;

/**
@author Sylvain Joyeux
*/
class AptCache : public QObject {
  Q_OBJECT

  typedef void (AptCache::*ReceiveMethod) (const QStringList& lines);
  ReceiveMethod m_receive;

  // KProcIO messes the stderr and the stdout lines :(
  KProcess m_process;
  QString m_received_out, m_received_err;

  QString m_attribute;

  QString m_installed, m_candidate;

private slots:
  void receivedStdErr(KProcess* process, char* buffer, int len);
  void receivedStdOut(KProcess* process, char* buffer, int len);

private:
  void clear();
  void receiveSearch(const QStringList& lines);
  void receiveShow(const QStringList& lines);
  void receivePolicy(const QStringList& lines);
  void parse_pkgfield(const QString& data);

public:
  AptCache();
  ~AptCache();

  bool search(const QString& expression);
  bool show(const QString& package);
  bool policy(const QString& package);

  QString policy_installed() const;
  QString policy_candidate() const;

signals:
  /** Tags:
   *    warning (warning text)
   *    error (error text)
   *    package (package_name)
   *      short_desc (description)
   *      field (field_name)
   *        package_link (package_name)
   *        data (plain_data)
   *        indent (value)
   *      policy
   *        installed (version)
   *        candidate (version)
   *        version_table
   *          version (version_desc)
   *            location (location_desc)
   *    file (file_name)  [for dpkg]
   * end
   */
  void token(const QString& tag, const QString& value);
};

#endif
