/*
 *   kioskdata.h
 *
 *   Copyright (C) 2003, 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _KIOSKDATA_H_
#define _KIOSKDATA_H_

#include <qdict.h>
#include <qptrlist.h>
#include <qstringlist.h>

class  QDomElement;

class ComponentAction
{
public:
   ComponentAction();
   ~ComponentAction();
   bool load(const QDomElement &docElem);

private:
   QString expand(const QString &);

public:
   QString caption;
   QString description;
   typedef enum {ActImmutable, ActRestrict, ActCustom, ActModule, ActConfig, ActResource } ActionType;
   ActionType type;
   QString file;
   QString group;
   QString key;
   QPtrList<ComponentAction> subActions;
   bool defaultValue;
   
   static QDict<QString> *s_stdActionCaptions;
};

class ComponentExecData
{
public:
   void load(const QDomElement &docElem);
   bool hasOption(const QString &option) { return options.contains(option); }
public:
   QString exec;
   QString dcop;
   QStringList options;
   QStringList args;
};

class ComponentData
{
public:
   ComponentData();
   ~ComponentData();
   bool load(const QDomElement &docElem);
   bool loadActions(const QDomElement &docElem);

protected:
   void loadSetup(const QDomElement &docElem);
   
public:
   QString id;
   QString caption;
//   QString description;
   QString icon;
   QPtrList<ComponentAction> actions;
   QStringList mutableFiles;
   QStringList ignoreFiles;
   ComponentExecData setup;
   ComponentExecData preview;
};

class KioskData
{
public:
   KioskData();
   ~KioskData();

   QString errorMsg() { return m_errorMsg; }

   bool load();
   
public:
   QStringList m_componentList;
   QDict<ComponentData> m_componentData;
   
protected:
   QString m_errorMsg;   
};

#endif
