/***************************************************************************
                          knetworkconfigparser.h  -  description
                             -------------------
    begin                : Mon Jan 13 2003
    copyright            : (C) 2003 by Juan Luis Baptiste
    email                : jbaptiste@merlinux.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNETWORKCONFIGPARSER_H
#define KNETWORKCONFIGPARSER_H

#define PATH_TO_RESOLV_CONF "/etc/resolv.conf"
#define PATH_TO_HOSTS "/etc/hosts"
#define BACKEND_PATH "knetworkconf/backends/network-conf"

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>

#include <kapp.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <qobject.h>
#include <qdir.h>
#include <qfile.h>
#include <qstring.h>
#include <qprocess.h>
#include <qdom.h>
#include <qlabel.h>
#include <qcheckbox.h>

#include <klistbox.h>
#include <ksimpleconfig.h>
#include <kstandarddirs.h>

#include "knetworkinfo.h"
#include "kdetectdistrodlg.h"
#include "kreloadnetworkdlg.h"
#include "kinterfaceupdowndlg.h"
#include "kselectdistrodlg.h"

/**
  *@author Juan Luis Baptiste
  */

class KNetworkConfigParser : public QObject {
  Q_OBJECT
  public:
    KNetworkConfigParser();
    ~KNetworkConfigParser();
    /** return tyhe number of configured devices. */
    unsigned numDevices();
    void setProgramVersion(QString ver);
    /** Reads /proc/net/route looking for the default gateway. */
    void loadRoutingInfo();
    /** Saves the new network configuration. */
    void saveNetworkInfo(KNetworkInfo *networkInfo);
    /** Loads the network info from a xml file generated by the gnome system tools
        network backends that are included with this app. */
    KNetworkInfo * getNetworkInfo();
    QProcess * proc;
    QProcess * procDetect;
    QProcess * procSaveNetworkInfo;
    /** Variable to know if there is an dhcp device configured, so we can know if we need to save the defauilt gw info or not. */
    bool dhcpDevice;
    KNetworkInterface * getDeviceInfo(QString device);


  public slots:
    /** runs gst to find out the state of network devices.It runs the command:
    $knetworkconf_home/backends/networkconf [--platform platform] -d list_ifaces */
    void listIfaces(QString platform);

  private slots:
   /** Runs the gst backend to get network values. You can pass to the script a specific platform to load using the platform parameter.  */
    void runDetectionScript(QString platform);  
    void readIfconfigOutput();
    void readNetworkInfo();
    void readFromStdoutReloadScript();
    /** emits a signal when the network changes have benn saved. */
    void sendNetworkInfoSavedSignalSlot();
    /** Concatenates into a QString the xml output of the network backend. */
    void concatXMLOutputSlot();
    void readXMLErrSlot();
    /** Shows the dialog with all the supported platforms by GST. */
    void showSupportedPlatformsDialogSlot();
    /** Parses the xml ouput generated by GST that has all the supported platforms. */
    void readSupportedPlatformsSlot();
    /** No descriptions */
    void readListIfacesSlot();
    void readFromStdoutSaveNetworkInfo();
  /** Calls runDetectionScript(). */
  void listIfacesSlot();
                
  private:
    QPtrList<KNetworkInterface> deviceList;
    QPtrList<KNetworkInterface>  tempList;
    KNetworkInterface *newDevice;
    bool isUp;
    /** Counts the number of configured devices that had been found. */
    unsigned _numDevices;
    KRoutingInfo *routingInfo;
    KDNSInfo *dnsInfo;
    QString programVersion;
    /**  The output of ifconfig command that needs to be parsed in readIfconfigOutput()*/
    QString ifconfigOutput;
    KNetworkInfo * networkInfo;
    QPtrList<KKnownHostInfo> knownHostsList;
    QString hexIPv4ToDecIPv4(QString hex);
    /** lists all platforms supported by GST. */
    void loadSupportedPlatforms();
    /** Returns the info of a platform in the form of 'key:value' . */
    QString getPlatformInfo(QDomElement platform);

    /** Shows a progress dialog while the networl is being reloaded. */
    KInterfaceUpDownDlg * kpdReloadStatusDlg;
    QProcess *procReloadNetwork;
    QString reloadScriptOutput;
    /** Contains the network configuration en xml format. */
    /** List of supported platforms. */
    QStringList supportedPlatformsList;
    QString xmlOuput;
    QString xmlErr;
    /** Temporal device list to be used when loading the dhcp devices info */
    QPtrList<KNetworkInterface> tempDevList;
    /** Parses all of the <statichost>...</statichost> entries in the xml configuration file. */
    KKnownHostInfo * getStaticHostInfo(QDomElement host);
    /** Saves the option to show again or not the platform using KSimpleConfig*/
    void saveAskAgain(QString platform, bool askAgain);
    /**Returns if the show platform should be shown again or not and the saved platform*/
    bool readAskAgain(QString &platform);
  
  protected: // Protected methods
    /** Parses all of the <interface>...</interface> entries in the xml configuration file. */
    KNetworkInterface *getInterfaceInfo(QDomElement interface, QString type);
    /** Reads the xml with the network info. */

  signals: // Signals
    /** emmited when the xml file is finished reading. */
    void readyLoadingNetworkInfo();
    
    /** emmited when the xml file saved and the backend has finished executing. */
//    void readySavingNetworkInfo();
    
    /** Signal that is sent when fillDevices() has finished fllind the dhcp devices. */
    void readyIfconfigOutputSignal();
    /** Signal emmited when the platform can't be auto-detected. */
    void errorDetectingPlatform();
    /** signal emmited when the parsing of the xml of the supported platform list. */
    void readyLoadingSupportedPlatforms();
    /** signal emmited when the config parser needs to set read only the GUI because 
        some error in the parsing, or the platform isn't supported.*/
    void setReadOnly(bool);
};

#endif
