/***************************************************************************
                          knetworkinterface.h  -  description
                             -------------------
    begin                : Mon Jan 13 2003
    copyright            : (C) 2003 by Juan Luis Baptiste
    email                : jbaptiste@merlinux.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNETWORKINTERFACE_H
#define KNETWORKINTERFACE_H

#include <qstring.h>

/**This class has all the values associated with a network interface.
  *@author Juan Luis Baptiste
  */

class KNetworkInterface {
public: 
	KNetworkInterface();
	~KNetworkInterface();

  QString getBootProto();
  QString getBroadcast();
  QString getDeviceName();
  QString getIpAddress();
  QString getNetmask();
  QString getNetwork();
  QString getOnBoot();
  void setBootProto(QString bootProto);
  void setBroadcast(QString broadcast);
  void setDeviceName(QString deviceName);
  void setIpAddress(QString ipAddress);
  void setNetmask(QString netmask);
  void setNetwork(QString network);
  void setOnBoot(QString onBoot);
  bool isActive();
  void setActive(bool active);
  void setMacAddress(QString addr);
  QString getMacAddress();
  void setDescription(QString desc);
  QString getDescription();
  void setType(QString type);
  QString getType();
  
  
private: // Private attributes
  /** Interface name (i.e. eth0, eth1, etc). */
  QString deviceName;
  /** Boot protocol of the device (static, dhcp). */
  QString bootProto;
  /** IPv4 address of the interface. */
  QString ipAddress;
  /** The Netmask. */
  QString netmask;
  /** The network. */
  QString network;
  /** The broadcast. */
  QString broadcast;
  /** thetermines if this device is configured at boot time. */
  QString onBoot;
  bool active;
  /** The MAC address. */
  QString hwAddress;
  /** A little description about the network device. */
  QString description;
  /** Type of interface (ethernet,wireless,loopback or modem)*/
  QString type;
};

#endif
