/***************************************************************************
 *
 * knetworkmanager-pptp.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <klocale.h>
#include <qmessagebox.h>
#include <qbutton.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include <qobjectlist.h>
#include <qobject.h>
#include <qcheckbox.h>
#include <kpassdlg.h>
#include <kgenericfactory.h>

#include "knetworkmanager-pptp.h"

typedef KGenericFactory<PPTPPlugin> PPTPPluginFactory;
K_EXPORT_COMPONENT_FACTORY( knetworkmanager_pptp, PPTPPluginFactory("knetworkmanager_pptp"));


PPTPPlugin::PPTPPlugin(QObject* parent, const char* name, const QStringList& args) 
	: VPNPlugin(parent, name, args)
{
	KLocale* loc = KGlobal::locale();
	loc->insertCatalogue("NetworkManager-pptp");
}

PPTPPlugin::~PPTPPlugin()
{

}

VPNConfigWidget* PPTPPlugin::CreateConfigWidget(QWidget* parent)
{
	return new PPTPConfig(parent);
}

VPNAuthenticationWidget* PPTPPlugin::CreateAuthenticationWidget(QWidget* parent)
{
	return new PPTPAuthentication(parent);
}


PPTPConfig::PPTPConfig(QWidget* parent)
	: VPNConfigWidget(parent)
{
	QVBoxLayout* layout = new QVBoxLayout(this, 1, 1);
	_pptpWidget = new PPTPConfigWidget(this);
	layout->addWidget(_pptpWidget);
	
	connect(_pptpWidget->chkIPAdresses, SIGNAL(toggled(bool)), _pptpWidget->routes, SLOT(setEnabled(bool)));

	this->languageChange();
}

PPTPConfig::~PPTPConfig()
{

}

void PPTPConfig::languageChange()
{

}

void PPTPConfig::setVPNData(const QStringList& routes, const QStringList& properties)
{
	// fill up our inputfields (only textfields atm)
	for(QStringList::ConstIterator it = properties.begin(); it != properties.end(); ++it)
	{
		QString entry = (*it);
		
		if (entry == "remote")
		{
			_pptpWidget->gateway->setText(*(++it));
		}
		else if (entry == "username")
		{
			_pptpWidget->username->setText(*(++it));
		}
		else if (entry == "comp-mppc")
		{
			_pptpWidget->chkUseMPPC->setChecked( (*(++it) == "yes") );
		}
		else if (entry == "encrypt-mppe")
		{
			_pptpWidget->chkUseMPPE->setChecked( (*(++it) == "yes") );
		}
	}

	// set routes
	if (!routes.empty())
	{
		_pptpWidget->chkIPAdresses->setChecked(true);
		_pptpWidget->routes->setText(routes.join(" "));
	}
}

QStringList PPTPConfig::getVPNProperties()
{
	// build a StingList of properties
	QStringList strlist;
	strlist.append("remote");	
	strlist.append(_pptpWidget->gateway->text());

	strlist.append("username");	
	strlist.append(_pptpWidget->username->text());

	strlist.append("comp-mppc");
	strlist.append(_pptpWidget->chkUseMPPC->isChecked() ? "yes" : "no");

	strlist.append("encrypt-mppe");
	strlist.append(_pptpWidget->chkUseMPPE->isChecked() ? "yes" : "no");

	return strlist;
}

QStringList PPTPConfig::getVPNRoutes()
{
	QStringList strlist;
	if(_pptpWidget->chkIPAdresses->isChecked())
	{
		strlist = QStringList::split(" ", _pptpWidget->routes->text());
	}	
	return strlist;

}

bool PPTPConfig::hasChanged()
{
	return true;
}

bool PPTPConfig::isValid(QStringList& err_msg)
{
	bool retval = true;
	if(_pptpWidget->gateway->text() == "" || _pptpWidget->username->text() == "")
	{
		err_msg.append(i18n("At least the gateway and username has to be supplied."));
		retval = false;
	}
	return retval;
}

PPTPAuthentication::PPTPAuthentication(QWidget* parent, char* name)
	: VPNAuthenticationWidget(parent, name)
{
	QVBoxLayout* layout = new QVBoxLayout(this, 1, 1);
	_pptpAuth = new PPTPAuthenticationWidget(this);
	layout->addWidget(_pptpAuth);
}

PPTPAuthentication::~PPTPAuthentication()
{

}

QStringList PPTPAuthentication::getPasswords()
{
	QStringList pwds;
	pwds.push_back(_pptpAuth->username->text());
	pwds.push_back(_pptpAuth->password->password());
	return pwds;
}
