/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import mso.generator.ParserGeneratorUtils;
import mso.javaparser.LEInputStream;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.w3c.dom.Document;

public class PPTStructurePrinter {
    public static void main(String[] stringArray) throws Exception {
        String string = "/tmp/mp00_RomanBulletsnumber.ppt";
        PPTStructurePrinter pPTStructurePrinter = new PPTStructurePrinter();
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse("src/mso.xml");
        Map<Integer, String> map = ParserGeneratorUtils.getRecordTypeNames(document);
        PrintStream printStream = System.out;
        printStream = new PrintStream(new FileOutputStream("/tmp/out"));
        pPTStructurePrinter.parse(string, map, printStream);
    }

    public void parse(String string, Map<Integer, String> map, PrintStream printStream) throws IOException {
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)new FileInputStream(string));
        DirectoryNode directoryNode = pOIFSFileSystem.getRoot();
        try {
            directoryNode = (DirectoryEntry)directoryNode.getEntry("PP97_DUALSTORAGE");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.parse((DirectoryEntry)directoryNode, map, printStream);
    }

    void parse(DirectoryEntry directoryEntry, Map<Integer, String> map, PrintStream printStream) throws IOException {
        Iterator iterator = directoryEntry.getEntries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry instanceof DirectoryEntry) {
                printStream.println("found directory entry: " + entry.getName());
                continue;
            }
            if (!(entry instanceof DocumentEntry)) continue;
            DocumentEntry documentEntry = (DocumentEntry)entry;
            DocumentInputStream documentInputStream = new DocumentInputStream(documentEntry);
            byte[] byArray = new byte[documentEntry.getSize()];
            if (byArray.length != documentInputStream.read(byArray, 0, byArray.length)) {
                throw new IOException("could not read all data");
            }
            documentInputStream.close();
            LEInputStream lEInputStream = new LEInputStream(byArray);
            printStream.println("found document entry: " + entry.getName() + " of length " + documentEntry.getSize());
            try {
                while (lEInputStream.getPosition() != documentEntry.getSize()) {
                    this.printStructure(lEInputStream, 0, map, printStream);
                }
            }
            catch (IOException iOException) {
                printStream.println("abrupt end");
            }
        }
    }

    void printStructure(LEInputStream lEInputStream, int n, Map<Integer, String> map, PrintStream printStream) throws IOException {
        byte by = lEInputStream.readuint4();
        short s = lEInputStream.readuint12();
        int n2 = lEInputStream.readuint16();
        int n3 = lEInputStream.readuint32();
        String string = Integer.toHexString(s).toUpperCase();
        String string2 = Integer.toHexString(n2).toUpperCase();
        String string3 = "\t\t";
        String string4 = map.containsKey(n2) ? map.get(n2) : "";
        printStream.println(n + string3 + by + string3 + string + string3 + string2 + string3 + n3 + string3 + lEInputStream.getPosition() + string3 + string4);
        if (by == 15 && n2 != 1064) {
            int n4 = lEInputStream.getPosition() + n3;
            while (lEInputStream.getPosition() != n4) {
                if (lEInputStream.getPosition() > n4) {
                    String string5 = lEInputStream.getPosition() + " > " + n4;
                    printStream.println(string5);
                    throw new IOException(string5);
                }
                this.printStructure(lEInputStream, n + 1, map, printStream);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                lEInputStream.readuint8();
            }
        }
    }
}

