/*******************************************************************************
**                              konserve.cpp
**                                 part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/

// KDE Includes
#include <kapplication.h>

// My Includes
#include "konservedebug.h"
#include "konserve.h"

////////////////////////////////////////////////////////////////////////////////
///////	       class konserve                                            ///////
////////////////////////////////////////////////////////////////////////////////

Konserve::Konserve()
    : KMainWindow(),
      mpTheProfileManager( 0L ),
      mpTheWidget( 0L ),
      mpTheConfigDlg( 0L ),
      mpTheWizard( 0L ),
      mpTheConfigurator( 0L ),
      mpKAboutApp( 0L )
{
    TRACE();
    contructMembers();
    setupConnections();
}

Konserve::~Konserve()
{
    TRACE();
    delete mpTheWidget;
    delete mpTheConfigDlg;
    delete mpTheWizard;
    delete mpTheConfigurator;
    delete mpKAboutApp;
}

void Konserve::slotQuit()
{
    TRACE();
    delete mpTheProfileManager;
    kapp->quit();
}

void Konserve::contructMembers()
{
    TRACE();
    mpTheWidget         = new SystemTrayWidget( this, "SystemTrayWidget" );
    Q_CHECK_PTR( mpTheWidget );
    mpTheConfigDlg      = new ConfigurationDlg;
    Q_CHECK_PTR( mpTheConfigDlg );
    mpTheProfileManager = new ProfileManager;
    Q_CHECK_PTR( mpTheProfileManager );
    mpTheWizard         = new Wizard;
    Q_CHECK_PTR( mpTheWizard );
    mpTheConfigurator   = new Configurator;
    Q_CHECK_PTR( mpTheConfigurator );
    mpKAboutApp         = new KAboutApplication( mpTheConfigDlg, "About box" );
    Q_CHECK_PTR( mpKAboutApp );

    setCentralWidget( mpTheWidget );
}

void Konserve::setupConnections()
{
    TRACE();
    connect(
        mpTheWidget,    SIGNAL( preferences() ),
        mpTheConfigDlg, SLOT( exec() )
        );
    connect(
        mpTheWidget, SIGNAL( quit() ),
        this,        SLOT( slotQuit() )
        );
    connect(
        mpTheWidget,         SIGNAL( doBackup( QString ) ),
        mpTheProfileManager, SLOT( slotDoBackup( QString ) )
        );
    connect(
        mpTheWidget, SIGNAL( wizard() ),
        mpTheWizard, SLOT( exec() )
        );
    connect(
        mpTheWidget, SIGNAL( wizard( QString ) ),
        mpTheWizard, SLOT( slotSetSource( QString ) )
        );
    connect(
        mpTheConfigDlg->aboutKPushButton, SIGNAL( clicked() ),
        mpKAboutApp,                      SLOT( show() )
        );

    mpTheWizard->setSubject( mpTheProfileManager );

    mpTheProfileManager->addObserver( mpTheWidget );
    mpTheProfileManager->addObserver( mpTheConfigDlg );
    mpTheProfileManager->addObserver( mpTheConfigurator );

    mpTheConfigurator->doConfigure();
}

#include "konserve.moc"
