/*******************************************************************************
**                     profilemngrinterface.cpp
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/

// Qt Includes
#include <qptrlist.h>

// My Includes
#include "konservedebug.h"
#include "profilemngrinterface.h"

////////////////////////////////////////////////////////////////////////////////
///////               class ProfileMngrInterface                         ///////
////////////////////////////////////////////////////////////////////////////////

void ProfileMngrInterface::setSubject( Subject* subject )
{
    TRACE();
    mpTheSubject = subject;
    Q_ASSERT( 0L != mpTheSubject );
}

void ProfileMngrInterface::_inserted( BackupProfile *original,
                                      BackupProfile *b )
{
    TRACE();
    Q_ASSERT( 0L != mpTheSubject );

    if ( mpInsertedByMe == original )
        return;
    this->inserted( b );
}

void ProfileMngrInterface::_changed(  BackupProfile* original, BackupProfile *b )
{
    TRACE();
    Q_ASSERT( 0L != mpTheSubject );

    if ( mpInsertedByMe == original )
        return;
    this->changed( b );
}

void ProfileMngrInterface::_removed( QString s )
{
    TRACE();
    Q_ASSERT( 0L != mpTheSubject );

    if ( msDeletedByMe == s )
        return;
    this->removed( s );
}

void ProfileMngrInterface::inserted( BackupProfile * )
{
    TRACE();
}

void ProfileMngrInterface::changed( BackupProfile * )
{
    TRACE();
}

void ProfileMngrInterface::removed( QString )
{
    TRACE();
}

void ProfileMngrInterface::insert( BackupProfile *b )
{
    TRACE();
    Q_ASSERT( 0L == mpInsertedByMe ); Q_ASSERT( 0L != mpTheSubject );
    Q_ASSERT( msDeletedByMe == QString::null );

    mpInsertedByMe = b;
    mpTheSubject->_insertCalled( b );
    mpInsertedByMe = 0L;
}

void ProfileMngrInterface::change( BackupProfile *b )
{
    TRACE();
    Q_ASSERT( 0L == mpInsertedByMe ); Q_ASSERT( 0L != mpTheSubject );
    Q_ASSERT( msDeletedByMe == QString::null );

    mpInsertedByMe = b;
    mpTheSubject->_changeCalled( b );
    mpInsertedByMe = 0L;
}

void ProfileMngrInterface::remove( QString s )
{
    TRACE();
    Q_ASSERT( 0 == mpInsertedByMe ); Q_ASSERT( 0L != mpTheSubject );
    Q_ASSERT( msDeletedByMe == QString::null );

    msDeletedByMe = s;
    mpTheSubject->_removeCalled( s );
    msDeletedByMe = QString::null;
}

bool ProfileMngrInterface::exists( QString s )
{
    TRACE();
    return mpTheSubject->_exists( s );
}

void ProfileMngrInterface::restore( QString s )
{
    TRACE();
    if ( QString::null != s )
        mpTheSubject->_restore( s );
}

////////////////////////////////////////////////////////////////////////////////
///////               class SubjectMngrInterface                         ///////
////////////////////////////////////////////////////////////////////////////////


void Subject::addObserver( ProfileMngrInterface* p )
{
    TRACE();
    Q_ASSERT( 0L != p );

    p->setSubject( this );
    mTheProfileMngrInterfaces.append( p );
}

void Subject::removeObserver( ProfileMngrInterface *p )
{
    TRACE();
    Q_ASSERT( 0L != p );

    mTheProfileMngrInterfaces.removeRef( p );
}

void Subject::_insertCalled( BackupProfile *b )
{
    TRACE();
    Q_ASSERT( 0L != b );
    bool existsAlready = _exists( b->getIdentifier() );
    this->insertCalled( b );

    BackupProfile *readonly_copy = BackupProfile::newBackupProfileReadOnly( b );
    ProfileMngrInterface* p;
    for ( p = mTheProfileMngrInterfaces.first();
          p;
          p = mTheProfileMngrInterfaces.next() )
    {
        if ( existsAlready )
            p->_changed( b, readonly_copy );
        else
            p->_inserted( b, readonly_copy );
    }
}

void Subject::_changeCalled( BackupProfile *b )
{
    TRACE();
    Q_ASSERT( 0L != b );
    Q_ASSERT( _exists( b->getIdentifier() ) );

    this->changeCalled( b );

    BackupProfile *readonly_copy = BackupProfile::newBackupProfileReadOnly( b );
    ProfileMngrInterface* it;
    for ( it = mTheProfileMngrInterfaces.first();
          it;
          it = mTheProfileMngrInterfaces.next() )
    {
        it->_changed( b, readonly_copy );
    }
}

void Subject::_removeCalled( QString s )
{
    TRACE();
    Q_ASSERT( QString::null != s );
    Q_ASSERT( _exists( s ) );

    this->removeCalled( s );

    ProfileMngrInterface* it;
    for ( it = mTheProfileMngrInterfaces.first();
          it;
          it = mTheProfileMngrInterfaces.next() )
    {
        it->_removed( s );
    }
}

bool Subject::_exists( QString s )
{
    TRACE();
    return existsCalled( s );
}

void Subject::_restore( QString s )
{
    TRACE();
    Q_ASSERT( _exists( s ) );
    restoreCalled( s );
}

// This is just used on program exit to transfer the LastBackup information
// from the ProfileManager to the Configurator -- ugly, ugly.
void Subject::_evilHack_SaveBackupProfile( BackupProfile* b )
{
    TRACE();
    Q_ASSERT( 0L != b );

    BackupProfile *readonly_copy = BackupProfile::newBackupProfileReadOnly( b );
    ProfileMngrInterface* it;
    for ( it = mTheProfileMngrInterfaces.first();
          it;
          it = mTheProfileMngrInterfaces.next() )
    {
        it->_changed( b, readonly_copy );
    }
}
