/*******************************************************************************
**                       systemtraywidget.cpp
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/

// Standard includes
#include <iostream>

// Qt includes
#include <qcursor.h>
#include <qdragobject.h>

// KDE includes
#include <kapplication.h>
#include <kglobal.h>
#include <kstandarddirs.h>

// My includes
#include "konservedebug.h"
#include "systemtraywidget.h"

////////////////////////////////////////////////////////////////////////////////
///////	       class systemtraywidget                                    ///////
////////////////////////////////////////////////////////////////////////////////

SystemTrayWidget::SystemTrayWidget( QWidget *parent, const char* name )
    : QWidget( parent, name ),
      mHighestMenuId( HIGHEST_STD_ID ),
      mpIconLoader( KGlobal::iconLoader() )
{
    TRACE();
    mPixmap = mpIconLoader->loadIcon(
        locate( "icon", "hicolor/16x16/apps/konserve.png" ), KIcon::Small
        );
    mpPopupMenu = new KPopupMenu( this, "The tray icon popup" );

    mpPopupMenu->insertSeparator();

    mpPopupMenu->insertItem(
        mpIconLoader->loadIconSet( "wizard",  KIcon::Small ),
        "Wizard", this, SLOT( slotWizard() ), 0, WIZARD_ID
        );
    mpPopupMenu->insertItem(
        mpIconLoader->loadIconSet( "configure", KIcon::Small ),
        "Preferences", this, SLOT( slotPreferences() ), 0, PREF_ID
        );
    mpPopupMenu->insertItem(
        mpIconLoader->loadIconSet( "help", KIcon::Small ),
        "Help", this, SLOT( slotHelp() ), 0, HELP_ID
        );

    mpPopupMenu->insertSeparator();

    mpPopupMenu->insertItem(
        mpIconLoader->loadIconSet( "exit", KIcon::Small ),
        "Quit", this, SLOT( slotQuit() ), 0, QUIT_ID
        );
    connect( mpPopupMenu, SIGNAL( activated( int ) ),
             this, SLOT( slotDoBackup( int ) ) );

    setAcceptDrops(true);
}

SystemTrayWidget::~SystemTrayWidget()
{
    TRACE();
    // NOOP
}

void SystemTrayWidget::inserted( BackupProfile *b )
{
    TRACE();
    mProfileNameList.append( b->getIdentifier() );
    mHighestMenuId++;
    mpPopupMenu->insertItem( b->getIdentifier(), mHighestMenuId, 0 );
}

void SystemTrayWidget::changed( BackupProfile * )
{
    TRACE();
    // NOOP
}

void SystemTrayWidget::removed( QString s )
{
    TRACE();
    int index = mHighestMenuId;

    while ( HIGHEST_STD_ID < index )
    {
        if ( mpPopupMenu->text( index ) == s )
        {
            mpPopupMenu->removeItem( index );
            return;
        }
        index--;
    }
}

void SystemTrayWidget::paintEvent( QPaintEvent * /* ev */)
{
    TRACE();
    QPainter p(this);
    int x = (width() - mPixmap.width()) / 2;
    int y = (height() - mPixmap.height()) / 2;
    if ( x < 0 ) x = 0;
    if ( y < 0 ) y = 0;
    p.drawPixmap(x , y, mPixmap);
    p.end();
}

void SystemTrayWidget::mousePressEvent( QMouseEvent * /* ev */ )
{
    TRACE();
    mpPopupMenu->popup(  QCursor::pos() );
}

void SystemTrayWidget::dragEnterEvent(QDragEnterEvent* event)
{
    TRACE();
    event->accept(  QUriDrag::canDecode(event)  );
}

void SystemTrayWidget::dropEvent(QDropEvent* event)
{
    TRACE();
    QStringList I;
    if ( QUriDrag::decodeToUnicodeUris(event, I) ) {
        emit wizard( QString(*(I.begin())) );
        emit wizard();
    }
}

void SystemTrayWidget::slotWizard()
{
    TRACE();
    emit wizard();
}

void SystemTrayWidget::slotPreferences()
{
    TRACE();
    emit preferences();
}

void SystemTrayWidget::slotHelp()
{
    TRACE();
    kapp->invokeHelp( "", "konserve" );
}

void SystemTrayWidget::slotQuit()
{
    TRACE();
    emit quit();
}

void SystemTrayWidget::slotDoBackup( int id )
{
    TRACE();
    if ( HIGHEST_STD_ID < id )
    {
        emit doBackup( mpPopupMenu->text( id ) );
        return;
    }
}

#include "systemtraywidget.moc"
