/*******************************************************************************
**                               wizard.h
**                                part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/
#ifndef WIZARD_H
#define WIZARD_H

// KDE includes
#include <kwizard.h>

// My includes
#include "identifierwidget.h"
#include "sourceurlwidget.h"
#include "backupurlwidget.h"
#include "timeintervalwidget.h"
#include "finalwidget.h"
#include "profilemngrinterface.h"

////////////////////////////////////////////////////////////////////////////////
//////////                  class Wizard                                 ///////
////////////////////////////////////////////////////////////////////////////////

class Wizard : public KWizard, public ProfileMngrInterface
{
    Q_OBJECT

public:
    Wizard();
    ~Wizard();

public slots:
    void slotSetSource( QString source );

private slots:
    void slotSelected( const QString& title );
    void slotHelp();
    void slotReset();
    void accept();

private:
    void setupPages();

    IdentifierWidget   *mpIdentifierWidget;
    SourceUrlWidget    *mpSourceUrlWidget;
    BackupUrlWidget    *mpBackupUrlWidget;
    TimeIntervalWidget *mpTimeIntervalWidget;
    FinalWidget        *mpFinalWidget;
};

#endif
