/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: lamhalt.c,v 1.7 2003/03/27 17:46:22 jsquyres Exp $
 *
 *	Function:	- kill an entire running LAM run time system
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>

#include <lam_config.h>
#include <args.h>
#include <etc_misc.h>
#include <dl_inet.h>
#include <portable.h>
#include <net.h>
#include <events.h>
#include <priority.h>
#include <hreq.h>
#include <laminternal.h>
#include <etc_misc.h>
#include <lam_network.h>


/*
 * Local variables
 */
static int lamhalt_timeout = 15;


int
main(int argc, char **argv)
{
  int fl_debug = 0;
  int fl_verbose = 0;
  int localnode; 
  int *nodes;
  int i, save, nnodes;
  
  validopts("Hhvd");
  if (do_args(&argc, argv)) {
    show_help("lamhalt", "usage", NULL);
    exit(errno);
  }
  
  if (opt_taken('h')) {
    show_help("lamhalt", "usage", NULL);
    exit(0);
  }

  /* Get flags  */

  fl_debug = opt_taken('d');
  fl_verbose = opt_taken('v') || fl_debug;
  
  /* Announce */

  if (!opt_taken('H'))
    lam_show_version(0);

  /* Attach to the local LAM daemon */

  if (kinit(PRCMD)) {
    char hostname[MAXHOSTNAMELEN];
    gethostname(hostname, MAXHOSTNAMELEN);

    show_help(NULL, "no-lamd", "lamhalt", hostname, NULL);
    exit(LAM_EEXIT);
  }

  if (fl_verbose)
    printf("Shutting down LAM\n");

  /* Build array of node ID's, not including the localnode */

  localnode = getnodeid();
  nnodes = getnall();
  nodes = malloc(sizeof(int) * nnodes);
  if (nodes == NULL) {
    show_help(NULL, "system-call-fail", "malloc", NULL);
    kexit(1);
  }

  if (getnodes(nodes, nnodes, NT_CAST, 0) != 0) {
    show_help(NULL, "library-call-fail", "getnodes", NULL);
    kexit(1);
  }

  /* Now strip out the localnode */

  for (save = i = 0; i < nnodes; ++i)
    if (nodes[i] != localnode && nodes[i] != NOTNODEID)
      nodes[save++] = nodes[i];
  nnodes = save;

  /* Tell them all to die */

  rhreq(nodes, nnodes, lamhalt_timeout, 
	(fl_debug ? 1 : (fl_verbose ? 0 : -1)));

  /* Send one more message, telling local LAM daemon that it's a good
     day to die.  Do the localnode last so that it can be used to
     send/receive all the previous messages without dying.  */

  rhreq(&localnode, 1, lamhalt_timeout,
	(fl_debug ? 1 : (fl_verbose ? 0 : -1)));

  /* Do not attempt to receive final ACK message */

  if (fl_debug)
    printf("lamhalt: local LAM daemon halted\n");
  if (fl_verbose)
    printf("LAM halted\n");

  /* That's all she wrote */

  return 0;
}
