/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	RBD
 *
 *	$Log: memucmp.c,v $
 *	Revision 6.3  2002/10/09 20:57:02  brbarret
 *	* Update tree to match the latest, greatest, license for LAM/MPI.  And this
 *	  one is even done properly :)
 *
 *	Revision 6.2  1999/05/24 16:56:49  kmeyer1
 *	added $copyright$
 *	
 *	Revision 6.1  1996/11/23 19:58:02  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:47:22  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:57:04  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:56:52  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:35:01  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/07/22  13:58:47  raja
 * pre-release to 2.3
 * 
 *	Function:	- compare arrays of bytes (unsigned characters)
 *	Accepts:	- ptr to first array
 *			- ptr to second array
 *			- # of bytes
 *	Returns:	- -1, 0, +1 (m1 < m2, m1 == m2, m1 > m2)
 */

#include <portable.h>

int
memucmp(m1, m2, nbytes)

unsigned char		*m1;
unsigned char		*m2;
int4			nbytes;

{
	for (; nbytes > 0; --nbytes, ++m1, ++m2) {

		if (*m1 < *m2) {
			return(-1);
		}
		else if (*m1 > * m2) {
			return(1);
		}
	}

	return(0);
}
