/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: ssi_rpi_init.c,v 1.4 2003/04/14 19:10:18 jsquyres Exp $
 *
 */

#include <lam_config.h>

#include <stdlib.h>
#include <unistd.h>

#include <all_list.h>
#include <lam-ssi.h>
#include <lam-ssi-rpi.h>
#include <mpisys.h>


/*
 * This will need to change when we go multi-RPI -- we'll have have
 * the RPIs let us know which procs it wants to support and at what
 * priority.  Then we'll have to divy them up and tell them which
 * subset of procs they can have.
 *
 * For now, we just make an array of all procs and give that to the
 * one-and-only-one RPI that we'll be using.
 *
 * The selected RPI module is at the head of the list.
 */
int
lam_ssi_rpi_base_init(void)
{
  int i;
  int maxtag = lam_mpi_max_tag, maxcid = lam_mpi_max_cid;
  struct _proc **to_rpi, *p;
  int nprocs = lam_nprocs();
  lam_ssi_module_t *rpi_module, *m;
  lam_ssi_rpi_t *r;
  const lam_ssi_rpi_actions_t *rpia;

  to_rpi = malloc(sizeof(struct _proc *) * nprocs);
  if (to_rpi == NULL)
    return LAMERROR;
  for (i = 0, p = lam_topproc(); p != NULL; ++i, p = lam_nextproc())
    to_rpi[i] = p;

  /* Setup the RPI function pointers and base module */

  rpi_module = (lam_ssi_module_t*) al_top(lam_ssi_rpi_base_available);
  lam_ssi_rpi_base_module = *((lam_ssi_rpi_t*) rpi_module->lsm_module);

  /* Go through and close all the other modules */

  for (m = (lam_ssi_module_t*) al_next(lam_ssi_rpi_base_available, 
                                       rpi_module); m != NULL;
       m = (lam_ssi_module_t*) al_next(lam_ssi_rpi_base_available, m)) {
    r = (lam_ssi_rpi_t*) m->lsm_module;
    if (r->lsr_meta_info.ssi_close_module != NULL)
      r->lsr_meta_info.ssi_close_module();
  }

  /* Save the resulting actions struct in the global variable.  This
     will need to change when we go multi-RPI. */

  rpia = lam_ssi_rpi_base_module.lsr_init(to_rpi, nprocs, &maxtag, &maxcid);
  if (rpia == NULL) {
    free(to_rpi);
    return LAMERROR;
  }
  lam_ssi_rpi = *rpia;
  if (maxtag > 0 && maxtag < lam_mpi_max_tag)
    lam_mpi_max_tag = maxtag;
  if (maxcid > 0 && maxcid < lam_mpi_max_cid)
    lam_mpi_max_cid = maxcid;

  /* Announce */

  if (lam_ssi_rpi_verbose > 0)
    lam_debug(lam_ssi_rpi_did, " selected RPI module %s", 
              lam_ssi_rpi_base_module.lsr_meta_info.ssi_module_name);

  /* All done */

  free(to_rpi);
  return 0;
}
