dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2002 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: lam_rpi_gm_params.m4,v 1.5.2.3 2004/03/12 01:19:06 vsahay Exp $
dnl

AC_DEFUN([LAM_SSI_RPI_GM_PARAMS],[
#
# Arguments: none
#
# Dependencies: None
#
# Setup the command line args to the gm RPI
#
# Sets:
#
# GMSHORT: subst
# GMTINY: subst
# GMMAXPORT: subst
# GMPORT: subst
#

GMTINY=1024
AC_ARG_WITH(gm-tiny, 
    AC_HELP_STRING([--with-gm-tiny=BYTES],
		   [use BYTES as the size of the longest GM tiny message]))
if test -n "$with_gm_tiny"; then
    GMTINY="$with_gm_tiny"
fi
AC_MSG_CHECKING([for GM tiny message length])
AC_MSG_RESULT([$GMTINY bytes])

GMSHORT=8192
AC_ARG_WITH(gm-short, 
    AC_HELP_STRING([--with-gm-short=BYTES],
		   [use BYTES as the size of the longest GM short message]))
if test -n "$with_gm_short"; then
    GMSHORT="$with_gm_short"
fi
AC_MSG_CHECKING([for GM short message length])
AC_MSG_RESULT([$GMSHORT bytes])

GMMAXPORT=32
AC_ARG_WITH(gm-max-port, 
    AC_HELP_STRING([--with-gm-max-port=N],
		   [use N as the max gm port number to try]))
if test -n "$with_gm_max_port"; then
    GMMAXPORT="$with_gm_max_port"
fi
AC_MSG_CHECKING([for GM max port number])
AC_MSG_RESULT([$GMMAXPORT])

GMPORT=-1
AC_ARG_WITH(gm-port, 
    AC_HELP_STRING([--with-gm-port=N],
		   [use N as the gm port for all jobs (default -1)]))
if test -n "$with_gm_port"; then
    GMPORT="$with_gm_port"
fi
AC_MSG_CHECKING([for fixed gm port number to use])
if test "$GMPORT" = "-1"; then
    AC_MSG_RESULT([none -- search at runtime])
else
    AC_MSG_RESULT([$GMPORT])
fi

# Options dealing with pinning / replacement malloc package.  Don't do
# anything with them now (as opposed to the other options) because we
# need the results of some tests before we can do anything intelligent
# with them.

AC_ARG_ENABLE(rpi-gm-ptmalloc,
    AC_HELP_STRING([--disable-rpi-gm-ptmalloc],
		   [disable use of ptmalloc replacement malloc package (automatically disabled on Solaris)]))

# Set the tunable params so that the RPI compiles with them

AC_SUBST(GMPORT)
AC_SUBST(GMMAXPORT)
AC_SUBST(GMSHORT)
AC_SUBST(GMTINY)])dnl
