/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: rpi_gm_actions.h,v 1.5.2.3 2004/03/12 01:19:10 vsahay Exp $
 */

#ifndef LAM_SSI_RPI_GM_ACTIONS_H
#define LAM_SSI_RPI_GM_ACTIONS_H

#include <gm.h>

#include <mpisys.h>
#include <rpisys.h>


/*
 * public typedefs
 */

typedef struct lam_ssi_rpi_gm_port {
  struct gm_port *rgp_gm_port;
  int rgp_port_id;
  unsigned int rgp_local_node_id;
  unsigned int rgp_global_node_id;
} lam_ssi_rpi_gm_port_t;


/*
 * public functions
 */

int lam_ssi_rpi_gm_gm_setup(struct _proc *p);
int lam_ssi_rpi_gm_get_port(struct _proc *p, lam_ssi_rpi_gm_port_t *port);
int lam_ssi_rpi_gm_gm_finalize(lam_ssi_rpi_gm_port_t *port);

int lam_ssi_rpi_gm_gm_advance(void);

int lam_ssi_rpi_gm_push_envelope(MPI_Request req, 
				 gm_send_completion_callback_t callback);
int lam_ssi_rpi_gm_push_short_body(MPI_Request req,
				   gm_send_completion_callback_t cbk_unpin,
				   gm_send_completion_callback_t cbk_no_unpin);

int lam_ssi_rpi_gm_provide_buffer(char *buffer, unsigned int size, int tag);
int lam_ssi_rpi_gm_push_long_body(MPI_Request req,
				  gm_send_completion_callback_t cbk_unpin,
				  gm_send_completion_callback_t cbk_no_unpin);


#endif /* LAM_SSI_RPI_GM_ACTIONS_H */
