/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 *	$Id: rpi_gm_proc.h,v 1.2.2.3 2004/03/12 01:19:10 vsahay Exp $
 *
 *	Function:	- gm proc specification
 */

#ifndef LAM_SSI_RPI_GM_PROC_H
#define LAM_SSI_RPI_GM_PROC_H

#include <lam_config.h>

#include <lam-ssi-rpi.h>
#include <mpisys.h>


/*
 * gm-specific MPI process data
 */

struct lam_ssi_rpi_proc {
  /* This needs to be here for the unexepcted message handling (i.e.,
     partially received unexpected messages), but cp_nbfde is not used
     in this RPI */

  struct lam_ssi_rpi_cbuf_msg *cp_bmsg;
  int cp_nbfde;

  /* point up to the main _proc so that we can do checks for things
     like LAM_PHOMOG.  This is an optimization -- in the gm RPI, we
     usually pass around just a (struct lam_ssi_rpi_proc*) because we
     do 95% of the work with just this.  But periodically, a few
     things new stuff from the upper-level proc (e.g., p_mode &
     LAM_PHOMOG), so we need to be able to find the upper-level proc
     when we only have the lam_ssi_rpi_proc. */

  struct _proc *cp_proc;

  /* gm port to use, with cached values for the port ID and node ID */

  struct gm_port  *cp_gm_port;
  unsigned int    cp_port_id;
  unsigned int    cp_local_node_id;
  unsigned int    cp_global_node_id;

  /* Queues for the pending sends and receives on this proc */

  struct lam_ssi_rpi_gm_reqlist_t cp_pending_recvs;
  struct lam_ssi_rpi_gm_reqlist_t cp_pending_acks;

  /* Request that has been partially received (since it may take
     multiple sends to send an entire message -- but we know that the
     sender will always send them in order, with no other intervening
     sends). */

  MPI_Request cp_current_recv_req;
};


#endif	/* LAM_SSI_RPI_GM_PROC_H */
