//
// Copyright (c) 2001-2002 The Trustees of Indiana University.  
//                         All rights reserved.
// Copyright (c) 1998-2001 University of Notre Dame. 
//                         All rights reserved.
// Copyright (c) 1994-1998 The Ohio State University.  
//                         All rights reserved.
// 
// This file is part of the LAM/MPI software package.  For license
// information, see the LICENSE file in the top level directory of the
// LAM/MPI source distribution.
// 
// $HEADER$
//
//	$Id: wrap_engine.cc,v 1.4 2003/01/26 22:22:14 jsquyres Exp $
//
//	Function: - wrapper for C program compilation.  This is the
//	back-end engine for all the wrapper compilers.  It takes
//	parameters for each different wrapper compiler and invokes the
//	rest of the wrapper compiler functionality.
//

#include <lam_config.h>

#include <lamwrap.h>


using namespace std;


//
// lam_wrap_engine
//
// Back-end entry point for the wrapper compiler functionality.  All
// three wrapper compilers invoke this function.
//
int
lam_wrap_engine(int argc, char* argv[],
		const lam_sv_t& env_vars, const string& default_compiler,
		bool want_cxx_includes, bool want_cxx_libs,
		bool want_f77_includes,
		const string& extra_args)
{
  int ret(0);

  string buildtop;
  string srctop;
  string prefix;

  lam_sv_t str_vec;

  lam_sv_t compiler;
  lam_sv_t cflags;
  lam_sv_t user_args;
  lam_sv_t ldflags;
  lam_sv_t libs;
  lam_sv_t extra_flags;

  lam_sv_t cmd_line;

  // Parse command line

  lam_wrap_parse_args(argc, argv);

  // Get the top library directory and top include directory

  lam_wrap_get_tops(prefix, srctop, buildtop);

  // Get the compiler

  lam_wrap_get_compiler(env_vars, default_compiler, compiler);  

  // Build the CFLAGS

  lam_wrap_build_cflags(want_cxx_includes, want_f77_includes, prefix, 
			srctop, buildtop, cflags);

  // Build the user arguments

  lam_wrap_build_user_args(argc, argv, user_args);

  // Build the LDFLAGS

  lam_wrap_build_ldflags(prefix, ldflags);

  // Build the LIBS

  lam_wrap_build_libs(prefix, buildtop, want_cxx_libs, libs);

  // Build any extra arguments

  lam_wrap_build_extra_flags(extra_args, extra_flags);

  // Now assemble the command line

  cmd_line.clear();
  lam_wrap_append_sv(compiler, cmd_line);
  lam_wrap_append_sv(cflags, cmd_line);
  lam_wrap_append_sv(extra_flags, cmd_line);
  lam_wrap_append_sv(user_args, cmd_line);
  lam_wrap_append_sv(ldflags, cmd_line);
  lam_wrap_append_sv(libs, cmd_line);

  // Display or execute?

  if (fl_show)
    lam_wrap_print_sv(cmd_line);
  else
    ret = lam_wrap_exec_sv(cmd_line);

  // That's all she wrote

  return ret;
}
