#include "ldm-getenv-bool.h"

struct ldm_info {
    gchar    *server;
    gchar    *vty;
    gchar    *display;
    gchar    *fontpath;
    gchar    *override_port;
    gchar    *authfile;
    gchar    *username;
    gchar    *password;
    gchar    *lang;
    gchar    *session;
    gchar    *xsession;
    gchar    *sound_daemon;
    gchar    *greeter_prog;
    gchar    *control_socket;
    gchar    *ipaddr;
    gboolean allowguest;
    gboolean autologin;
    gboolean sound;
    gboolean localdev;
    gboolean directx;
    volatile gboolean sshsessdied;
    gint     sshfd;
    GIOChannel *greeterr;
    GIOChannel *greeterw;
    GPid     sshpid;
    GPid     xserverpid;
    GPid     greeterpid;
};

/* forward decls */

void die(char *msg);
pid_t ldm_spawn (gchar *command, gint *rfd, gint *wfd, void (*setup)(), gpointer data);
int ldm_wait(pid_t pid);
int get_userid();
int get_passwd();
int get_language();
int get_host();
int get_session();
void ssh_session();
int ssh_endsession();
void get_ipaddr();

extern struct ldm_info ldm;
extern FILE *ldmlog;

#define SENTINEL "LTSPROCKS"
#define MAXEXP 4096
