#ifndef HAVE_CNAME_RR_H
#define HAVE_CNAME_RR_H

#include "adns_rr.h"

namespace ADNS 
{
	public ref class CNAME_RR : ResourceRecord {
	private: 
		DOMAIN_NAME^ cname;
		Void UpdateRdata();

	public:
		CNAME_RR();
		DOMAIN_NAME^ GetCname();
		Void SetCname(DOMAIN_NAME^ cn);
		String^ Print();
		Void ToCanonical();
		CNAME_RR^ Clone();
		static ResourceRecord^ ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start);		
		static String^ PrintRR(ResourceRecord^ rec);
		static ResourceRecord^ CloneRR(ResourceRecord^ rec);
	};


}

#endif
