import unittest, os, linda, shutil, tempfile
from po_count import POFileParser
from linda.debug import dprint
from linda.funcs import run_external_cmd
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks

linda.checks = Checks()

class DpkgCheckBinaryTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/dpkg.py', {'_': __builtins__['_'], 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['binary'][1]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/binary_dpkg.tar.gz' % \
            self.instance.information['dir'])
        self.po_keys = POFileParser('po/en.po')
        
    def tearDown(self):
        if self.instance.information.has_key('dir'):
            shutil.rmtree(self.instance.information['dir'])
    
    def test_newer(self):
        "Check the sanity of DpkgCheck"
        method = getattr(self.instance, 'newer_feature')
        self.instance.file = '%s/current_style.deb' % \
            self.instance.information['dir']
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        self.instance.file = '%s/new_style.deb' % \
            self.instance.information['dir']
        method()
        self.assert_('newer-feature-than-allowed' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'newer-feature-than-allowed'), True)

